/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jms.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.internal.jms.util.MessageUtil;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSCommitRequest
extends RequestWithConfirmation<String[]> {
    private int sessionID;
    private List<MessageImpl> messages;

    public JMSCommitRequest(IChannel channel, int sessionID, List<MessageImpl> messages) {
        super(channel);
        this.sessionID = sessionID;
        this.messages = messages;
    }

    protected short getSignalID() {
        return 12;
    }

    protected void requesting(ExtendedDataOutputStream out) throws IOException {
        out.writeInt(this.sessionID);
        out.writeInt(this.messages.size());
        for (MessageImpl message : this.messages) {
            MessageUtil.write(out, message);
        }
    }

    protected String[] confirming(ExtendedDataInputStream in) throws IOException {
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        String[] messageIDs = new String[size];
        int i = 0;
        while (i < size) {
            messageIDs[i] = in.readString();
            ++i;
        }
        return messageIDs;
    }
}

