/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db.internal.hsqldb;

import java.sql.Driver;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.hsqldb.HSQLDBDataSource;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.hsqldb.jdbcDriver;

public class HSQLDBAdapter
extends DBAdapter {
    private static final String NAME = "hsqldb";
    public static final String VERSION = "1.8.0.8";

    public HSQLDBAdapter() {
        super(NAME, VERSION);
    }

    public Driver getJDBCDriver() {
        return new jdbcDriver();
    }

    public DataSource createJDBCDataSource() {
        return new HSQLDBDataSource();
    }

    protected String getTypeName(IDBField field) {
        DBType type = field.getType();
        switch (type) {
            case BOOLEAN: 
            case BIT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return type.toString();
            }
            case LONGVARCHAR: {
                return "LONGVARCHAR";
            }
            case LONGVARBINARY: {
                return "LONGVARBINARY";
            }
            case BLOB: {
                return "LONGVARBINARY";
            }
            case CLOB: {
                return "LONGVARCHAR";
            }
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return String.valueOf(type.toString()) + field.formatPrecision();
            }
            case NUMERIC: 
            case DECIMAL: {
                return String.valueOf(type.toString()) + field.formatPrecisionAndScale();
            }
        }
        return super.getTypeName(field);
    }

    public String[] getReservedWords() {
        return this.getSQL92ReservedWords();
    }
}

