/*
 * Decompiled with CFR 0.152.
 */
package temporal.mod;

import java.util.Date;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import temporal.Temporal;
import temporal.TemporalPackage;
import temporal.mod.TemporalDateProvider;
import temporal.mod.TemporalEStoreImpl;
import temporal.mod.TemporalUtil;

public class TemporalEStoreHandler {
    private static final EClass temporalEClass = TemporalPackage.eINSTANCE.getTemporal();
    private static final TemporalDateProvider temporalDateProvider = TemporalDateProvider.eINSTANCE;

    public static boolean set(InternalEObject givenEObject, EStructuralFeature feature, int index, Object value, Object[] retOldValue) {
        boolean handled = false;
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateMutatorTo((EObject)givenEObject, feature);
        if (version != null) {
            if (index == -1) {
                retOldValue[0] = TemporalEStoreHandler.getObject((EObject)version, feature);
                version.eSet(feature, value);
                TemporalEStoreHandler.propagateSetToNextVersions((EObject)version, feature, index, value);
            } else {
                retOldValue[0] = TemporalEStoreHandler.getList((EObject)version, feature).set(index, value);
            }
            handled = true;
        } else if (TemporalEStoreHandler.isTemporalFeature((EObject)givenEObject, feature)) {
            TemporalEStoreHandler.nextEStore((EObject)givenEObject).set(givenEObject, feature, index, value);
            TemporalEStoreHandler.setTouchedAttribute((EObject)givenEObject, feature);
            TemporalEStoreHandler.propagateSetToNextVersions((EObject)givenEObject, feature, index, value);
        }
        return handled;
    }

    public static boolean add(InternalEObject givenEObject, EStructuralFeature feature, int index, Object value) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateMutatorTo((EObject)givenEObject, feature);
        if (version != null) {
            TemporalEStoreHandler.nextEStore((EObject)version).add(version, feature, index, value);
            return true;
        }
        return false;
    }

    public static boolean clear(InternalEObject givenEObject, EStructuralFeature feature) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateMutatorTo((EObject)givenEObject, feature);
        if (version != null) {
            TemporalEStoreHandler.nextEStore((EObject)version).clear(version, feature);
            return true;
        }
        return false;
    }

    public static boolean move(InternalEObject givenEObject, EStructuralFeature feature, int targetIndex, int sourceIndex, Object[] retValue) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateMutatorTo((EObject)givenEObject, feature);
        if (version != null) {
            retValue[0] = TemporalEStoreHandler.nextEStore((EObject)version).move(version, feature, targetIndex, sourceIndex);
            return true;
        }
        return false;
    }

    public static boolean remove(InternalEObject givenEObject, EStructuralFeature feature, int index, Object[] retOldValue) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateMutatorTo((EObject)givenEObject, feature);
        if (version != null) {
            retOldValue[0] = TemporalEStoreHandler.nextEStore((EObject)version).remove(version, feature, index);
            return true;
        }
        return false;
    }

    public static boolean get(InternalEObject givenEObject, EStructuralFeature feature, int index, Object[] retValue) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateAccessorTo((EObject)givenEObject, feature);
        if (version != null) {
            retValue[0] = index == -1 ? TemporalEStoreHandler.getObject((EObject)version, feature) : TemporalEStoreHandler.getList((EObject)version, feature).get(index);
            return true;
        }
        return false;
    }

    public static boolean size(InternalEObject givenEObject, EStructuralFeature feature, int[] retValue) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateAccessorTo((EObject)givenEObject, feature);
        if (version != null) {
            retValue[0] = TemporalEStoreHandler.nextEStore((EObject)version).size(version, feature);
            return true;
        }
        return false;
    }

    public static boolean lastIndexOf(InternalEObject givenEObject, EStructuralFeature feature, Object value, int[] retValue) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateAccessorTo((EObject)givenEObject, feature);
        if (version != null) {
            retValue[0] = TemporalEStoreHandler.nextEStore((EObject)version).lastIndexOf(version, feature, value);
            return true;
        }
        return false;
    }

    public static boolean indexOf(InternalEObject givenEObject, EStructuralFeature feature, Object value, int[] retValue) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateAccessorTo((EObject)givenEObject, feature);
        if (version != null) {
            retValue[0] = TemporalEStoreHandler.nextEStore((EObject)version).indexOf(version, feature, value);
            return true;
        }
        return false;
    }

    public static boolean toArray(InternalEObject givenEObject, EStructuralFeature feature, Object[][] retValue) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateAccessorTo((EObject)givenEObject, feature);
        if (version != null) {
            retValue[0] = TemporalEStoreHandler.nextEStore((EObject)version).toArray(version, feature);
            return true;
        }
        return false;
    }

    public static boolean toArray(InternalEObject givenEObject, EStructuralFeature feature, Object[] array, Object[][] retValue) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateAccessorTo((EObject)givenEObject, feature);
        if (version != null) {
            retValue[0] = TemporalEStoreHandler.nextEStore((EObject)version).toArray(version, feature, array);
            return true;
        }
        return false;
    }

    public static boolean isEmpty(InternalEObject givenEObject, EStructuralFeature feature, boolean[] retValue) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateAccessorTo((EObject)givenEObject, feature);
        if (version != null) {
            retValue[0] = TemporalEStoreHandler.nextEStore((EObject)version).isEmpty(version, feature);
            return true;
        }
        return false;
    }

    public static boolean contains(InternalEObject givenEObject, EStructuralFeature feature, Object value, boolean[] retValue) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateAccessorTo((EObject)givenEObject, feature);
        if (version != null) {
            retValue[0] = TemporalEStoreHandler.nextEStore((EObject)version).contains(version, feature, value);
            return true;
        }
        return false;
    }

    public static boolean hashCode(InternalEObject givenEObject, EStructuralFeature feature, int[] retValue) {
        InternalEObject version = TemporalEStoreHandler.findVersionToDelegateAccessorTo((EObject)givenEObject, feature);
        if (version != null) {
            retValue[0] = TemporalEStoreHandler.nextEStore((EObject)version).hashCode(version, feature);
            return true;
        }
        return false;
    }

    public static boolean isFeatureFromTemporalBaseClass(EObject givenEObject, EStructuralFeature feature) {
        EClass containingEClass = feature.getEContainingClass();
        return containingEClass == temporalEClass;
    }

    public static byte[] getTouchedAttributes(EObject givenEObject) {
        TemporalEStoreImpl temporalEStore = (TemporalEStoreImpl)((InternalEObject)givenEObject).eStore();
        byte[] touched = (byte[])temporalEStore.getNext().get((InternalEObject)givenEObject, (EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_TouchedAttributes(), -1);
        if (touched == null) {
            touched = new byte[givenEObject.eClass().getFeatureCount()];
            TemporalEStoreHandler.setTouchedAttributes((Temporal)givenEObject, touched);
        }
        return touched;
    }

    public static void setTouchedAttributes(Temporal temporal, byte[] b) {
        TemporalEStoreImpl temporalEStore = (TemporalEStoreImpl)((InternalEObject)temporal).eStore();
        temporalEStore.getNext().set((InternalEObject)temporal, (EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_TouchedAttributes(), -1, (Object)b);
    }

    private static void setTouchedAttribute(EObject givenEObject, EStructuralFeature feature) {
        int touchedId = givenEObject.eClass().getFeatureID(feature);
        TemporalEStoreHandler.getTouchedAttributes((EObject)givenEObject)[touchedId] = 1;
    }

    private static boolean isTemporalFeature(EObject givenEObject, EStructuralFeature feature) {
        return givenEObject instanceof Temporal && (feature == null || !TemporalEStoreHandler.isFeatureFromTemporalBaseClass(givenEObject, feature));
    }

    private static boolean isFeatureOnContinuity(EObject givenEObject, EStructuralFeature feature) {
        return TemporalEStoreHandler.isTemporalFeature(givenEObject, feature) && ((Temporal)givenEObject).isContinuity();
    }

    public static InternalEObject findVersionToDelegateAccessorTo(EObject givenEObject, EStructuralFeature feature) {
        InternalEObject versionToDelegateTo = null;
        if (TemporalEStoreHandler.isFeatureOnContinuity(givenEObject, feature)) {
            Temporal continuity = (Temporal)givenEObject;
            Temporal temporalObjectAtNow = continuity.currentVersion();
            if (temporalObjectAtNow == null) {
                versionToDelegateTo = (InternalEObject)TemporalEStoreHandler.createPrimordialVersion(continuity);
            } else if (temporalObjectAtNow != continuity) {
                versionToDelegateTo = (InternalEObject)temporalObjectAtNow;
            }
        }
        return versionToDelegateTo;
    }

    private static Temporal createPrimordialVersion(Temporal continuity) {
        EClass c = continuity.eClass();
        Temporal newVersion = (Temporal)c.getEPackage().getEFactoryInstance().create(c);
        newVersion.eSet((EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_Continuity(), false);
        newVersion.eSet((EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_Date(), TemporalUtil.getTrimedNow());
        newVersion.eSet((EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_VersionHolderContainment(), null);
        newVersion.eSet((EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_VersionHolder(), null);
        EList versions = continuity.versions();
        int insertIndex = versions.size();
        versions.add(insertIndex, (Object)newVersion);
        Resource resource = continuity.eResource();
        if (resource != null) {
            resource.getContents().add((Object)newVersion);
        }
        return newVersion;
    }

    public static InternalEObject findVersionToDelegateMutatorTo(EObject givenEObject, EStructuralFeature feature) {
        Date currentNowDate;
        Temporal continuityTemporal;
        InternalEObject versionToDelegateTo = null;
        if (TemporalEStoreHandler.isFeatureOnContinuity(givenEObject, feature) && !(continuityTemporal = (Temporal)givenEObject).isDateWithinVersion(currentNowDate = temporalDateProvider.now())) {
            Temporal temporalObjectAtNow = continuityTemporal.currentVersion();
            if (temporalObjectAtNow != null && temporalObjectAtNow.isDateWithinVersion(currentNowDate)) {
                versionToDelegateTo = (InternalEObject)temporalObjectAtNow;
            } else {
                continuityTemporal.createVersion();
            }
        }
        return versionToDelegateTo;
    }

    private static boolean isTouchedAttribute(EObject givenEObject, EStructuralFeature feature) {
        int touchedId = givenEObject.eClass().getFeatureID(feature);
        return TemporalEStoreHandler.getTouchedAttributes(givenEObject)[touchedId] != 0;
    }

    private static void propagateSetToNextVersions(EObject startVersion, EStructuralFeature feature, int index, Object value) {
        EList versions = ((Temporal)startVersion).versions();
        int versionIndex = versions.indexOf((Object)startVersion) - 1;
        while (versionIndex >= 0) {
            InternalEObject version = (InternalEObject)versions.get(versionIndex);
            if (TemporalEStoreHandler.isTouchedAttribute((EObject)version, feature)) break;
            TemporalEStoreHandler.nextEStore((EObject)version).set(version, feature, -1, value);
            --versionIndex;
        }
    }

    private static EList getList(EObject givenEObject, EStructuralFeature feature) {
        assert (givenEObject.eGet(feature) instanceof EList);
        return (EList)TemporalEStoreHandler.nextEStore(givenEObject).get((InternalEObject)givenEObject, feature, -1);
    }

    private static Object getObject(EObject givenEObject, EStructuralFeature feature) {
        return givenEObject.eGet(feature);
    }

    private static InternalEObject.EStore nextEStore(EObject givenEObject) {
        TemporalEStoreImpl temporalEStore = (TemporalEStoreImpl)((InternalEObject)givenEObject).eStore();
        InternalEObject.EStore nextEStore = temporalEStore.getNext();
        return nextEStore;
    }
}

