/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.examples.library.impl;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.teneo.eclipselink.examples.library.Address;
import org.eclipse.emf.teneo.eclipselink.examples.library.Book;
import org.eclipse.emf.teneo.eclipselink.examples.library.BookCategory;
import org.eclipse.emf.teneo.eclipselink.examples.library.Cover;
import org.eclipse.emf.teneo.eclipselink.examples.library.Library;
import org.eclipse.emf.teneo.eclipselink.examples.library.LibraryFactory;
import org.eclipse.emf.teneo.eclipselink.examples.library.LibraryPackage;
import org.eclipse.emf.teneo.eclipselink.examples.library.Publisher;
import org.eclipse.emf.teneo.eclipselink.examples.library.Style;
import org.eclipse.emf.teneo.eclipselink.examples.library.TWriterType;
import org.eclipse.emf.teneo.eclipselink.examples.library.Translator;
import org.eclipse.emf.teneo.eclipselink.examples.library.TypeWriter;
import org.eclipse.emf.teneo.eclipselink.examples.library.Writer;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.AddressImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.BookImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.BookStylesMapEntryImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.CoverImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.LibraryImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.PublisherImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.StringToBookMapEntryImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.StyleImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.TranslatorImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.TypeWriterImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.WriterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryFactoryImpl
extends EFactoryImpl
implements LibraryFactory {
    public static LibraryFactory init() {
        try {
            LibraryFactory theLibraryFactory = (LibraryFactory)EPackage.Registry.INSTANCE.getEFactory("http:///org/eclipse/emf/teneo/eclipselink/examples/library.ecore");
            if (theLibraryFactory != null) {
                return theLibraryFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new LibraryFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createBook();
            }
            case 1: {
                return this.createLibrary();
            }
            case 2: {
                return this.createWriter();
            }
            case 3: {
                return (EObject)this.createStringToBookMapEntry();
            }
            case 4: {
                return this.createAddress();
            }
            case 5: {
                return this.createPublisher();
            }
            case 6: {
                return this.createStyle();
            }
            case 7: {
                return (EObject)this.createBookStylesMapEntry();
            }
            case 8: {
                return this.createTranslator();
            }
            case 9: {
                return this.createTypeWriter();
            }
            case 10: {
                return this.createCover();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.createBookCategoryFromString(eDataType, initialValue);
            }
            case 13: {
                return this.createTWriterTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.convertBookCategoryToString(eDataType, instanceValue);
            }
            case 13: {
                return this.convertTWriterTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Book createBook() {
        BookImpl book = new BookImpl();
        return book;
    }

    @Override
    public Library createLibrary() {
        LibraryImpl library = new LibraryImpl();
        return library;
    }

    @Override
    public Writer createWriter() {
        WriterImpl writer = new WriterImpl();
        return writer;
    }

    public Map.Entry<String, Book> createStringToBookMapEntry() {
        StringToBookMapEntryImpl stringToBookMapEntry = new StringToBookMapEntryImpl();
        return stringToBookMapEntry;
    }

    @Override
    public Address createAddress() {
        AddressImpl address = new AddressImpl();
        return address;
    }

    @Override
    public Publisher createPublisher() {
        PublisherImpl publisher = new PublisherImpl();
        return publisher;
    }

    @Override
    public Style createStyle() {
        StyleImpl style = new StyleImpl();
        return style;
    }

    public Map.Entry<String, Style> createBookStylesMapEntry() {
        BookStylesMapEntryImpl bookStylesMapEntry = new BookStylesMapEntryImpl();
        return bookStylesMapEntry;
    }

    @Override
    public Translator createTranslator() {
        TranslatorImpl translator = new TranslatorImpl();
        return translator;
    }

    @Override
    public TypeWriter createTypeWriter() {
        TypeWriterImpl typeWriter = new TypeWriterImpl();
        return typeWriter;
    }

    @Override
    public Cover createCover() {
        CoverImpl cover = new CoverImpl();
        return cover;
    }

    public BookCategory createBookCategoryFromString(EDataType eDataType, String initialValue) {
        BookCategory result = BookCategory.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertBookCategoryToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public TWriterType createTWriterTypeFromString(EDataType eDataType, String initialValue) {
        TWriterType result = TWriterType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertTWriterTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public LibraryPackage getLibraryPackage() {
        return (LibraryPackage)this.getEPackage();
    }

    @Deprecated
    public static LibraryPackage getPackage() {
        return LibraryPackage.eINSTANCE;
    }
}

