/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.MappingPlugin;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.command.NameMatchMappingCommand;
import org.eclipse.emf.mapping.command.RemoveMappingCommand;
import org.eclipse.emf.mapping.command.TypeMatchMappingCommand;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.provider.MappedObjectItemProvider;
import org.eclipse.emf.mapping.provider.MappingItemProviderAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingItemProvider
extends MappingItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    protected ArrayList<MappedObjectItemProvider> mappedObjectItemProviderList = new ArrayList();
    protected static final String DIVIDER = " " + MappingPlugin.getPlugin().getString("_UI_Mapping_label_divider") + " ";
    protected static final String SEPARATOR = String.valueOf(MappingPlugin.getPlugin().getString("_UI_Mapping_label_separator")) + " ";

    public MappingItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public void getPropertyDescriptorsForHelper(Mapping mapping) {
        if (mapping.getEffectiveHelper() != null) {
            this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), MappingPlugin.getPlugin().getString("_UI_Transformation_label"), MappingPlugin.getPlugin().getString("_UI_Transformation_description"), (EStructuralFeature)MappingPackage.eINSTANCE.getMapping_Helper(), false){

                public Object getPropertyValue(Object thisObject) {
                    Mapping thisMapping = (Mapping)thisObject;
                    MappingHelper helper = thisMapping.getHelper();
                    if (helper != null) {
                        return helper;
                    }
                    return new TypeMappingHelperWrapper(this.adapterFactory, thisMapping, thisMapping.getEffectiveHelper());
                }
            });
        }
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            Mapping mapping = (Mapping)object;
            MappingRoot mappingRoot = mapping.getMappingRoot();
            boolean isTypeMapping = mappingRoot != null && mappingRoot.getDomain() == null;
            MappingPackage ePackage = MappingPackage.eINSTANCE;
            this.itemPropertyDescriptors = new ArrayList();
            if (isTypeMapping) {
                int count = 1;
                for (Mapping childMapping : mapping.getNested()) {
                    ItemPropertyDescriptor childMappingItemPropertyDescriptor = new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), String.valueOf(count) + ". " + MappingPlugin.getPlugin().getString("_UI_Type_mapping_label") + " ", MappingPlugin.getPlugin().getString("_UI_Type_mapping_helpers_description"), (EStructuralFeature)ePackage.getMapping_TypeMapping()){

                        public String getId(Object object) {
                            return this.displayName;
                        }
                    };
                    this.itemPropertyDescriptors.add(new ItemPropertyDescriptorDecorator(childMapping, (IItemPropertyDescriptor)childMappingItemPropertyDescriptor){

                        public Object getPropertyValue(Object o) {
                            super.getPropertyValue(o);
                            return this.object;
                        }

                        public Collection<?> getChoiceOfValues(Object o) {
                            return null;
                        }
                    });
                    ++count;
                }
            } else {
                this.getPropertyDescriptorsForHelper(mapping);
                if (mapping.getTypeMapping() != null) {
                    this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), MappingPlugin.getPlugin().getString("_UI_Type_mapping_label"), MappingPlugin.getPlugin().getString("_UI_Type_mapping_description"), (EStructuralFeature)ePackage.getMapping_TypeMapping()){

                        public Object createPropertyValueWrapper(Object o, Object v) {
                            return v;
                        }

                        public Collection<?> getChoiceOfValues(Object o) {
                            return null;
                        }
                    });
                }
            }
        }
        return this.itemPropertyDescriptors;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        Mapping mapping = (Mapping)object;
        MappingRoot mappingRoot = mapping.getMappingRoot();
        ArrayList<EReference> result = new ArrayList<EReference>();
        if (mappingRoot == null || mappingRoot.isTopToBottom()) {
            result.add(MappingPackage.eINSTANCE.getMapping_Inputs());
            result.add(MappingPackage.eINSTANCE.getMapping_Outputs());
        } else {
            result.add(MappingPackage.eINSTANCE.getMapping_Outputs());
            result.add(MappingPackage.eINSTANCE.getMapping_Inputs());
        }
        result.add(MappingPackage.eINSTANCE.getMapping_Nested());
        return result;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        Mapping mapping = (Mapping)object;
        MappingRoot mappingRoot = mapping.getMappingRoot();
        EObject refObject = (EObject)child;
        if (refObject instanceof Mapping) {
            return MappingPackage.eINSTANCE.getMapping_Nested();
        }
        if (mapping.getInputs().contains(child)) {
            return MappingPackage.eINSTANCE.getMapping_Inputs();
        }
        if (mapping.getOutputs().contains(child)) {
            return MappingPackage.eINSTANCE.getMapping_Outputs();
        }
        if (mappingRoot != null && mappingRoot.isInputObject(child)) {
            return MappingPackage.eINSTANCE.getMapping_Inputs();
        }
        if (mappingRoot != null && mappingRoot.isOutputObject(child) && mappingRoot.getDomain() != null && mappingRoot.getMappedObjects().contains(mappingRoot.getDomain().getRoot(child))) {
            return MappingPackage.eINSTANCE.getMapping_Outputs();
        }
        return super.getChildFeature(object, child);
    }

    public EStructuralFeature getSetFeature(Object object, Object value) {
        Mapping mapping = (Mapping)object;
        MappingRoot mappingRoot = mapping.getMappingRoot();
        if (mappingRoot != null && mapping != mappingRoot) {
            if (mappingRoot.isInputObject(value) && !mapping.getInputs().contains(value)) {
                return MappingPackage.eINSTANCE.getMapping_Inputs();
            }
            if (mappingRoot.isOutputObject(value) && !mapping.getOutputs().contains(value)) {
                return MappingPackage.eINSTANCE.getMapping_Outputs();
            }
        }
        return super.getSetFeature(object, value);
    }

    protected MappedObjectItemProvider getMappedObjectItemProvider(Mapping mapping, Object mappedObject) {
        for (MappedObjectItemProvider mappedObjectItemProvider : this.mappedObjectItemProviderList) {
            if (mappedObjectItemProvider.getMappedObject() != mappedObject) continue;
            return mappedObjectItemProvider;
        }
        MappedObjectItemProvider result = new MappedObjectItemProvider(this.adapterFactory, (EObject)mappedObject, mapping);
        this.mappedObjectItemProviderList.add(result);
        return result;
    }

    protected Object substituteMappedObjectItemProvider(Mapping mapping, Object object) {
        this.getChildren(mapping);
        for (MappedObjectItemProvider mappedObjectItemProvider : this.mappedObjectItemProviderList) {
            if (mappedObjectItemProvider.getMappedObject() != object) continue;
            return mappedObjectItemProvider;
        }
        if (object instanceof Collection) {
            ArrayList<MappedObjectItemProvider> result = new ArrayList<MappedObjectItemProvider>();
            block1: for (Object o : (Collection)object) {
                for (MappedObjectItemProvider mappedObjectItemProvider : this.mappedObjectItemProviderList) {
                    if (mappedObjectItemProvider.getMappedObject() != o) continue;
                    result.add(mappedObjectItemProvider);
                    continue block1;
                }
                result.add((MappedObjectItemProvider)((Object)o));
            }
            return result;
        }
        return object;
    }

    protected Object substituteMappedObject(Mapping mapping, Object object) {
        if (object instanceof MappedObjectItemProvider) {
            return ((MappedObjectItemProvider)((Object)object)).getMappedObject();
        }
        if (object instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : (Collection)object) {
                if (o instanceof MappedObjectItemProvider) {
                    result.add(((MappedObjectItemProvider)((Object)o)).getMappedObject());
                    continue;
                }
                result.add(o);
            }
            return result;
        }
        return object;
    }

    public static Iterator<?> createValueIterator(Object object) {
        if (object == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        return Collections.singleton(object).iterator();
    }

    public Collection<?> getChildren(Object object) {
        Mapping mapping = (Mapping)object;
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object input : mapping.getInputs()) {
            result.add((Object)this.getMappedObjectItemProvider(mapping, input));
        }
        for (Object output : mapping.getOutputs()) {
            result.add((Object)this.getMappedObjectItemProvider(mapping, output));
        }
        result.addAll((Collection<Object>)mapping.getNested());
        return result;
    }

    public boolean hasChildren(Object object) {
        return true;
    }

    public Object getParent(Object object) {
        return ((Mapping)object).getNestedIn();
    }

    public static Object getImage(MappingRoot mappingRoot, String prefix, Collection<?> collection) {
        return MappingItemProvider.getImage(mappingRoot, prefix, collection, false);
    }

    public static Object getImage(MappingRoot mappingRoot, String prefix, Collection<?> collection, boolean supportNone) {
        int topsSize = 0;
        int bottomsSize = 0;
        for (Object object : collection) {
            if (mappingRoot.isTopObject(object)) {
                ++topsSize;
                continue;
            }
            if (!mappingRoot.isBottomObject(object)) continue;
            ++bottomsSize;
        }
        return MappingItemProvider.getImage(prefix, topsSize, bottomsSize, supportNone);
    }

    public static Object getImage(String prefix, Collection<?> tops, Collection<?> bottoms) {
        return MappingItemProvider.getImage(prefix, tops, bottoms, false);
    }

    public static Object getImage(String prefix, Collection<?> tops, Collection<?> bottoms, boolean supportNone) {
        return MappingItemProvider.getImage(prefix, tops.size(), bottoms.size(), supportNone);
    }

    public static Object getImage(String prefix, int topsSize, int bottomsSize, boolean supportNone) {
        if (topsSize == 0) {
            if (bottomsSize == 0) {
                return MappingPlugin.getPlugin().getImage(String.valueOf(prefix) + (supportNone ? "NoneToNoneMapping" : "OneToOneMapping"));
            }
            if (bottomsSize == 1) {
                return MappingPlugin.getPlugin().getImage(String.valueOf(prefix) + (supportNone ? "NoneToOneMapping" : "OneToOneMapping"));
            }
            return MappingPlugin.getPlugin().getImage(String.valueOf(prefix) + (supportNone ? "NoneToManyMapping" : "OneToManyMapping"));
        }
        if (topsSize == 1) {
            if (bottomsSize == 0) {
                return MappingPlugin.getPlugin().getImage(String.valueOf(prefix) + (supportNone ? "OneToNoneMapping" : "OneToOneMapping"));
            }
            if (bottomsSize <= 1) {
                return MappingPlugin.getPlugin().getImage(String.valueOf(prefix) + "OneToOneMapping");
            }
            return MappingPlugin.getPlugin().getImage(String.valueOf(prefix) + "OneToManyMapping");
        }
        if (bottomsSize == 0) {
            return MappingPlugin.getPlugin().getImage(String.valueOf(prefix) + (supportNone ? "ManyToNoneMapping" : "ManyToOneMapping"));
        }
        if (bottomsSize == 1) {
            return MappingPlugin.getPlugin().getImage(String.valueOf(prefix) + "ManyToOneMapping");
        }
        return MappingPlugin.getPlugin().getImage(String.valueOf(prefix) + "ManyToManyMapping");
    }

    public Object getImage(Object object) {
        Mapping mapping = (Mapping)object;
        MappingRoot mappingRoot = mapping.getMappingRoot();
        boolean isTypeMapping = mappingRoot != null && mappingRoot.getDomain() == null;
        return MappingItemProvider.getImage(isTypeMapping ? "full/obj16/Type" : "full/obj16/", mapping.getTops(), mapping.getBottoms(), !isTypeMapping);
    }

    public static String getText(MappingRoot mappingRoot, AdapterFactory adapterFactory, Collection<?> collection) {
        return MappingItemProvider.getText(mappingRoot, adapterFactory, collection, null);
    }

    public static String getText(MappingRoot mappingRoot, AdapterFactory adapterFactory, Collection<?> collection, String pathSeparator) {
        return MappingItemProvider.getText(mappingRoot, adapterFactory, collection, pathSeparator, SEPARATOR, DIVIDER);
    }

    public static String getText(MappingRoot mappingRoot, AdapterFactory adapterFactory, Collection<?> collection, String pathSeparator, String objectSeparator, String divider) {
        Object parent;
        int index;
        AdapterFactoryItemDelegator labelProvider = new AdapterFactoryItemDelegator(adapterFactory);
        boolean needsComma = false;
        StringBuffer result = new StringBuffer();
        for (Object object : collection) {
            EObject input = (EObject)object;
            if (!mappingRoot.isTopObject(input)) continue;
            if (needsComma) {
                result.append(objectSeparator);
            } else {
                needsComma = true;
            }
            index = result.length();
            result.append(labelProvider.getText((Object)input));
            if (pathSeparator == null) continue;
            parent = mappingRoot.getDomain().getParent(input);
            while (parent instanceof EObject) {
                result.insert(index, String.valueOf(labelProvider.getText(parent)) + pathSeparator);
                parent = mappingRoot.getDomain().getParent(parent);
            }
        }
        result.append(divider);
        needsComma = false;
        for (Object object : collection) {
            EObject output = (EObject)object;
            if (!mappingRoot.isBottomObject(output)) continue;
            if (needsComma) {
                result.append(objectSeparator);
            } else {
                needsComma = true;
            }
            index = result.length();
            result.append(labelProvider.getText((Object)output));
            if (pathSeparator == null) continue;
            parent = mappingRoot.getDomain().getParent(output);
            while (parent != null) {
                result.insert(index, String.valueOf(labelProvider.getText(parent)) + pathSeparator);
                parent = mappingRoot.getDomain().getParent(parent);
            }
        }
        return result.toString();
    }

    public static String getText(MappingRoot mappingRoot, AdapterFactory adapterFactory, Collection<?> inputs, Collection<?> outputs) {
        return MappingItemProvider.getText(mappingRoot, adapterFactory, inputs, outputs, SEPARATOR, DIVIDER);
    }

    public static String getText(MappingRoot mappingRoot, AdapterFactory adapterFactory, Collection<?> inputs, Collection<?> outputs, String objectSeparator, String divider) {
        AdapterFactoryItemDelegator labelProvider = new AdapterFactoryItemDelegator(adapterFactory);
        boolean needsComma = false;
        StringBuffer result = new StringBuffer();
        for (Object input : inputs) {
            if (needsComma) {
                result.append(objectSeparator);
            } else {
                needsComma = true;
            }
            result.append(labelProvider.getText(input));
        }
        result.append(divider);
        needsComma = false;
        for (Object output : outputs) {
            if (needsComma) {
                result.append(objectSeparator);
            } else {
                needsComma = true;
            }
            result.append(labelProvider.getText(output));
        }
        return result.toString();
    }

    public String getText(Object object) {
        Mapping mapping = (Mapping)object;
        return MappingItemProvider.getText(mapping.getMappingRoot(), (AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), mapping.getTops(), mapping.getBottoms());
    }

    public void notifyChanged(Notification msg) {
        MappingPackage ePackage = MappingPackage.eINSTANCE;
        if (msg.getFeature() == ePackage.getMapping_Inputs() || msg.getFeature() == ePackage.getMapping_Outputs()) {
            this.fireNotifyChanged(msg);
            ENotificationImpl note = new ENotificationImpl((InternalEObject)msg.getNotifier(), 1, null, null, null, -1);
            this.fireNotifyChanged((Notification)note);
        } else if (msg.getFeature() == ePackage.getMapping_Helper() || msg.getFeature() == ePackage.getMapping_TypeMapping()) {
            this.itemPropertyDescriptors = null;
            this.fireNotifyChanged(msg);
        } else if (msg.getFeature() == ePackage.getMapping_Nested() || msg.getFeature() == ePackage.getMapping_NestedIn()) {
            this.fireNotifyChanged(msg);
        } else {
            super.notifyChanged(msg);
        }
    }

    public Command createCommand(Object object, EditingDomain editingDomain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        if (editingDomain instanceof MappingDomain) {
            MappingDomain mappingDomain = (MappingDomain)editingDomain;
            if (commandClass == NameMatchMappingCommand.class) {
                return this.createNameMatchMappingCommand(mappingDomain, (Mapping)commandParameter.getOwner());
            }
            if (commandClass == TypeMatchMappingCommand.class) {
                return this.createTypeMatchMappingCommand(mappingDomain, (Mapping)commandParameter.getOwner());
            }
        }
        commandParameter.collection = (Collection)this.substituteMappedObject((Mapping)object, commandParameter.getCollection());
        commandParameter.value = this.substituteMappedObject((Mapping)object, commandParameter.getValue());
        return super.createCommand(object, editingDomain, commandClass, commandParameter);
    }

    protected Command createNameMatchMappingCommand(MappingDomain domain, Mapping mapping) {
        return new NameMatchMappingCommand(domain, mapping);
    }

    protected Command createTypeMatchMappingCommand(MappingDomain domain, Mapping mapping) {
        return new TypeMatchMappingCommand(domain, mapping);
    }

    protected Command createRemoveCommand(final EditingDomain domain, EObject owner, final EStructuralFeature feature, Collection<?> collection) {
        final Mapping mappingOwner = (Mapping)owner;
        final MappingRoot mappingRoot = mappingOwner.getMappingRoot();
        if (feature == MappingPackage.eINSTANCE.getMapping_Nested()) {
            final Collection<?> mappingCollection = collection;
            return new CommandWrapper(super.createRemoveCommand(domain, owner, feature, collection)){

                protected void register() {
                    for (Object object : mappingCollection) {
                        Mapping mapping = (Mapping)object;
                        TreeIterator<Mapping> mappings = mapping.treeIterator();
                        while (mappings.hasNext()) {
                            Mapping childMapping = (Mapping)mappings.next();
                            mappingRoot.register(childMapping);
                        }
                    }
                }

                protected void deregister() {
                    for (Object object : mappingCollection) {
                        Mapping mapping = (Mapping)object;
                        TreeIterator<Mapping> mappings = mapping.treeIterator();
                        while (mappings.hasNext()) {
                            Mapping childMapping = (Mapping)mappings.next();
                            mappingRoot.deregister(childMapping);
                        }
                    }
                }

                public void execute() {
                    this.deregister();
                    super.execute();
                }

                public void undo() {
                    super.undo();
                    this.register();
                }

                public void redo() {
                    this.deregister();
                    super.redo();
                }
            };
        }
        if (feature == MappingPackage.eINSTANCE.getMapping_Inputs() || feature == MappingPackage.eINSTANCE.getMapping_Outputs()) {
            final Collection<?> mappedObjectsCollection = collection;
            final boolean removingInputs = feature == MappingPackage.eINSTANCE.getMapping_Inputs();
            return new CommandWrapper(super.createRemoveCommand(domain, owner, feature, collection)){
                protected CompoundCommand commands;

                protected boolean prepare() {
                    boolean result = true;
                    Object inputs = mappingOwner.getInputs();
                    Object outputs = mappingOwner.getOutputs();
                    if (removingInputs) {
                        inputs = new ArrayList<EObject>((Collection<EObject>)inputs);
                        inputs.removeAll(mappedObjectsCollection);
                    } else {
                        outputs = new ArrayList<EObject>((Collection<EObject>)outputs);
                        outputs.removeAll(mappedObjectsCollection);
                    }
                    if (!mappingRoot.canCreateMapping((Collection<?>)inputs, (Collection<?>)outputs, mappingOwner)) {
                        result = false;
                    }
                    return result;
                }

                protected void register() {
                    for (Object object : mappedObjectsCollection) {
                        mappingRoot.getMappedObjectState(object).getMappings().add(mappingOwner);
                    }
                }

                protected void deregister() {
                    for (Object object : mappedObjectsCollection) {
                        mappingRoot.getMappedObjectState(object).getMappings().remove(mappingOwner);
                    }
                }

                public void execute() {
                    if (mappingOwner == mappingRoot) {
                        this.commands = new CompoundCommand();
                        HashSet<Object> collectionOfDescendants = new HashSet<Object>();
                        for (Object object : mappedObjectsCollection) {
                            TreeIterator descendants = domain.treeIterator(object);
                            while (descendants.hasNext()) {
                                Object descendant = descendants.next();
                                collectionOfDescendants.add(descendant);
                            }
                        }
                        TreeIterator<Mapping> mappings = mappingRoot.treeIterator(false);
                        while (mappings.hasNext()) {
                            Mapping mapping = (Mapping)mappings.next();
                            if (!mapping.getInputs().isEmpty() && collectionOfDescendants.containsAll((Collection<?>)mapping.getInputs()) || !mapping.getOutputs().isEmpty() && collectionOfDescendants.containsAll((Collection<?>)mapping.getOutputs())) {
                                Command command = RemoveMappingCommand.create((MappingDomain)domain, mapping);
                                this.commands.appendIfCanExecute(command);
                                continue;
                            }
                            if (feature == MappingPackage.eINSTANCE.getMapping_Inputs()) {
                                ArrayList<EObject> inputsToRemove = new ArrayList<EObject>((Collection<EObject>)mapping.getInputs());
                                inputsToRemove.retainAll(collectionOfDescendants);
                                if (inputsToRemove.isEmpty()) continue;
                                Command removeInputsCommand = RemoveCommand.create((EditingDomain)domain, (Object)mapping, (Object)MappingPackage.eINSTANCE.getMapping_Inputs(), inputsToRemove);
                                this.commands.appendIfCanExecute(removeInputsCommand);
                                continue;
                            }
                            ArrayList<EObject> outputsToRemove = new ArrayList<EObject>((Collection<EObject>)mapping.getOutputs());
                            outputsToRemove.retainAll(collectionOfDescendants);
                            if (outputsToRemove.isEmpty()) continue;
                            Command removeOutputsCommand = RemoveCommand.create((EditingDomain)domain, (Object)mapping, (Object)MappingPackage.eINSTANCE.getMapping_Outputs(), outputsToRemove);
                            this.commands.appendIfCanExecute(removeOutputsCommand);
                        }
                        this.commands.execute();
                    }
                    super.execute();
                    this.deregister();
                }

                public void undo() {
                    super.undo();
                    if (this.commands != null) {
                        this.commands.undo();
                    }
                    this.register();
                }

                public void redo() {
                    if (this.commands != null) {
                        this.commands.redo();
                    }
                    super.redo();
                    this.deregister();
                }

                public void dispose() {
                    super.dispose();
                    if (this.commands != null) {
                        this.command.dispose();
                    }
                }
            };
        }
        return super.createRemoveCommand(domain, owner, feature, collection);
    }

    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        final Mapping mappingOwner = (Mapping)owner;
        final MappingRoot mappingRoot = mappingOwner.getMappingRoot();
        if (feature == MappingPackage.eINSTANCE.getMapping_Inputs() || feature == MappingPackage.eINSTANCE.getMapping_Outputs()) {
            final Collection<?> mappedObjectsCollection = collection;
            final boolean addingInputs = feature == MappingPackage.eINSTANCE.getMapping_Inputs();
            return new CommandWrapper(super.createAddCommand(domain, owner, feature, collection, index)){

                protected boolean prepare() {
                    boolean result = true;
                    Object inputs = mappingOwner.getInputs();
                    Object outputs = mappingOwner.getOutputs();
                    if (addingInputs) {
                        inputs = new ArrayList<EObject>((Collection<EObject>)inputs);
                        Collection eObjects = mappedObjectsCollection;
                        inputs.addAll(eObjects);
                    } else {
                        outputs = new ArrayList<EObject>((Collection<EObject>)outputs);
                        Collection eObjects = mappedObjectsCollection;
                        outputs.addAll(eObjects);
                    }
                    if (!mappingRoot.canCreateMapping((Collection<?>)inputs, (Collection<?>)outputs, mappingOwner)) {
                        result = false;
                    }
                    return result;
                }

                protected void register() {
                    for (Object object : mappedObjectsCollection) {
                        mappingRoot.getMappedObjectState(object).getMappings().add(mappingOwner);
                    }
                }

                protected void deregister() {
                    for (Object object : mappedObjectsCollection) {
                        mappingRoot.getMappedObjectState(object).getMappings().remove(mappingOwner);
                    }
                }

                public void execute() {
                    super.execute();
                    this.register();
                }

                public void undo() {
                    this.deregister();
                    super.undo();
                }

                public void redo() {
                    super.redo();
                    this.register();
                }

                public Collection<?> getAffectedObjects() {
                    return (Collection)MappingItemProvider.this.substituteMappedObjectItemProvider(mappingOwner, super.getAffectedObjects());
                }

                public Collection<?> getResult() {
                    return (Collection)MappingItemProvider.this.substituteMappedObjectItemProvider(mappingOwner, super.getResult());
                }
            };
        }
        return super.createAddCommand(domain, owner, feature, collection, index);
    }

    protected Command createMoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, EObject value, int index) {
        final Mapping mappingOwner = (Mapping)owner;
        if (feature == MappingPackage.eINSTANCE.getMapping_Inputs() || feature == MappingPackage.eINSTANCE.getMapping_Outputs()) {
            return new CommandWrapper(super.createMoveCommand(domain, owner, feature, (Object)value, index)){

                public Collection<?> getAffectedObjects() {
                    return (Collection)MappingItemProvider.this.substituteMappedObjectItemProvider(mappingOwner, super.getAffectedObjects());
                }

                public Collection<?> getResult() {
                    return (Collection)MappingItemProvider.this.substituteMappedObjectItemProvider(mappingOwner, super.getResult());
                }
            };
        }
        return super.createMoveCommand(domain, owner, feature, (Object)value, index);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature == MappingPackage.eINSTANCE.getMapping_Inputs() || feature == MappingPackage.eINSTANCE.getMapping_Outputs()) {
            return this.createAddCommand(domain, owner, feature, (Collection)Collections.singleton(value), -1);
        }
        return super.createSetCommand(domain, owner, feature, value);
    }

    public void dispose() {
        for (MappedObjectItemProvider mappedObjectItemProvider : this.mappedObjectItemProviderList) {
            mappedObjectItemProvider.dispose();
        }
        super.dispose();
    }

    public ResourceLocator getResourceLocator() {
        return MappingPlugin.INSTANCE;
    }

    public static class TypeMappingHelperWrapper
    extends ItemPropertyDescriptor.PropertyValueWrapper {
        protected Mapping mapping;
        protected MappingHelper typeMappingHelper;

        public TypeMappingHelperWrapper(AdapterFactory adapterFactory, Mapping mapping, MappingHelper typeMappingHelper) {
            super(adapterFactory, (Object)mapping, (Object)typeMappingHelper, (Object)typeMappingHelper);
            this.mapping = mapping;
            this.typeMappingHelper = typeMappingHelper;
        }

        protected IItemPropertyDescriptor createPropertyDescriptorDecorator(Object object, IItemPropertyDescriptor decoratedDescriptor) {
            return new ItemPropertyDescriptorDecorator(object, decoratedDescriptor){

                public void setPropertyValue(Object thisObject, final Object value) {
                    final MappingDomain domain = TypeMappingHelperWrapper.this.mapping.getMappingRoot().getDomain();
                    final Object feature = this.itemPropertyDescriptor.getFeature(value);
                    StrictCompoundCommand compound = new StrictCompoundCommand();
                    final Command copyCommand = CopyCommand.create((EditingDomain)domain, (Object)TypeMappingHelperWrapper.this.typeMappingHelper);
                    compound.append(copyCommand);
                    compound.append((Command)new CommandWrapper(){

                        protected Command createCommand() {
                            return SetCommand.create((EditingDomain)domain, copyCommand.getResult().iterator().next(), (Object)feature, (Object)value);
                        }
                    });
                    compound.append((Command)new CommandWrapper(){

                        protected Command createCommand() {
                            return SetCommand.create((EditingDomain)domain, (Object)(this).TypeMappingHelperWrapper.this.mapping, (Object)MappingPackage.eINSTANCE.getMapping_Helper(), copyCommand.getResult().iterator().next());
                        }
                    });
                    domain.getCommandStack().execute((Command)compound);
                }

                public void resetPropertyValue(Object thisObject) {
                }
            };
        }
    }
}

