/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.rose.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.importer.rose.RoseImporterPlugin;
import org.eclipse.emf.importer.rose.parser.RoseComponent;
import org.eclipse.emf.importer.rose.parser.Util;

public class RoseLoader
extends RoseComponent {
    public static final String PROGRESS = "ROSE_LOADER_PROGRESS";
    protected boolean valid;
    protected BufferedReader bufferedReader;
    protected long length = 0L;
    protected long currentLength = 0L;
    protected int progressIncrement = 10;
    protected int oldValue;
    protected int lower = 0;
    protected int upper = 100;

    public RoseLoader(String fileName, URIConverter uriConverter) throws Exception {
        try {
            if (!fileName.startsWith("\\\\")) {
                fileName = Util.updateFileName(fileName, "\\\\");
            }
            fileName = Util.updateFileName(fileName, "\\");
            fileName = Util.updateFileName(fileName, "/");
            this.bufferedReader = new BufferedReader(new FileReader(fileName));
            this.valid = true;
            this.length = new File(fileName).length();
            this.currentLength = 0L;
            this.oldValue = this.lower;
        }
        catch (Exception exception) {
            Pattern pattern = Pattern.compile(".*/([^/]*?)(?:_)?[0-9.]*/((src/)?model/[^/]*\\.cat)$");
            Matcher matcher = pattern.matcher(fileName.replaceAll("\\\\", "/"));
            if (matcher.matches()) {
                String name = matcher.group(1);
                String tail = matcher.group(2);
                InputStream inputStream = null;
                try {
                    inputStream = uriConverter.createInputStream(URI.createPlatformResourceURI((String)(String.valueOf(name) + "/" + tail)));
                }
                catch (Exception exception2) {
                    try {
                        inputStream = uriConverter.createInputStream(URI.createURI((String)("platform:/plugin/" + name + "/" + tail)));
                    }
                    catch (Exception exception3) {}
                }
                if (inputStream != null) {
                    this.bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    this.valid = true;
                    this.length = inputStream.available();
                    this.currentLength = 0L;
                    this.oldValue = this.lower;
                } else {
                    RoseImporterPlugin.INSTANCE.log(exception);
                }
            }
            RoseImporterPlugin.INSTANCE.log(exception);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setProgressIncrement(int progressIncrement) {
        this.progressIncrement = progressIncrement;
    }

    public void setLower(int lower) {
        this.lower = lower;
        this.oldValue = lower;
    }

    public int getLower() {
        return this.lower;
    }

    public void setUpper(int upper) {
        this.upper = upper;
    }

    public int getUpper() {
        return this.upper;
    }

    public String readLine() {
        try {
            int newValue;
            String line = this.bufferedReader.readLine();
            this.currentLength += (long)line.length();
            if (this.length > 0L && (newValue = this.lower + (int)(this.currentLength * (long)(this.upper - this.lower) / this.length)) >= this.oldValue + this.progressIncrement && newValue < this.upper) {
                this.firePropertyChange(PROGRESS, this.oldValue, newValue);
                this.oldValue = newValue;
            }
            return line;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void close() throws IOException {
        if (this.bufferedReader != null) {
            this.bufferedReader.close();
        }
    }
}

