/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapter;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class Generator {
    protected GeneratorAdapterFactory.Descriptor.Registry adapterFactoryDescriptorRegistry;
    protected Map packageIDToAdapterFactories;
    protected Object input;
    protected Options options;
    protected boolean initializeNeeded = true;
    protected JControlModel jControlModel;
    static /* synthetic */ Class class$0;

    public Generator() {
    }

    public Generator(GeneratorAdapterFactory.Descriptor.Registry adapterFactoryDescriptorRegistry) {
        this.adapterFactoryDescriptorRegistry = adapterFactoryDescriptorRegistry;
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        this.input = input;
        this.initialize();
        this.initializeNeeded = true;
    }

    public void requestInitialize() {
        this.initializeNeeded = true;
    }

    protected void initialize() {
        Iterator i = this.getAdapterFactories(this.input).iterator();
        while (i.hasNext()) {
            ((GeneratorAdapterFactory)i.next()).initialize(this.input);
        }
    }

    public Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public JControlModel getJControlModel() {
        if (this.jControlModel == null) {
            this.jControlModel = new JControlModel();
        }
        String facadeHelperClass = this.options.mergerFacadeHelperClass;
        if (this.jControlModel.getFacadeHelper() == null || !this.jControlModel.getFacadeHelper().getClass().getName().equals(facadeHelperClass)) {
            FacadeHelper facadeHelper = CodeGenUtil.instantiateFacadeHelper((String)facadeHelperClass);
            this.jControlModel.initialize(facadeHelper, this.options.mergeRulesURI);
        }
        return this.jControlModel;
    }

    public GeneratorAdapterFactory.Descriptor.Registry getAdapterFactoryDescriptorRegistry() {
        if (this.adapterFactoryDescriptorRegistry == null) {
            this.adapterFactoryDescriptorRegistry = new GeneratorAdapterFactory.Descriptor.DelegatingRegistry(GeneratorAdapterFactory.Descriptor.Registry.INSTANCE);
        }
        return this.adapterFactoryDescriptorRegistry;
    }

    protected Collection getAdapterFactories(Object object) {
        String packageID;
        ArrayList<GeneratorAdapterFactory> result;
        if (this.packageIDToAdapterFactories == null) {
            this.packageIDToAdapterFactories = new HashMap();
        }
        if ((result = (ArrayList<GeneratorAdapterFactory>)this.packageIDToAdapterFactories.get(packageID = this.getPackageID(object))) == null) {
            Collection descriptors = this.getAdapterFactoryDescriptorRegistry().getDescriptors(packageID);
            result = new ArrayList<GeneratorAdapterFactory>(descriptors.size());
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                GeneratorAdapterFactory adapterFactory = ((GeneratorAdapterFactory.Descriptor)i.next()).createAdapterFactory();
                adapterFactory.setGenerator(this);
                result.add(adapterFactory);
            }
            this.packageIDToAdapterFactories.put(packageID, result);
        }
        return result;
    }

    protected String getPackageID(Object object) {
        return object instanceof EObject ? ((EObject)object).eClass().getEPackage().getNsURI() : object.getClass().getPackage().getName();
    }

    protected Collection getAdapters(Object object) {
        Collection adapterFactories = this.getAdapterFactories(object);
        ArrayList<Object> result = new ArrayList<Object>(adapterFactories.size());
        Iterator i = adapterFactories.iterator();
        while (i.hasNext()) {
            Object adapter;
            AdapterFactory adapterFactory = (AdapterFactory)i.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.codegen.ecore.generator.GeneratorAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!adapterFactory.isFactoryForType((Object)clazz)) continue;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.emf.codegen.ecore.generator.GeneratorAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = adapterFactory.adapt(object, (Object)clazz2)) == null) continue;
            result.add(adapter);
        }
        return result;
    }

    private GeneratorData[] getGeneratorData(Object object, Object projectType, boolean forGenerate) {
        HashSet objects = new HashSet();
        List childrenData = this.getGeneratorData(object, projectType, forGenerate, true, false, objects);
        List parentsData = this.getGeneratorData(object, projectType, forGenerate, false, true, objects);
        ArrayList result = new ArrayList(parentsData.size() + childrenData.size());
        Collections.reverse(parentsData);
        result.addAll(parentsData);
        result.addAll(childrenData);
        return result.toArray(new GeneratorData[result.size()]);
    }

    private List getGeneratorData(Object object, Object projectType, boolean forGenerate, boolean forChildren, boolean skipFirst, Set objects) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(object);
        int i = 0;
        while (i < result.size()) {
            Object o = result.get(i);
            Collection adapters = this.getAdapters(o);
            result.remove(i);
            if (!adapters.isEmpty()) {
                Iterator adaptersIter = adapters.iterator();
                while (adaptersIter.hasNext()) {
                    GeneratorAdapter adapter = (GeneratorAdapter)adaptersIter.next();
                    if (forChildren) {
                        Collection children = forGenerate ? adapter.getGenerateChildren(o, projectType) : adapter.getCanGenerateChildren(o, projectType);
                        Iterator childrenIter = children.iterator();
                        while (childrenIter.hasNext()) {
                            Object child = childrenIter.next();
                            if (!objects.add(child)) continue;
                            result.add(child);
                        }
                    } else {
                        Object parent;
                        Object object2 = parent = forGenerate ? adapter.getGenerateParent(o, projectType) : adapter.getCanGenerateParent(o, projectType);
                        if (parent != null && objects.add(parent)) {
                            result.add(parent);
                        }
                    }
                    if (skipFirst) continue;
                    result.add(i++, new GeneratorData(o, adapter));
                }
            }
            skipFirst = false;
        }
        return result;
    }

    public boolean canGenerate(Object object, Object projectType) {
        GeneratorData[] data = this.getGeneratorData(object, projectType, false);
        int i = 0;
        while (i < data.length) {
            if (data[i].adapter.canGenerate(data[i].object, projectType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Diagnostic generate(Object object, Object projectType, Monitor monitor) {
        return this.generate(object, projectType, null, monitor);
    }

    public Diagnostic generate(Object object, Object projectType, String projectTypeName, Monitor monitor) {
        BasicDiagnostic basicDiagnostic;
        try {
            String message = projectTypeName != null ? CodeGenEcorePlugin.INSTANCE.getString("_UI_Generating_message", new Object[]{projectTypeName}) : CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingCode_message");
            BasicDiagnostic result = new BasicDiagnostic("org.eclipse.emf.codegen.ecore", 0, message, null);
            GeneratorData[] data = this.getGeneratorData(object, projectType, true);
            monitor.beginTask("", data.length + 2);
            monitor.subTask(message);
            if (this.initializeNeeded) {
                this.initializeNeeded = false;
                this.initialize();
            }
            int preIndex = 0;
            while (preIndex < data.length && this.canContinue((Diagnostic)result)) {
                result.add(data[preIndex].adapter.preGenerate(data[preIndex].object, projectType));
                ++preIndex;
            }
            monitor.worked(1);
            int i = 0;
            while (i < data.length && this.canContinue((Diagnostic)result)) {
                result.add(data[i].adapter.generate(data[i].object, projectType, CodeGenUtil.createMonitor((Monitor)monitor, (int)1)));
                if (monitor.isCanceled()) {
                    result.add(Diagnostic.CANCEL_INSTANCE);
                }
                ++i;
            }
            i = 0;
            while (i < preIndex) {
                result.add(data[i].adapter.postGenerate(data[i].object, projectType));
                ++i;
            }
            basicDiagnostic = result;
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return basicDiagnostic;
    }

    protected boolean canContinue(Diagnostic diagnostic) {
        return diagnostic.getSeverity() != 8;
    }

    public void dispose() {
        if (this.packageIDToAdapterFactories != null) {
            Iterator i = this.packageIDToAdapterFactories.values().iterator();
            while (i.hasNext()) {
                Iterator j = ((Collection)i.next()).iterator();
                while (j.hasNext()) {
                    ((GeneratorAdapterFactory)j.next()).dispose();
                }
            }
        }
    }

    public static class Options {
        public String redirectionPattern;
        public boolean forceOverwrite;
        public boolean dynamicTemplates;
        public String[] templatePath;
        public String mergerFacadeHelperClass;
        public String mergeRulesURI;
        public boolean codeFormatting;
        public Map codeFormatterOptions;
        public ResourceSet resourceSet;
        public Object[] data;
    }

    private static class GeneratorData {
        public Object object;
        public GeneratorAdapter adapter;

        public GeneratorData(Object object, GeneratorAdapter adapter) {
            this.object = object;
            this.adapter = adapter;
        }
    }
}

