/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.transaction.CDOTimeStampContext;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.AbstractSyncRevisionsRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockObjectsRequest
extends AbstractSyncRevisionsRequest {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LockObjectsRequest.class);
    private CDOView view;
    private RWLockManager.LockType lockType;
    private long timeout;

    public LockObjectsRequest(CDOClientProtocol protocol, CDOView view, Map<CDOID, CDOIDAndVersion> idAndVersions, int referenceChunk, long timeout, RWLockManager.LockType lockType) {
        super(protocol, (short)25, idAndVersions, referenceChunk);
        this.view = view;
        this.timeout = timeout;
        this.lockType = lockType;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        super.requesting(out);
        out.writeInt(this.view.getViewID());
        out.writeCDOLockType(this.lockType);
        out.writeLong(this.timeout);
        if (TRACER.isEnabled()) {
            TRACER.format("Locking of type {0} requested for view {1} with timeout {2}", new Object[]{this.lockType == RWLockManager.LockType.READ ? "read" : "write", this.view.getViewID(), this.timeout});
        }
    }

    @Override
    protected Collection<CDOTimeStampContext> confirming(CDODataInput in) throws IOException {
        Object contexts = super.confirming(in);
        Iterator iterator = contexts.iterator();
        while (iterator.hasNext()) {
            CDOTimeStampContext timestampContext = (CDOTimeStampContext)iterator.next();
            this.getSession().handleUpdateRevision(timestampContext.getTimeStamp(), timestampContext.getDirtyObjects(), timestampContext.getDetachedObjects());
            ((InternalCDOView)this.view).handleInvalidationWithoutNotification(timestampContext.getDirtyObjects(), timestampContext.getDetachedObjects(), new HashSet<InternalCDOObject>(), new HashSet<InternalCDOObject>());
        }
        return contexts;
    }
}

