/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.util.IPackageClosure;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackageClosure
implements IPackageClosure {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MODEL, PackageClosure.class);

    protected PackageClosure() {
    }

    @Override
    public Set<EPackage> calculate(Collection<EPackage> ePackages) {
        if (ePackages.isEmpty()) {
            return EMPTY_CLOSURE;
        }
        HashSet<EPackage> visited = new HashSet<EPackage>();
        for (EPackage ePackage : ePackages) {
            this.doCollectContents(ePackage, visited);
        }
        return visited;
    }

    @Override
    public Set<EPackage> calculate(EPackage ePackage) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Package closure for " + ePackage.getNsURI());
        }
        HashSet<EPackage> visited = new HashSet<EPackage>();
        this.doCollectContents(ePackage, visited);
        return visited;
    }

    private void doCollectContents(EPackage ePackage, Set<EPackage> visited) {
        this.collectContents(ePackage, visited);
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.doCollectContents(subPackage, visited);
        }
    }

    protected abstract void collectContents(EPackage var1, Set<EPackage> var2);
}

