/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;

public class CDOFetchFeatureInfo {
    private long timeBeforeUsed;
    private long latencyTime;
    private boolean active;
    private CDOClass cdoClass;
    private CDOFeature cdoFeature;

    public CDOFetchFeatureInfo(CDOClass cdoClass, CDOFeature cdoFeature) {
        this.cdoClass = cdoClass;
        this.cdoFeature = cdoFeature;
        this.active = false;
        this.latencyTime = -1L;
    }

    public CDOClass getCDOClass() {
        return this.cdoClass;
    }

    public CDOFeature getCDOFeature() {
        return this.cdoFeature;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long getTimeBeforeUsed() {
        return this.timeBeforeUsed;
    }

    public void setTimeBeforeUsed(long timeBeforeUsed) {
        this.timeBeforeUsed = timeBeforeUsed;
    }

    public long getLatencyTime() {
        return this.latencyTime;
    }

    public void setLatencyTime(long latencyTime) {
        this.latencyTime = latencyTime;
    }

    public void updateLatencyTime(long latencyTime) {
        if (this.getLatencyTime() == -1L) {
            this.setLatencyTime(latencyTime);
        } else {
            this.setLatencyTime((latencyTime + this.getLatencyTime()) / 2L);
        }
    }

    public void updateTimeInfo(long elapseTimeBeforeLastRequest) {
        if (this.getTimeBeforeUsed() == 0L) {
            this.setTimeBeforeUsed(elapseTimeBeforeLastRequest);
        } else {
            this.setTimeBeforeUsed((this.getTimeBeforeUsed() + elapseTimeBeforeLastRequest) / 2L);
        }
    }

    public int hashCode() {
        return this.cdoClass.hashCode() ^ this.cdoFeature.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDOFetchFeatureInfo) {
            CDOFetchFeatureInfo featureInfo = (CDOFetchFeatureInfo)obj;
            return featureInfo.cdoClass == this.cdoClass && featureInfo.cdoFeature == this.cdoFeature;
        }
        return false;
    }
}

