/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.analyzer.CDOFetchRule;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.emf.internal.cdo.analyzer.CDOAbstractFeatureRuleAnalyzer;
import org.eclipse.emf.internal.cdo.analyzer.CDOClusterOfFetchRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOFeatureAnalyzerUI
extends CDOAbstractFeatureRuleAnalyzer {
    private static final long ELAPSE_TIME = 400L;
    private Map<CDOClusterOfFetchRule, CDOClusterOfFetchRule> featureRules = new HashMap<CDOClusterOfFetchRule, CDOClusterOfFetchRule>();
    private CDOClusterOfFetchRule currentClusterOfFetchRule;
    private long maxTimeBetweenOperation;

    public CDOFeatureAnalyzerUI() {
        this(400L);
    }

    public CDOFeatureAnalyzerUI(long maxTimeBetweenOperation) {
        this.maxTimeBetweenOperation = maxTimeBetweenOperation;
    }

    @Override
    public CDOID getContext() {
        if (this.lastTraverseFeature.isMany()) {
            return CDOID.NULL;
        }
        return this.lastTraverseCDOObject.cdoID();
    }

    public synchronized CDOClusterOfFetchRule getFeatureRule(CDOClass cdoClass, CDOFeature cdoFeature) {
        CDOClusterOfFetchRule search = new CDOClusterOfFetchRule(cdoClass, cdoFeature);
        CDOClusterOfFetchRule featureRule = this.featureRules.get(search);
        if (featureRule == null) {
            featureRule = search;
            this.featureRules.put(search, featureRule);
        }
        return featureRule;
    }

    @Override
    public List<CDOFetchRule> getFetchRules(Collection<CDOID> ids) {
        CDOClusterOfFetchRule search;
        CDOClusterOfFetchRule fetchOfRule;
        boolean addRootFeature = true;
        this.fetchData();
        if (this.lastTraverseFeature.isMany()) {
            addRootFeature = false;
        }
        if ((fetchOfRule = this.featureRules.get(search = new CDOClusterOfFetchRule(this.lastTraverseCDOObject.cdoClass(), this.lastTraverseFeature))) == null) {
            return null;
        }
        Collection<CDOFetchRule> fetchRules = fetchOfRule.getFeatureInfo().getRules(null, null);
        ArrayList<CDOFetchRule> list = new ArrayList<CDOFetchRule>();
        for (CDOFetchRule fetchRule : fetchRules) {
            if (!addRootFeature && this.lastTraverseCDOObject.cdoClass() == fetchRule.getCDOClass()) continue;
            list.add(fetchRule);
        }
        return list;
    }

    @Override
    protected void doPreTraverseFeature(InternalCDOObject cdoObject, CDOFeature feature, int index) {
        if (!feature.isReference()) {
            return;
        }
        if (this.lastElapseTimeBetweenOperations > this.maxTimeBetweenOperation || this.currentClusterOfFetchRule == null) {
            this.currentClusterOfFetchRule = this.getFeatureRule(cdoObject.cdoClass(), feature);
        }
    }

    @Override
    protected void doPostTraverseFeature(InternalCDOObject cdoObject, CDOFeature feature, int index, Object object) {
        if (this.didFetch()) {
            this.currentClusterOfFetchRule.getFeatureInfo().activate(cdoObject.cdoClass(), feature);
        }
    }
}

