/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.cdo.CDOSessionConfiguration;
import org.eclipse.emf.cdo.util.CDOPackageRegistry;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.util.CDOPackageRegistryImpl;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;

public class CDOSessionConfigurationImpl
implements CDOSessionConfiguration {
    private CDOSessionImpl session;
    private IConnector connector;
    private String repositoryName;
    private boolean legacySupportEnabled;
    private IFailOverStrategy failOverStrategy;
    private CDOPackageRegistryImpl packageRegistry;
    private boolean activateOnOpen = true;

    public IConnector getConnector() {
        return this.connector;
    }

    public void setConnector(IConnector connector) {
        this.checkNotOpen();
        this.connector = connector;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.checkNotOpen();
        this.repositoryName = repositoryName;
    }

    public boolean isLegacySupportEnabled() {
        return this.legacySupportEnabled;
    }

    public void setLegacySupportEnabled(boolean legacySupportEnabled) {
        this.checkNotOpen();
        this.legacySupportEnabled = legacySupportEnabled;
    }

    public IFailOverStrategy getFailOverStrategy() {
        return this.failOverStrategy;
    }

    public void setFailOverStrategy(IFailOverStrategy failOverStrategy) {
        this.checkNotOpen();
        this.failOverStrategy = failOverStrategy;
    }

    public CDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    public void setPackageRegistry(CDOPackageRegistry packageRegistry) {
        this.checkNotOpen();
        this.packageRegistry = (CDOPackageRegistryImpl)packageRegistry;
    }

    public void setSelfPopulatingPackageRegistry() {
        this.setPackageRegistry(CDOUtil.createSelfPopulatingPackageRegistry());
    }

    public void setDemandPopulatingPackageRegistry() {
        this.setPackageRegistry(CDOUtil.createDemandPopulatingPackageRegistry());
    }

    public boolean isActivateOnOpen() {
        return this.activateOnOpen;
    }

    public void setActivateOnOpen(boolean activateOnOpen) {
        this.checkNotOpen();
        this.activateOnOpen = activateOnOpen;
    }

    public CDOSession openSession() {
        if (!this.isSessionOpen()) {
            this.session = new CDOSessionImpl();
            this.session.setConnector(this.connector);
            this.session.setRepositoryName(this.repositoryName);
            this.session.setLegacySupportEnabled(this.legacySupportEnabled);
            this.session.setFailOverStrategy(this.failOverStrategy);
            this.session.setPackageRegistry(this.packageRegistry);
            if (this.activateOnOpen) {
                this.session.activate();
            }
        }
        return this.session;
    }

    public boolean isSessionOpen() {
        if (this.session == null) {
            return false;
        }
        if (this.session.isOpen()) {
            return true;
        }
        this.session = null;
        return false;
    }

    private void checkNotOpen() {
        if (this.isSessionOpen()) {
            throw new IllegalStateException("Session is already open");
        }
    }
}

