/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.cdo.internal.ui.SharedIcons;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterPackagesAction;
import org.eclipse.emf.cdo.util.CDOPackageType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterSinglePackageAction
extends RegisterPackagesAction {
    private String packageURI;
    private EPackage.Registry registry = EPackage.Registry.INSTANCE;

    public RegisterSinglePackageAction(IWorkbenchPage page, CDOSession session, String packageURI, CDOPackageType packageType) {
        super(page, packageURI, "Register the package " + packageURI, RegisterSinglePackageAction.getDescriptor(packageType), session);
        this.packageURI = packageURI;
    }

    @Override
    protected List<EPackage> getEPackages(IWorkbenchPage page, CDOSession session) {
        EPackage ePackage = this.registry.getEPackage(this.packageURI);
        if (ePackage != null) {
            return Collections.singletonList(ePackage);
        }
        return Collections.emptyList();
    }

    private static ImageDescriptor getDescriptor(CDOPackageType packageType) {
        switch (packageType) {
            case CONVERTED: {
                return SharedIcons.getDescriptor("obj16/EPackageConverted");
            }
            case LEGACY: {
                return SharedIcons.getDescriptor("obj16/EPackageLegacy");
            }
            case NATIVE: {
                return SharedIcons.getDescriptor("obj16/EPackageNative");
            }
        }
        return null;
    }
}

