/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.emf.cdo.common.CDOQueryInfo;
import org.eclipse.emf.cdo.internal.server.QueryResult;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.View;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryManager
extends Lifecycle {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, QueryManager.class);
    private IRepository repository;
    private Map<Integer, QueryContext> queryContexts = new ConcurrentHashMap<Integer, QueryContext>();
    private ExecutorService executors;
    private boolean shutdownExecutorService = false;
    private int nextQuery;

    public IRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IRepository repository) {
        this.repository = repository;
    }

    public synchronized ExecutorService getExecutors() {
        if (this.executors == null) {
            this.shutdownExecutorService = true;
            this.executors = Executors.newFixedThreadPool(10);
        }
        return this.executors;
    }

    public synchronized void setExecutors(ExecutorService executors) {
        if (this.shutdownExecutorService) {
            this.executors.shutdown();
            this.shutdownExecutorService = false;
        }
        this.executors = executors;
    }

    public QueryResult execute(IView view, CDOQueryInfo queryInfo) {
        QueryResult queryResult = new QueryResult(view, queryInfo, this.nextQuery());
        QueryContext queryContext = new QueryContext(queryResult);
        this.execute(queryContext);
        return queryResult;
    }

    public boolean isRunning(int queryID) {
        QueryContext queryContext = this.queryContexts.get(queryID);
        return queryContext != null;
    }

    public void cancel(int queryID) {
        QueryContext queryContext = this.queryContexts.get(queryID);
        if (queryContext == null || queryContext.getFuture().isDone()) {
            throw new RuntimeException("Query " + queryID + " is not running anymore");
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Cancelling query for context: " + queryContext);
        }
        queryContext.cancel();
    }

    public synchronized void register(QueryContext queryContext) {
        this.queryContexts.put(queryContext.getQueryResult().getQueryID(), queryContext);
        queryContext.addListener();
    }

    public synchronized void unregister(QueryContext queryContext) {
        if (this.queryContexts.remove(queryContext.getQueryResult().getQueryID()) != null) {
            queryContext.removeListener();
        }
    }

    public synchronized int nextQuery() {
        return this.nextQuery++;
    }

    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        this.setExecutors(null);
    }

    private Future<?> execute(QueryContext queryContext) {
        Future<?> future = this.getExecutors().submit(queryContext);
        queryContext.setFuture(future);
        this.register(queryContext);
        return future;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryContext
    implements IQueryContext,
    Runnable {
        private long timeStamp;
        private QueryResult queryResult;
        private boolean started;
        private boolean cancelled;
        private int resultCount;
        private Future<?> future;
        private IListener sessionListener = new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof SingleDeltaContainerEvent) {
                    IView view = QueryContext.this.getQueryResult().getView();
                    SingleDeltaContainerEvent deltaEvent = (SingleDeltaContainerEvent)event;
                    if (deltaEvent.getDeltaKind() == IContainerDelta.Kind.REMOVED && deltaEvent.getDeltaElement() == view) {
                        QueryContext.this.cancel();
                    }
                }
            }
        };

        public QueryContext(QueryResult queryResult) {
            this.queryResult = queryResult;
            View view = (View)this.getView();
            this.timeStamp = view.getTimeStamp();
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        @Override
        public IView getView() {
            return this.queryResult.getView();
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        public Future<?> getFuture() {
            return this.future;
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }

        public void cancel() {
            this.cancelled = true;
            if (this.future != null) {
                this.future.cancel(true);
            }
            if (!this.started) {
                QueryManager.this.unregister(this);
            }
        }

        @Override
        public boolean addResult(Object object) {
            if (this.resultCount == 0) {
                throw new IllegalStateException("Maximum number of results exceeded");
            }
            this.queryResult.getQueue().add(object);
            return !this.cancelled && --this.resultCount > 0;
        }

        @Override
        public void run() {
            Session session = (Session)this.queryResult.getView().getSession();
            StoreThreadLocal.setSession(session);
            try {
                try {
                    this.started = true;
                    CDOQueryInfo info = this.queryResult.getQueryInfo();
                    this.resultCount = info.getMaxResults() < 0 ? Integer.MAX_VALUE : info.getMaxResults();
                    IQueryHandler handler = QueryManager.this.repository.getQueryHandler(info);
                    handler.executeQuery(info, this);
                }
                catch (Throwable exception) {
                    this.queryResult.getQueue().setException(exception);
                    this.queryResult.getQueue().close();
                    QueryManager.this.unregister(this);
                    StoreThreadLocal.release();
                }
            }
            finally {
                this.queryResult.getQueue().close();
                QueryManager.this.unregister(this);
                StoreThreadLocal.release();
            }
        }

        public void addListener() {
            IView view = this.getQueryResult().getView();
            view.getSession().addListener(this.sessionListener);
        }

        public void removeListener() {
            IView view = this.getQueryResult().getView();
            view.getSession().removeListener(this.sessionListener);
        }
    }
}

