/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.View;
import org.eclipse.emf.cdo.server.IAudit;
import org.eclipse.emf.cdo.server.IRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Audit
extends View
implements IAudit {
    private long timeStamp;

    public Audit(Session session, int viewID, long timeStamp) {
        super(session, viewID);
        IRepository repository = this.getSession().getSessionManager().getRepository();
        this.setTimeStamp(repository, timeStamp);
    }

    @Override
    public CDOCommonView.Type getViewType() {
        return CDOCommonView.Type.AUDIT;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public List<CDORevision> setTimeStamp(long timeStamp, List<CDOID> invalidObjects) {
        this.checkOpen();
        IRepository repository = this.getSession().getSessionManager().getRepository();
        this.setTimeStamp(repository, timeStamp);
        return repository.getRevisionManager().getRevisionsByTime(invalidObjects, 0, timeStamp, false);
    }

    @Override
    public String toString() {
        return MessageFormat.format("Audit[{0}, {1,date} {1,time}]", this.getViewID(), this.timeStamp);
    }

    private void setTimeStamp(IRepository repository, long timeStamp) {
        repository.validateTimeStamp(timeStamp);
        this.timeStamp = timeStamp;
    }

    private void checkOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("View closed");
        }
    }
}

