/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.common.CDOProtocolView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.model.core.CDOCorePackage;
import org.eclipse.emf.cdo.common.model.resource.CDOResourcePackage;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.server.PackageManager;
import org.eclipse.emf.cdo.internal.server.RevisionManager;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.View;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IPackageManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRevisionManager;
import org.eclipse.emf.cdo.server.IStoreWriter;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.StoreUtil;
import org.eclipse.emf.cdo.spi.common.InternalCDOPackage;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.InternalCDORevisionDelta;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction
extends View
implements ITransaction,
IStoreWriter.CommitContext {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSACTION, Transaction.class);
    private IRepository repository;
    private IPackageManager repositoryPackageManager;
    private TransactionPackageManager packageManager;
    private IStoreWriter storeWriter;
    private long timeStamp;
    private CDOPackage[] newPackages;
    private CDORevision[] newObjects;
    private CDORevision[] dirtyObjects;
    private CDORevisionDelta[] dirtyObjectDeltas;
    private List<CDOIDMetaRange> metaIDRanges = new ArrayList<CDOIDMetaRange>();
    private ConcurrentMap<CDOIDTemp, CDOID> idMappings = new ConcurrentHashMap<CDOIDTemp, CDOID>();
    private String rollbackMessage;

    public Transaction(Session session, int viewID) {
        super(session, viewID, CDOProtocolView.Type.TRANSACTION);
        this.repository = session.getSessionManager().getRepository();
        this.repositoryPackageManager = this.repository.getPackageManager();
        this.packageManager = new TransactionPackageManager();
    }

    @Override
    public int getTransactionID() {
        return this.getViewID();
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public TransactionPackageManager getPackageManager() {
        return this.packageManager;
    }

    @Override
    public CDOPackage[] getNewPackages() {
        return this.newPackages;
    }

    @Override
    public CDORevision[] getNewObjects() {
        return this.newObjects;
    }

    @Override
    public CDORevision[] getDirtyObjects() {
        return this.dirtyObjects;
    }

    @Override
    public CDORevisionDelta[] getDirtyObjectDeltas() {
        return this.dirtyObjectDeltas;
    }

    public List<CDOIDMetaRange> getMetaIDRanges() {
        return Collections.unmodifiableList(this.metaIDRanges);
    }

    @Override
    public Map<CDOIDTemp, CDOID> getIDMappings() {
        return Collections.unmodifiableMap(this.idMappings);
    }

    @Override
    public void addIDMapping(CDOIDTemp oldID, CDOID newID) {
        if (newID == null || newID.isNull() || newID.isTemporary()) {
            throw new IllegalStateException("newID=" + newID);
        }
        CDOID previousMapping = this.idMappings.putIfAbsent(oldID, newID);
        if (previousMapping != null) {
            throw new IllegalStateException("previousMapping != null");
        }
    }

    @Override
    public void applyIDMappings() {
        this.applyIDMappings(this.newObjects);
        this.applyIDMappings(this.dirtyObjects);
        CDORevisionDelta[] cDORevisionDeltaArray = this.dirtyObjectDeltas;
        int n = this.dirtyObjectDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            CDORevisionDelta dirtyObjectDelta = cDORevisionDeltaArray[n2];
            ((InternalCDORevisionDelta)dirtyObjectDelta).adjustReferences(this.idMappings);
            ++n2;
        }
    }

    public String getRollbackMessage() {
        return this.rollbackMessage;
    }

    public void preCommit() {
        this.storeWriter = this.repository.getStore().getWriter(this);
        StoreUtil.setReader(this.storeWriter);
    }

    public void commit(CDOPackage[] newPackages, CDORevision[] newObjects, CDORevisionDelta[] dirtyObjectDeltas) {
        this.timeStamp = this.createTimeStamp();
        this.newPackages = newPackages;
        this.newObjects = newObjects;
        this.dirtyObjectDeltas = dirtyObjectDeltas;
        this.dirtyObjects = new CDORevision[dirtyObjectDeltas.length];
        try {
            this.adjustMetaRanges();
            this.adjustTimeStamps();
            this.computeDirtyObjects(!this.repository.isSupportingRevisionDeltas());
            this.storeWriter.commit(this);
            this.updateInfraStructure();
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            this.rollbackMessage = ex.getMessage();
            this.rollback();
        }
    }

    protected long createTimeStamp() {
        return System.currentTimeMillis();
    }

    public void postCommit(boolean success) {
        try {
            int modifications = this.dirtyObjectDeltas.length;
            if (success && modifications > 0) {
                ArrayList<CDOIDAndVersion> dirtyIDs = new ArrayList<CDOIDAndVersion>(modifications);
                int i = 0;
                while (i < modifications) {
                    CDORevisionDelta delta = this.dirtyObjectDeltas[i];
                    CDOIDAndVersion dirtyID = CDOIDUtil.createIDAndVersion((CDOID)delta.getID(), (int)delta.getOriginVersion());
                    dirtyIDs.add(dirtyID);
                    ++i;
                }
                SessionManager sessionManager = (SessionManager)this.repository.getSessionManager();
                sessionManager.notifyInvalidation(this.timeStamp, dirtyIDs, this.getSession());
            }
        }
        finally {
            if (this.storeWriter != null) {
                StoreUtil.setReader(null);
                this.storeWriter.release();
                this.storeWriter = null;
            }
            this.timeStamp = 0L;
            this.packageManager.clear();
            this.metaIDRanges.clear();
            this.idMappings.clear();
            this.rollbackMessage = null;
            this.newPackages = null;
            this.newObjects = null;
            this.dirtyObjectDeltas = null;
            this.dirtyObjects = null;
        }
    }

    private void adjustTimeStamps() {
        CDORevision[] cDORevisionArray = this.newObjects;
        int n = this.newObjects.length;
        int n2 = 0;
        while (n2 < n) {
            CDORevision newObject = cDORevisionArray[n2];
            InternalCDORevision revision = (InternalCDORevision)newObject;
            revision.setCreated(this.timeStamp);
            ++n2;
        }
    }

    private void adjustMetaRanges() {
        CDOPackage[] cDOPackageArray = this.newPackages;
        int n = this.newPackages.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackage newPackage = cDOPackageArray[n2];
            if (newPackage.getParentURI() == null) {
                this.adjustMetaRange(newPackage);
            }
            ++n2;
        }
    }

    private void adjustMetaRange(CDOPackage newPackage) {
        CDOIDMetaRange oldRange = newPackage.getMetaIDRange();
        if (!oldRange.isTemporary()) {
            throw new IllegalStateException("!oldRange.isTemporary()");
        }
        CDOIDMetaRange newRange = this.repository.getMetaIDRange(oldRange.size());
        ((InternalCDOPackage)newPackage).setMetaIDRange(newRange);
        int l = 0;
        while (l < oldRange.size()) {
            CDOIDTemp oldID = (CDOIDTemp)oldRange.get(l);
            CDOID newID = newRange.get(l);
            if (TRACER.isEnabled()) {
                TRACER.format("Mapping meta ID: {0} --> {1}", new Object[]{oldID, newID});
            }
            this.idMappings.put(oldID, newID);
            ++l;
        }
        this.metaIDRanges.add(newRange);
    }

    private void computeDirtyObjects(boolean failOnNull) {
        int i = 0;
        while (i < this.dirtyObjectDeltas.length) {
            this.dirtyObjects[i] = this.computeDirtyObject(this.dirtyObjectDeltas[i], failOnNull);
            if (this.dirtyObjects[i] == null && failOnNull) {
                throw new IllegalStateException("Can not retrieve origin revision for " + this.dirtyObjectDeltas[i]);
            }
            ++i;
        }
    }

    private CDORevision computeDirtyObject(CDORevisionDelta dirtyObjectDelta, boolean loadOnDemand) {
        CDOID id = dirtyObjectDelta.getID();
        int version = dirtyObjectDelta.getOriginVersion();
        IRevisionManager revisionResolver = this.repository.getRevisionManager();
        CDORevision originObject = revisionResolver.getRevisionByVersion(id, -1, version, loadOnDemand);
        if (originObject != null) {
            InternalCDORevision dirtyObject = (InternalCDORevision)CDORevisionUtil.copy((CDORevision)originObject);
            dirtyObjectDelta.apply((CDORevision)dirtyObject);
            dirtyObject.setCreated(this.timeStamp);
            return dirtyObject;
        }
        return null;
    }

    private void applyIDMappings(CDORevision[] revisions) {
        CDORevision[] cDORevisionArray = revisions;
        int n = revisions.length;
        int n2 = 0;
        while (n2 < n) {
            CDORevision revision = cDORevisionArray[n2];
            if (revision != null) {
                InternalCDORevision internal = (InternalCDORevision)revision;
                CDOID newID = (CDOID)this.idMappings.get(internal.getID());
                if (newID != null) {
                    internal.setID(newID);
                }
                internal.adjustReferences(this.idMappings);
            }
            ++n2;
        }
    }

    private void rollback() {
        if (this.storeWriter != null) {
            try {
                this.storeWriter.rollback(this);
            }
            catch (RuntimeException ex) {
                OM.LOG.warn("Problem while rolling back  the transaction", (Throwable)ex);
            }
        }
    }

    private void updateInfraStructure() {
        try {
            this.addNewPackages();
            this.addRevisions(this.newObjects);
            this.addRevisions(this.dirtyObjects);
        }
        catch (RuntimeException runtimeException) {
            OM.LOG.error("FATAL: Memory infrastructure corrupted after successful commit operation of the store");
        }
    }

    private void addNewPackages() {
        PackageManager packageManager = (PackageManager)this.repository.getPackageManager();
        int i = 0;
        while (i < this.newPackages.length) {
            CDOPackage cdoPackage = this.newPackages[i];
            packageManager.addPackage(cdoPackage);
            ++i;
        }
    }

    private void addRevisions(CDORevision[] revisions) {
        RevisionManager revisionManager = (RevisionManager)this.repository.getRevisionManager();
        CDORevision[] cDORevisionArray = revisions;
        int n = revisions.length;
        int n2 = 0;
        while (n2 < n) {
            CDORevision revision = cDORevisionArray[n2];
            if (revision != null) {
                revisionManager.addRevision((InternalCDORevision)revision);
            }
            ++n2;
        }
    }

    public final class TransactionPackageManager
    implements CDOPackageManager {
        private List<CDOPackage> newPackages = new ArrayList<CDOPackage>();

        public void addPackage(CDOPackage cdoPackage) {
            this.newPackages.add(cdoPackage);
        }

        public void clear() {
            this.newPackages.clear();
        }

        public CDOIDObjectFactory getCDOIDObjectFactory() {
            return Transaction.this.repositoryPackageManager.getCDOIDObjectFactory();
        }

        public CDOPackage lookupPackage(String uri) {
            for (CDOPackage cdoPackage : this.newPackages) {
                if (!ObjectUtil.equals((Object)cdoPackage.getPackageURI(), (Object)uri)) continue;
                return cdoPackage;
            }
            return Transaction.this.repositoryPackageManager.lookupPackage(uri);
        }

        public CDOCorePackage getCDOCorePackage() {
            return Transaction.this.repositoryPackageManager.getCDOCorePackage();
        }

        public CDOResourcePackage getCDOResourcePackage() {
            return Transaction.this.repositoryPackageManager.getCDOResourcePackage();
        }

        public int getPackageCount() {
            throw new UnsupportedOperationException();
        }

        public CDOPackage[] getPackages() {
            throw new UnsupportedOperationException();
        }

        public CDOPackage[] getElements() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public void addListener(IListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removeListener(IListener listener) {
            throw new UnsupportedOperationException();
        }
    }
}

