/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.SessionCreationException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager
extends Container<ISession>
implements ISessionManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, SessionManager.class);
    private Repository repository;
    private Map<Integer, Session> sessions = new HashMap<Integer, Session>();
    private int lastSessionID;

    public SessionManager(Repository repository) {
        this.repository = repository;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions() {
        Map<Integer, Session> map = this.sessions;
        synchronized (map) {
            return this.sessions.values().toArray(new Session[this.sessions.size()]);
        }
    }

    public ISession[] getElements() {
        return this.getSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<Integer, Session> map = this.sessions;
        synchronized (map) {
            return this.sessions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session openSession(CDOServerProtocol protocol, boolean legacySupportEnabled) throws SessionCreationException {
        int id = ++this.lastSessionID;
        if (TRACER.isEnabled()) {
            TRACER.trace("Opening session " + id);
        }
        Session session = new Session(this, protocol, id, legacySupportEnabled);
        Map<Integer, Session> map = this.sessions;
        synchronized (map) {
            this.sessions.put(id, session);
        }
        this.fireElementAddedEvent(session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(Session session) {
        int sessionID = session.getSessionID();
        ISession removeSession = null;
        Map<Integer, Session> map = this.sessions;
        synchronized (map) {
            removeSession = this.sessions.remove(sessionID);
        }
        if (removeSession != null) {
            this.fireElementRemovedEvent(session);
        }
    }

    public void notifyInvalidation(long timeStamp, List<CDOIDAndVersion> dirtyIDs, Session excludedSession) {
        Session[] sessionArray = this.getSessions();
        int n = sessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Session session = sessionArray[n2];
            if (session != excludedSession) {
                session.notifyInvalidation(timeStamp, dirtyIDs);
            }
            ++n2;
        }
    }
}

