/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.HorizontalMappingStrategy;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;

public final class CDODBUtil {
    public static final String EXT_POINT = "mappingStrategies";

    private CDODBUtil() {
    }

    public static IDBStore createStore(IMappingStrategy mappingStrategy, IDBAdapter dbAdapter, IDBConnectionProvider dbConnectionProvider) {
        DBStore store = new DBStore();
        store.setMappingStrategy(mappingStrategy);
        store.setDbAdapter(dbAdapter);
        store.setDbConnectionProvider(dbConnectionProvider);
        return store;
    }

    public static IMappingStrategy createHorizontalMappingStrategy() {
        return new HorizontalMappingStrategy();
    }

    public static IMappingStrategy createMappingStrategy(String type) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server.db", EXT_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String typeAttr;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("mappingStrategy".equals(element.getName()) && ObjectUtil.equals((Object)(typeAttr = element.getAttribute("type")), (Object)type)) {
                try {
                    return (IMappingStrategy)element.createExecutableExtension("class");
                }
                catch (CoreException ex) {
                    throw WrappedException.wrap((Exception)((Object)ex));
                }
            }
            ++n2;
        }
        return null;
    }
}

