/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.migrator.actions;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.migrator.CDOMigrator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class MigrateAction
implements IObjectActionDelegate {
    private IAction action;
    private ISelection selection;

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.action = action;
    }

    public void run(IAction action) {
        new Job("Migrating EMF model"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IFile file = MigrateAction.this.getFile();
                    if (file == null) {
                        MigrateAction.this.showMessage("The selected element is not a *.genmodel file.", true);
                    } else {
                        GenModel genModel = MigrateAction.this.getGenModel(file);
                        if (genModel == null) {
                            MigrateAction.this.showMessage("The selected file does not contain a generator model.", true);
                        } else {
                            String msg = CDOMigrator.adjustGenModel(genModel, file.getProject());
                            if (msg == null) {
                                MigrateAction.this.showMessage("The selected generator model was already migrated.", false);
                            } else {
                                genModel.eResource().save(null);
                                MigrateAction.this.showMessage("The selected generator model has been migrated:\n\n" + msg, false);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    return new Status(4, "org.eclipse.emf.cdo.migrator", "Problem while migrating EMF model", (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected IFile getFile() {
        IFile file;
        Object element;
        if (this.selection instanceof IStructuredSelection && (element = ((IStructuredSelection)this.selection).getFirstElement()) instanceof IFile && "genmodel".equals((file = (IFile)element).getFileExtension())) {
            return file;
        }
        return null;
    }

    protected GenModel getGenModel(IFile file) {
        EObject object;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map map = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        map.put("*", new XMIResourceFactoryImpl());
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        Resource resource = resourceSet.getResource(uri, true);
        EList contents = resource.getContents();
        if (!contents.isEmpty() && (object = (EObject)contents.get(0)) instanceof GenModel) {
            return (GenModel)object;
        }
        return null;
    }

    protected void showMessage(final String msg, final boolean error) {
        try {
            final Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    try {
                        Shell shell = new Shell(display);
                        if (error) {
                            MessageDialog.openError((Shell)shell, (String)"CDO Migrator", (String)msg);
                        } else {
                            MessageDialog.openInformation((Shell)shell, (String)"CDO Migrator", (String)msg);
                        }
                    }
                    catch (RuntimeException runtimeException) {}
                }
            });
        }
        catch (RuntimeException runtimeException) {}
    }
}

