/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class EditingDomainTest
extends AbstractTest {
    public EditingDomainTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(EditingDomainTest.class, "Editing Domain Life-Cycle Tests");
    }

    public void test_factoryUnmapResourceSet_161168() {
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        ResourceSet rset = domain.getResourceSet();
        EditingDomainTest.assertSame((Object)domain, (Object)TransactionUtil.getEditingDomain((ResourceSet)rset));
        domain.dispose();
        domain = null;
        EditingDomainTest.assertNull((Object)TransactionUtil.getEditingDomain((ResourceSet)rset));
    }

    public void ignore_test_readOnlyResourceMap_workspace_bug156428() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        final IProject proj = ws.getRoot().getProject("read_only_test");
        this.addTearDownAction(new Runnable(){

            @Override
            public void run() {
                EditingDomainTest.this.delete(proj);
            }
        });
        try {
            proj.create(null);
            proj.open(null);
        }
        catch (Exception e) {
            EditingDomainTest.fail((String)("Failed to create project: " + e.getLocalizedMessage()));
        }
        IFile file = proj.getFile("testResource.xmi");
        Resource res = this.domain.getResourceSet().createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
        EditingDomainTest.assertFalse((boolean)this.domain.isReadOnly(res));
        this.domain.getResourceSet().getResources().remove((Object)res);
        try {
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
        }
        catch (Exception e) {
            EditingDomainTest.fail((String)("Failed to create file: " + e.getLocalizedMessage()));
        }
        res = this.domain.getResourceSet().createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
        EditingDomainTest.assertFalse((boolean)this.domain.isReadOnly(res));
        this.domain.getResourceSet().getResources().remove((Object)res);
        ResourceAttributes attribs = new ResourceAttributes();
        attribs.setReadOnly(true);
        try {
            file.setResourceAttributes(attribs);
        }
        catch (Exception e) {
            EditingDomainTest.fail((String)("Failed to set file read-only: " + e.getLocalizedMessage()));
        }
        res = this.domain.getResourceSet().createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
        EditingDomainTest.assertTrue((boolean)this.domain.isReadOnly(res));
    }

    public void test_readOnlyResourceMap_filesystem_bug156428() {
        File file;
        try {
            file = File.createTempFile("testReadOnly", ".xmi");
        }
        catch (Exception e) {
            EditingDomainTest.fail((String)("Failed to create temporary file: " + e.getLocalizedMessage()));
            throw new AssertionFailedError();
        }
        this.addTearDownAction(new Runnable(){

            @Override
            public void run() {
                EditingDomainTest.this.delete(file);
            }
        });
        Resource res = this.domain.getResourceSet().createResource(URI.createFileURI((String)(file.getAbsolutePath() + "2")));
        EditingDomainTest.assertFalse((boolean)this.domain.isReadOnly(res));
        this.domain.getResourceSet().getResources().remove((Object)res);
        res = this.domain.getResourceSet().createResource(URI.createFileURI((String)file.getAbsolutePath()));
        EditingDomainTest.assertFalse((boolean)this.domain.isReadOnly(res));
        this.domain.getResourceSet().getResources().remove((Object)res);
        file.setReadOnly();
        res = this.domain.getResourceSet().createResource(URI.createFileURI((String)file.getAbsolutePath()));
        EditingDomainTest.assertTrue((boolean)this.domain.isReadOnly(res));
    }
}

