/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.emf.workspace.EMFOperationCommand;
import org.eclipse.emf.workspace.tests.AbstractTest;
import org.eclipse.emf.workspace.tests.fixtures.ContextAdder;
import org.eclipse.emf.workspace.tests.fixtures.ExternalDataOperation;
import org.eclipse.emf.workspace.tests.fixtures.TestOperation;
import org.eclipse.emf.workspace.tests.fixtures.TestUndoContext;

public class EMFOperationCommandTest
extends AbstractTest {
    public EMFOperationCommandTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(EMFOperationCommandTest.class, "EMF Operation Command Tests");
    }

    public void test_execute_undo_redo() {
        this.startReading();
        Book book = (Book)this.find("root/Root Book");
        EMFOperationCommandTest.assertNotNull((Object)book);
        String oldTitle = book.getTitle();
        String[] externalData = new String[]{"external"};
        String oldExternalData = externalData[0];
        String newExternalData = "newValue";
        String newTitle = "New Title";
        this.commit();
        TestUndoContext ctx = new TestUndoContext();
        SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)"New Title");
        ExternalDataOperation oper = new ExternalDataOperation(externalData, "newValue");
        cmd = cmd.chain((Command)new EMFOperationCommand(this.domain, (IUndoableOperation)oper));
        try {
            this.history.addOperationHistoryListener((IOperationHistoryListener)new ContextAdder(ctx));
            this.getCommandStack().execute((Command)cmd, null);
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.startReading();
        EMFOperationCommandTest.assertSame((Object)"New Title", (Object)book.getTitle());
        EMFOperationCommandTest.assertEquals((String)"newValue", (String)externalData[0]);
        this.commit();
        try {
            EMFOperationCommandTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFOperationCommandTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        EMFOperationCommandTest.assertEquals((String)oldExternalData, (String)externalData[0]);
        this.commit();
        try {
            EMFOperationCommandTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFOperationCommandTest.assertSame((Object)"New Title", (Object)book.getTitle());
        EMFOperationCommandTest.assertEquals((String)"newValue", (String)externalData[0]);
        this.commit();
    }

    public void test_execute_undo_redo_trigger() {
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        EMFOperationCommandTest.assertNotNull((Object)book);
        String oldTitle = book.getTitle();
        final String[] externalData = new String[]{"external"};
        String oldExternalData = externalData[0];
        String newExternalData = "newValue";
        String newTitle = "New Title";
        this.commit();
        TestUndoContext ctx = new TestUndoContext();
        SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)"New Title");
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                EMFOperationCommand result = null;
                if (notification.getNotifier() == book && "New Title".equals(notification.getNewValue())) {
                    EMFOperationCommandTest.trace("Adding external data trigger command");
                    ExternalDataOperation oper = new ExternalDataOperation(externalData, "newValue");
                    result = new EMFOperationCommand(domain, (IUndoableOperation)oper);
                }
                return result;
            }
        });
        try {
            this.history.addOperationHistoryListener((IOperationHistoryListener)new ContextAdder(ctx));
            this.getCommandStack().execute((Command)cmd, null);
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.startReading();
        EMFOperationCommandTest.assertSame((Object)"New Title", (Object)book.getTitle());
        EMFOperationCommandTest.assertEquals((String)"newValue", (String)externalData[0]);
        this.commit();
        try {
            EMFOperationCommandTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFOperationCommandTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        EMFOperationCommandTest.assertEquals((String)oldExternalData, (String)externalData[0]);
        this.commit();
        try {
            EMFOperationCommandTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFOperationCommandTest.assertSame((Object)"New Title", (Object)book.getTitle());
        EMFOperationCommandTest.assertEquals((String)"newValue", (String)externalData[0]);
        this.commit();
    }

    public void test_rollback_trigger() {
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        EMFOperationCommandTest.assertNotNull((Object)book);
        String oldTitle = book.getTitle();
        final String[] externalData = new String[]{"external"};
        String oldExternalData = externalData[0];
        String newExternalData = "newValue";
        this.commit();
        TestUndoContext ctx = new TestUndoContext();
        SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), null);
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                EMFOperationCommand result = null;
                if (notification.getNotifier() == book && notification.getNewValue() == null) {
                    EMFOperationCommandTest.trace("Adding external data trigger command");
                    ExternalDataOperation oper = new ExternalDataOperation(externalData, "newValue");
                    result = new EMFOperationCommand(domain, (IUndoableOperation)oper);
                }
                return result;
            }
        });
        try {
            this.history.addOperationHistoryListener((IOperationHistoryListener)new ContextAdder(ctx));
            this.getCommandStack().execute((Command)cmd, null);
            EMFOperationCommandTest.fail((String)"Should have thrown RollbackException");
        }
        catch (RollbackException e) {
            EMFOperationCommandTest.trace("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.startReading();
        EMFOperationCommandTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        EMFOperationCommandTest.assertEquals((String)oldExternalData, (String)externalData[0]);
        this.commit();
    }

    public void test_execute_undo_redo_trigger_recordingCommand() {
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        EMFOperationCommandTest.assertNotNull((Object)book);
        String oldTitle = book.getTitle();
        final String[] externalData = new String[]{"external"};
        String oldExternalData = externalData[0];
        String newExternalData = "newValue";
        String newTitle = "New Title";
        this.commit();
        TestUndoContext ctx = new TestUndoContext();
        RecordingCommand cmd = new RecordingCommand(this.domain, "Testing"){

            protected void doExecute() {
                book.setTitle("New Title");
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                EMFOperationCommand result = null;
                if (notification.getNotifier() == book && "New Title".equals(notification.getNewValue())) {
                    EMFOperationCommandTest.trace("Adding external data trigger command");
                    ExternalDataOperation oper = new ExternalDataOperation(externalData, "newValue");
                    result = new EMFOperationCommand(domain, (IUndoableOperation)oper);
                }
                return result;
            }
        });
        try {
            this.history.addOperationHistoryListener((IOperationHistoryListener)new ContextAdder(ctx));
            this.getCommandStack().execute((Command)cmd, null);
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.startReading();
        EMFOperationCommandTest.assertSame((Object)"New Title", (Object)book.getTitle());
        EMFOperationCommandTest.assertEquals((String)"newValue", (String)externalData[0]);
        this.commit();
        try {
            EMFOperationCommandTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFOperationCommandTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        EMFOperationCommandTest.assertEquals((String)oldExternalData, (String)externalData[0]);
        this.commit();
        try {
            EMFOperationCommandTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFOperationCommandTest.assertSame((Object)"New Title", (Object)book.getTitle());
        EMFOperationCommandTest.assertEquals((String)"newValue", (String)externalData[0]);
        this.commit();
    }

    public void test_nonredoableOperation_138287() {
        TestOperation operation = new TestOperation(this.domain){

            protected void doExecute() {
            }

            public boolean canRedo() {
                return false;
            }
        };
        this.getCommandStack().execute((Command)new EMFOperationCommand(this.domain, (IUndoableOperation)operation));
        EMFOperationCommandTest.assertTrue((boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        EMFOperationCommandTest.assertFalse((boolean)this.getCommandStack().canRedo());
    }

    public void test_multipleDisposableOperation_209491() {
        NullPointerException exception;
        TestOperation operation = new TestOperation(this.domain){

            protected void doExecute() {
            }

            public boolean canRedo() {
                return false;
            }
        };
        EMFOperationCommand operationCommand = new EMFOperationCommand(this.domain, (IUndoableOperation)operation);
        this.getCommandStack().execute((Command)operationCommand);
        operationCommand.dispose();
        try {
            operationCommand.canExecute();
            exception = null;
        }
        catch (NullPointerException nullPointerException) {
            exception = nullPointerException;
        }
        EMFOperationCommandTest.assertNotNull((Object)exception);
        try {
            operationCommand.dispose();
            exception = null;
        }
        catch (NullPointerException nullPointerException) {
            exception = nullPointerException;
        }
        EMFOperationCommandTest.assertNull((Object)exception);
    }

    public void test_operationTriggerFails_234868() {
        final TestOperation trigger = new TestOperation(this.domain){

            protected void doExecute() throws ExecutionException {
                throw new ExecutionException("I should fail");
            }
        };
        TriggerListener listener = new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new EMFOperationCommand(domain, (IUndoableOperation)trigger);
            }
        };
        try {
            try {
                this.domain.addResourceSetListener((ResourceSetListener)listener);
                this.startWriting();
                Book book = (Book)this.find("root/Root Book");
                book.setCopies(book.getCopies() + 30);
                this.commitWithRollback();
                EMFOperationCommandTest.fail((String)"Should have rolled back.");
            }
            catch (RollbackException rbe) {
                System.out.println("Got expected exception: " + rbe.getLocalizedMessage());
                this.domain.removeResourceSetListener((ResourceSetListener)listener);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)listener);
        }
    }

    public void test_operationTriggerErrorStatus_234868() {
        final TestOperation trigger = new TestOperation(this.domain){

            protected void doExecute() {
                this.setStatus((IStatus)new Status(4, "org.eclipse.emf.workspace.tests", "I should fail"));
            }
        };
        TriggerListener listener = new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new EMFOperationCommand(domain, (IUndoableOperation)trigger);
            }
        };
        try {
            try {
                this.domain.addResourceSetListener((ResourceSetListener)listener);
                this.startWriting();
                Book book = (Book)this.find("root/Root Book");
                book.setCopies(book.getCopies() + 30);
                this.commitWithRollback();
                EMFOperationCommandTest.fail((String)"Should have rolled back.");
            }
            catch (RollbackException rbe) {
                System.out.println("Got expected exception: " + rbe.getLocalizedMessage());
                this.domain.removeResourceSetListener((ResourceSetListener)listener);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)listener);
        }
    }

    public void test_operationTriggerErrorStatus_nonEMF_234868() {
        AbstractOperation trigger = new AbstractOperation("Non-EMF Changes"){

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return new Status(4, "org.eclipse.emf.workspace.tests", "I should fail");
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }
        };
        TriggerListener listener = new TriggerListener((IUndoableOperation)trigger){
            private final /* synthetic */ IUndoableOperation val$trigger;
            {
                this.val$trigger = iUndoableOperation;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new EMFOperationCommand(domain, this.val$trigger);
            }
        };
        try {
            try {
                this.domain.addResourceSetListener((ResourceSetListener)listener);
                this.startWriting();
                Book book = (Book)this.find("root/Root Book");
                book.setCopies(book.getCopies() + 30);
                this.commitWithRollback();
                EMFOperationCommandTest.fail((String)"Should have rolled back.");
            }
            catch (RollbackException rbe) {
                System.out.println("Got expected exception: " + rbe.getLocalizedMessage());
                this.domain.removeResourceSetListener((ResourceSetListener)listener);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)listener);
        }
    }

    public void test_operationTriggerErrorStatus_nonEMF_undo_234868() {
        AbstractOperation trigger = new AbstractOperation("Non-EMF Changes"){

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return new Status(4, "org.eclipse.emf.workspace.tests", "I should fail");
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }
        };
        TriggerListener listener = new TriggerListener((IUndoableOperation)trigger){
            private final /* synthetic */ IUndoableOperation val$trigger;
            {
                this.val$trigger = iUndoableOperation;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new EMFOperationCommand(domain, this.val$trigger);
            }
        };
        try {
            this.domain.addResourceSetListener((ResourceSetListener)listener);
            TestOperation op = new TestOperation(this.domain){

                protected void doExecute() throws ExecutionException {
                    Book book = (Book)EMFOperationCommandTest.this.find("root/Root Book");
                    book.setCopies(book.getCopies() + 30);
                }
            };
            try {
                op.execute(null, null);
            }
            catch (ExecutionException e) {
                EMFOperationCommandTest.fail((String)("Should not fail to execute: " + e.getLocalizedMessage()));
            }
            try {
                op.undo(null, null);
                EMFOperationCommandTest.fail((String)"Should have failed to undo.");
            }
            catch (ExecutionException e) {
                System.out.println("Got expected exception: " + e.getLocalizedMessage());
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)listener);
        }
    }

    public void test_operationTriggerErrorStatus_nonEMF_redo_234868() {
        AbstractOperation trigger = new AbstractOperation("Non-EMF Changes"){

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return new Status(4, "org.eclipse.emf.workspace.tests", "I should fail");
            }
        };
        TriggerListener listener = new TriggerListener((IUndoableOperation)trigger){
            private final /* synthetic */ IUndoableOperation val$trigger;
            {
                this.val$trigger = iUndoableOperation;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new EMFOperationCommand(domain, this.val$trigger);
            }
        };
        try {
            this.domain.addResourceSetListener((ResourceSetListener)listener);
            TestOperation op = new TestOperation(this.domain){

                protected void doExecute() throws ExecutionException {
                    Book book = (Book)EMFOperationCommandTest.this.find("root/Root Book");
                    book.setCopies(book.getCopies() + 30);
                }
            };
            try {
                op.execute(null, null);
            }
            catch (ExecutionException e) {
                EMFOperationCommandTest.fail((String)("Should not fail to execute: " + e.getLocalizedMessage()));
            }
            try {
                op.undo(null, null);
            }
            catch (ExecutionException e) {
                EMFOperationCommandTest.fail((String)("Should not fail to undo: " + e.getLocalizedMessage()));
            }
            try {
                op.redo(null, null);
                EMFOperationCommandTest.fail((String)"Should have failed to redo.");
            }
            catch (ExecutionException e) {
                System.out.println("Got expected exception: " + e.getLocalizedMessage());
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)listener);
        }
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        validationEnabled = true;
    }

    protected void doTearDown() throws Exception {
        validationEnabled = false;
        super.doTearDown();
    }
}

