/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.examples.extlibrary.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.examples.extlibrary.console.ConsoleUtil;
import org.eclipse.emf.workspace.examples.extlibrary.internal.l10n.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;

public class LongRunningReadAction
extends Action {
    private static final String CONSOLE = Messages.readConsole_title;
    private TransactionalEditingDomain domain;

    public LongRunningReadAction() {
        super(Messages.readJob_title);
    }

    public void run() {
        if (this.domain != null) {
            ConsoleUtil.showConsole(CONSOLE);
            ReadJob readJob = new ReadJob(this.getText(), this.domain);
            readJob.schedule();
        }
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = (TransactionalEditingDomain)((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
        this.setEnabled(this.domain != null);
    }

    private static class ReadJob
    extends Job {
        private static int nextId = 0;
        private final TransactionalEditingDomain domain;
        private final int id;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ReadJob(String label, TransactionalEditingDomain domain) {
            super(label);
            this.domain = domain;
            Class<ReadJob> clazz = ReadJob.class;
            synchronized (ReadJob.class) {
                this.id = nextId++;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.setPriority(30);
                return;
            }
        }

        protected IStatus run(final IProgressMonitor monitor) {
            try {
                return (IStatus)TransactionUtil.runExclusive((TransactionalEditingDomain)this.domain, (RunnableWithResult)new RunnableWithResult.Impl<IStatus>(){

                    public void run() {
                        this.setResult(ReadJob.this.longRunningRead(monitor));
                    }
                });
            }
            catch (InterruptedException e) {
                return Status.CANCEL_STATUS;
            }
        }

        private IStatus longRunningRead(IProgressMonitor monitor) {
            int i = 0;
            while (i < 60) {
                ConsoleUtil.println(CONSOLE, NLS.bind((String)Messages.readJob_msg, (Object)new Integer(this.id), (Object)new Integer(i)));
                int j = 0;
                while (j < 5) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        return Status.CANCEL_STATUS;
                    }
                    this.domain.yield();
                    ++j;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
    }
}

