/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private XMLUtil() {
    }

    public static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static Element loadRootElement(DocumentBuilder documentBuilder, File file) throws Exception {
        Document document = XMLUtil.loadDocument(documentBuilder, file);
        return document.getDocumentElement();
    }

    public static Document loadDocument(DocumentBuilder documentBuilder, File file) throws SAXException, IOException {
        return documentBuilder.parse(file);
    }

    public static int handleElements(NodeList nodeList, ElementHandler handler) throws Exception {
        int count = 0;
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                handler.handleElement(element);
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int handleChildElements(Element rootElement, ElementHandler handler) throws Exception {
        NodeList childNodes = rootElement.getChildNodes();
        return XMLUtil.handleElements(childNodes, handler);
    }

    public static int handleElementsByTagName(Element rootElement, String tagName, ElementHandler handler) throws Exception {
        int count = 0;
        NodeList nodeList = rootElement.getElementsByTagName(tagName);
        count += XMLUtil.handleElements(nodeList, handler);
        int pos = tagName.indexOf(58);
        if (pos != -1) {
            tagName = tagName.substring(pos + 1);
            nodeList = rootElement.getElementsByTagName(tagName);
            count += XMLUtil.handleElements(nodeList, handler);
        }
        return count;
    }

    @FunctionalInterface
    public static interface ElementHandler {
        public void handleElement(Element var1) throws Exception;
    }
}

