/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.net4j.db.DBException;

public final class Batch
implements AutoCloseable {
    private final Statement statement;

    public Batch(Connection connection, String ... sqls) {
        try {
            this.statement = connection.createStatement();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
        String[] stringArray = sqls;
        int n = sqls.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            this.add(sql);
            ++n2;
        }
    }

    public void add(String sql) {
        try {
            this.statement.addBatch(sql);
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public void clear() {
        try {
            this.statement.clearBatch();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public int[] execute() {
        try {
            return this.statement.executeBatch();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    @Override
    public void close() throws DBException {
        try {
            this.statement.close();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }
}

