/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.compile.BaseJoinStrategy;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class NestedLoopJoinStrategy
extends BaseJoinStrategy {
    NestedLoopJoinStrategy() {
        int i = 3;
    }

    @Override
    public boolean feasible(Optimizable innerTable, OptimizablePredicateList predList, Optimizer optimizer) throws StandardException {
        if (innerTable.isMaterializable()) {
            return true;
        }
        return innerTable.supportsMultipleInstantiations();
    }

    @Override
    public boolean multiplyBaseCostByOuterRows() {
        return true;
    }

    @Override
    public OptimizablePredicateList getBasePredicates(OptimizablePredicateList predList, OptimizablePredicateList basePredicates, Optimizable innerTable) throws StandardException {
        SanityManager.ASSERT(basePredicates == null || basePredicates.size() == 0, "The base predicate list should be empty.");
        if (predList != null) {
            predList.transferAllPredicates(basePredicates);
            basePredicates.classify(innerTable, innerTable.getCurrentAccessPath().getConglomerateDescriptor());
        }
        return basePredicates;
    }

    @Override
    public double nonBasePredicateSelectivity(Optimizable innerTable, OptimizablePredicateList predList) {
        return 1.0;
    }

    @Override
    public void putBasePredicates(OptimizablePredicateList predList, OptimizablePredicateList basePredicates) throws StandardException {
        for (int i = basePredicates.size() - 1; i >= 0; --i) {
            OptimizablePredicate pred = basePredicates.getOptPredicate(i);
            predList.addOptPredicate(pred);
            basePredicates.removeOptPredicate(i);
        }
    }

    @Override
    public void estimateCost(Optimizable innerTable, OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, CostEstimate costEstimate) {
        costEstimate.multiply(outerCost.rowCount(), costEstimate);
        if (innerTable.optimizerTracingIsOn()) {
            innerTable.getOptimizerTracer().traceCostOfNScans(innerTable.getTableNumber(), outerCost.rowCount(), costEstimate);
        }
    }

    @Override
    public int maxCapacity(int userSpecifiedCapacity, int maxMemoryPerTable, double perRowUsage) {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getName() {
        return "NESTEDLOOP";
    }

    @Override
    public int scanCostType() {
        return 2;
    }

    @Override
    public String getOperatorSymbol() {
        return "*";
    }

    @Override
    public String resultSetMethodName(boolean bulkFetch, boolean multiprobe, boolean validatingCheckConstraint) {
        if (validatingCheckConstraint) {
            return "getValidateCheckConstraintResultSet";
        }
        if (bulkFetch) {
            return "getBulkTableScanResultSet";
        }
        if (multiprobe) {
            return "getMultiProbeTableScanResultSet";
        }
        return "getTableScanResultSet";
    }

    @Override
    public String joinResultSetMethodName() {
        return "getNestedLoopJoinResultSet";
    }

    @Override
    public String halfOuterJoinResultSetMethodName() {
        return "getNestedLoopLeftOuterJoinResultSet";
    }

    @Override
    public int getScanArgs(TransactionController tc, MethodBuilder mb, Optimizable innerTable, OptimizablePredicateList storeRestrictionList, OptimizablePredicateList nonStoreRestrictionList, ExpressionClassBuilderInterface acbi, int bulkFetch, int resultRowTemplate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int maxMemoryPerTable, boolean genInListVals) throws StandardException {
        ExpressionClassBuilder acb = (ExpressionClassBuilder)acbi;
        if (nonStoreRestrictionList.size() != 0) {
            SanityManager.THROWASSERT("nonStoreRestrictionList should be empty for nested loop join strategy, but it contains " + nonStoreRestrictionList.size() + " elements");
        }
        int numArgs = genInListVals ? 26 : (bulkFetch > 1 ? 26 : 24);
        this.fillInScanArgs1(tc, mb, innerTable, storeRestrictionList, acb, resultRowTemplate);
        if (genInListVals) {
            ((PredicateList)storeRestrictionList).generateInListValues(acb, mb);
        }
        if (!genInListVals) {
            for (int i = storeRestrictionList.size() - 1; i >= 0; --i) {
                Predicate pred = (Predicate)storeRestrictionList.getOptPredicate(i);
                if (!pred.isInListProbePredicate()) continue;
                SanityManager.THROWASSERT("Found IN-list probing predicate (" + pred.binaryRelOpColRefsToString() + ") when no such predicates were expected.");
            }
        }
        this.fillInScanArgs2(mb, innerTable, bulkFetch, colRefItem, indexColItem, lockMode, tableLocked, isolationLevel);
        return numArgs;
    }

    @Override
    public void divideUpPredicateLists(Optimizable innerTable, OptimizablePredicateList originalRestrictionList, OptimizablePredicateList storeRestrictionList, OptimizablePredicateList nonStoreRestrictionList, OptimizablePredicateList requalificationRestrictionList, DataDictionary dd) throws StandardException {
        originalRestrictionList.setPredicatesAndProperties(storeRestrictionList);
    }

    @Override
    public boolean doesMaterialization() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    protected boolean validForOutermostTable() {
        return true;
    }
}

