/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class DistinctNode
extends SingleChildResultSetNode {
    boolean inSortedOrder;

    DistinctNode(ResultSetNode childResult, boolean inSortedOrder, Properties tableProperties, ContextManager cm) throws StandardException {
        super(childResult, tableProperties, cm);
        if (!(childResult instanceof Optimizable)) {
            SanityManager.THROWASSERT("childResult, " + childResult.getClass().getName() + ", expected to be instanceof Optimizable");
        }
        if (!(childResult instanceof FromTable)) {
            SanityManager.THROWASSERT("childResult, " + childResult.getClass().getName() + ", expected to be instanceof FromTable");
        }
        ResultColumnList prRCList = this.childResult.getResultColumns().copyListAndObjects();
        this.setResultColumns(this.childResult.getResultColumns());
        this.childResult.setResultColumns(prRCList);
        this.getResultColumns().genVirtualColumnNodes(this, prRCList);
        this.getResultColumns().verifyAllOrderable();
        this.inSortedOrder = inSortedOrder;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, predList, outerCost, rowOrdering);
        return super.optimizeIt(optimizer, predList, outerCost, rowOrdering);
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        CostEstimate childCost = ((Optimizable)((Object)this.childResult)).estimateCost(predList, cd, outerCost, optimizer, rowOrdering);
        this.setCostEstimate(this.getCostEstimate(optimizer));
        this.getCostEstimate().setCost(childCost.getEstimatedCost(), childCost.rowCount(), childCost.singleScanRowCount());
        return this.getCostEstimate();
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return false;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, predicates, outerRows);
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.getCostEstimate().setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    @Override
    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, List<FromBaseTable> fbtHolder) {
        return false;
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        int orderItem = acb.addItem(acb.getColumnOrdering(this.getResultColumns()));
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        mb.push(true);
        mb.push(this.inSortedOrder);
        mb.push(orderItem);
        mb.push(acb.addItem(this.getResultColumns().buildRowTemplate()));
        mb.push(this.getResultColumns().getTotalColumnSize());
        mb.push(this.getResultSetNumber());
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.callMethod((short)185, null, "getSortResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 9);
    }
}

