/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.internal.mongodb.Classes;
import org.eclipse.emf.cdo.server.internal.mongodb.Coll;
import org.eclipse.emf.cdo.server.internal.mongodb.IDHandler;
import org.eclipse.emf.cdo.server.internal.mongodb.MongoDBStore;
import org.eclipse.emf.cdo.server.internal.mongodb.MongoDBStoreAccessor;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class Commits
extends Coll {
    public static final String COMMITS = "commits";
    public static final String COMMITS_ID = "_id";
    public static final String COMMITS_PREVIOUS = "previous";
    public static final String COMMITS_BRANCH = "branch";
    public static final String COMMITS_USER = "user";
    public static final String COMMITS_COMMENT = "comment";
    public static final String UNITS = "units";
    public static final String UNITS_ID = "id";
    public static final String UNITS_TYPE = "type";
    public static final String UNITS_DATA = "data";
    public static final String PACKAGES = "packages";
    public static final String PACKAGES_URI = "uri";
    public static final String PACKAGES_PARENT = "parent";
    public static final String CLASSIFIER_PREFIX = "c";
    public static final String SET_SUFFIX = "___set";
    public static final String REVISIONS = "revisions";
    public static final String REVISIONS_ID = "cdo_id";
    public static final String REVISIONS_VERSION = "cdo_version";
    private static final String REVISIONS_REVISED = "cdo_revised";
    public static final String REVISIONS_CLASS = "cdo_class";
    public static final String REVISIONS_RESOURCE = "cdo_resource";
    public static final String REVISIONS_CONTAINER = "cdo_container";
    public static final String REVISIONS_FEATURE = "cdo_feature";
    private static final boolean ZIP_PACKAGE_BYTES = true;
    private InternalCDOPackageRegistry packageRegistry;
    private IDHandler idHandler;
    private InternalCDOPackageUnit[] systemPackageUnits;
    private EStructuralFeature resourceNameFeature;

    public Commits(MongoDBStore store) {
        super(store, COMMITS);
        this.ensureIndex(UNITS, UNITS_ID);
        if (store.isBranching()) {
            BasicDBObject index = new BasicDBObject();
            index.put("revisions.cdo_id", (Object)1);
            index.put(COMMITS_BRANCH, (Object)1);
            index.put("revisions.cdo_version", (Object)1);
            this.collection.createIndex((DBObject)index);
        } else {
            this.ensureIndex(REVISIONS, REVISIONS_ID, REVISIONS_VERSION);
        }
        this.packageRegistry = store.getRepository().getPackageRegistry();
        this.idHandler = store.getIDHandler();
    }

    public void writePackageUnits(MongoDBStoreAccessor mongoDBStoreAccessor, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        this.systemPackageUnits = packageUnits;
        int i = 0;
        while (i < packageUnits.length) {
            InternalCDOPackageUnit packageUnit = packageUnits[i];
            InternalCDOPackageInfo[] packageInfos = packageUnit.getPackageInfos();
            int j = 0;
            while (j < packageInfos.length) {
                InternalCDOPackageInfo packageInfo = packageInfos[j];
                for (EClassifier classifier : packageInfo.getEPackage().getEClassifiers()) {
                    this.store.getClasses().mapNewClassifier(classifier);
                }
                ++j;
            }
            ++i;
        }
    }

    private DBObject[] marshallUnits(InternalCDOPackageUnit[] packageUnits) {
        DBObject[] result = new DBObject[packageUnits.length];
        InternalCDOPackageRegistry packageRegistry = this.store.getRepository().getPackageRegistry();
        int i = 0;
        while (i < packageUnits.length) {
            InternalCDOPackageUnit packageUnit = packageUnits[i];
            EPackage ePackage = packageUnit.getTopLevelPackageInfo().getEPackage();
            byte[] bytes = EMFUtil.getEPackageBytes((EPackage)ePackage, (boolean)true, (EPackage.Registry)packageRegistry);
            DBObject[] packages = this.marshallPackages(packageUnit.getPackageInfos());
            BasicDBObject doc = new BasicDBObject();
            doc.put(UNITS_ID, (Object)packageUnit.getID());
            doc.put(UNITS_TYPE, (Object)packageUnit.getOriginalType().toString());
            doc.put(UNITS_DATA, (Object)bytes);
            doc.put(PACKAGES, (Object)packages);
            result[i] = doc;
            ++i;
        }
        return result;
    }

    private DBObject[] marshallPackages(InternalCDOPackageInfo[] packageInfos) {
        DBObject[] result = new DBObject[packageInfos.length];
        int i = 0;
        while (i < packageInfos.length) {
            InternalCDOPackageInfo packageInfo = packageInfos[i];
            BasicDBObject doc = new BasicDBObject();
            doc.put(PACKAGES_URI, (Object)packageInfo.getPackageURI());
            String parent = packageInfo.getParentURI();
            if (!StringUtil.isEmpty((String)parent)) {
                doc.put(PACKAGES_PARENT, (Object)parent);
            }
            for (EClassifier classifier : packageInfo.getEPackage().getEClassifiers()) {
                int classifierID = this.store.getClasses().mapNewClassifier(classifier);
                doc.put(CLASSIFIER_PREFIX + classifierID, (Object)classifier.getName());
            }
            result[i] = doc;
            ++i;
        }
        return result;
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        final ArrayList<InternalCDOPackageUnit> packageUnits = new ArrayList<InternalCDOPackageUnit>();
        BasicDBObject query = new BasicDBObject();
        query.put(UNITS, (Object)new BasicDBObject("$exists", (Object)true));
        new QueryEmbeddedUnits<Object>(this, (DBObject)query){

            @Override
            protected Object handleEmbedded(DBObject doc, DBObject embedded) {
                long time = (Long)doc.get(Commits.COMMITS_ID);
                CDOPackageUnit.Type type = CDOPackageUnit.Type.valueOf((String)((String)embedded.get(Commits.UNITS_TYPE)));
                InternalCDOPackageInfo[] infos = this.readPackageInfos(embedded);
                InternalCDOPackageUnit packageUnit = this.createPackageUnit();
                packageUnit.setOriginalType(type);
                packageUnit.setTimeStamp(time);
                packageUnit.setPackageInfos(infos);
                packageUnits.add(packageUnit);
                return null;
            }

            private InternalCDOPackageInfo[] readPackageInfos(DBObject embedded) {
                BasicDBList infos = (BasicDBList)embedded.get(Commits.PACKAGES);
                InternalCDOPackageInfo[] result = new InternalCDOPackageInfo[infos.size()];
                int i = 0;
                for (Object info : infos) {
                    DBObject infoObject = (DBObject)info;
                    String uri = (String)infoObject.get(Commits.PACKAGES_URI);
                    String parent = (String)infoObject.get(Commits.PACKAGES_PARENT);
                    InternalCDOPackageInfo packageInfo = this.createPackageInfo();
                    packageInfo.setPackageURI(uri);
                    packageInfo.setParentURI(parent);
                    result[i++] = packageInfo;
                }
                return result;
            }

            private InternalCDOPackageUnit createPackageUnit() {
                return (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit();
            }

            private InternalCDOPackageInfo createPackageInfo() {
                return (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
            }
        }.execute();
        return packageUnits;
    }

    public EPackage[] loadPackageUnit(final InternalCDOPackageUnit packageUnit) {
        BasicDBObject query = new BasicDBObject();
        query.put("units.id", (Object)packageUnit.getID());
        return (EPackage[])new QueryEmbeddedUnits<EPackage[]>(this, (DBObject)query){

            @Override
            protected EPackage[] handleEmbedded(DBObject doc, DBObject embedded) {
                byte[] data = (byte[])embedded.get(Commits.UNITS_DATA);
                EPackage ePackage = this.createEPackage(packageUnit, data);
                return EMFUtil.getAllPackages((EPackage)ePackage);
            }

            private EPackage createEPackage(InternalCDOPackageUnit packageUnit2, byte[] bytes) {
                ResourceSet resourceSet = EMFUtil.newEcoreResourceSet((EPackage.Registry)packageRegistry);
                return EMFUtil.createEPackage((String)packageUnit2.getID(), (byte[])bytes, (boolean)true, (ResourceSet)resourceSet, (boolean)false);
            }
        }.execute();
    }

    public void initializeClassifiers() {
        final Classes classes = this.store.getClasses();
        BasicDBObject query = new BasicDBObject();
        query.put(UNITS, (Object)new BasicDBObject("$exists", (Object)true));
        new QueryEmbeddedUnits<Object>(this, (DBObject)query){

            @Override
            protected Object handleEmbedded(DBObject doc, DBObject embedded) {
                BasicDBList infos = (BasicDBList)embedded.get(Commits.PACKAGES);
                for (Object info : infos) {
                    DBObject infoObject = (DBObject)info;
                    String uri = (String)infoObject.get(Commits.PACKAGES_URI);
                    this.handleClassifiers(infoObject, uri);
                }
                return null;
            }

            private void handleClassifiers(DBObject embedded, String packageURI) {
                Set keys = embedded.keySet();
                for (String key : keys) {
                    if (!key.startsWith(Commits.CLASSIFIER_PREFIX)) continue;
                    int id = Integer.parseInt(key.substring(Commits.CLASSIFIER_PREFIX.length()));
                    String classifierName = (String)embedded.get(key);
                    CDOClassifierRef classifierRef = new CDOClassifierRef(packageURI, classifierName);
                    EClassifier classifier = classifierRef.resolve((EPackage.Registry)packageRegistry);
                    classes.mapClassifier(classifier, id);
                }
            }
        }.execute();
    }

    public void write(MongoDBStoreAccessor accessor, InternalCommitContext context, OMMonitor monitor) {
        try {
            Object[] newPackageUnits;
            String comment;
            String user;
            boolean firstCommit;
            monitor.begin(104.0);
            CDOBranchPoint branchPoint = context.getBranchPoint();
            BasicDBObject doc = new BasicDBObject();
            doc.put(COMMITS_ID, (Object)branchPoint.getTimeStamp());
            long previous = context.getPreviousTimeStamp();
            boolean bl = firstCommit = previous == 0L;
            if (!firstCommit) {
                doc.put(COMMITS_PREVIOUS, (Object)previous);
            }
            if (this.store.isBranching()) {
                doc.put(COMMITS_BRANCH, (Object)branchPoint.getBranch().getID());
            }
            if (!StringUtil.isEmpty((String)(user = context.getUserID()))) {
                doc.put(COMMITS_USER, (Object)user);
            }
            if (!StringUtil.isEmpty((String)(comment = context.getCommitComment()))) {
                doc.put(COMMITS_COMMENT, (Object)comment);
            }
            Object[] objectArray = newPackageUnits = firstCommit ? this.systemPackageUnits : context.getNewPackageUnits();
            if (!ObjectUtil.isEmpty((Object[])newPackageUnits)) {
                doc.put(UNITS, (Object)this.marshallUnits((InternalCDOPackageUnit[])newPackageUnits));
            }
            monitor.worked();
            accessor.addIDMappings(context, monitor.fork());
            context.applyIDMappings(monitor.fork());
            ArrayList<DBObject> docs = new ArrayList<DBObject>();
            this.marshalRevisions(docs, context, context.getNewObjects(), CDOChangeKind.NEW);
            this.marshalRevisions(docs, context, context.getDirtyObjects(), CDOChangeKind.CHANGED);
            this.marshalRevisions(docs, context, context.getDetachedRevisions(), CDOChangeKind.DETACHED);
            if (!docs.isEmpty()) {
                doc.put(REVISIONS, docs);
            }
            monitor.worked();
            this.collection.insert(new DBObject[]{doc});
            monitor.worked(100.0);
        }
        finally {
            monitor.done();
        }
    }

    private void marshalRevisions(List<DBObject> docs, InternalCommitContext context, InternalCDORevision[] revisions, CDOChangeKind changeKind) {
        InternalCDORevision[] internalCDORevisionArray = revisions;
        int n = revisions.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            DBObject doc = this.marshallRevision(context, revision, changeKind);
            docs.add(doc);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private DBObject marshallRevision(InternalCommitContext context, InternalCDORevision revision, CDOChangeKind changeKind) {
        v0 = resource = revision instanceof SyntheticCDORevision == false && revision.isResource() != false;
        if (resource && this.resourceNameFeature == null) {
            this.resourceNameFeature = revision.getEClass().getEStructuralFeature("name");
        }
        doc = new BasicDBObject();
        this.idHandler.write((DBObject)doc, "cdo_id", revision.getID());
        eClass = revision.getEClass();
        doc.put("cdo_class", (Object)this.store.getClasses().getClassifierID((EClassifier)eClass));
        if (changeKind == CDOChangeKind.DETACHED) {
            doc.put("cdo_version", (Object)(-revision.getVersion() - 1));
            return doc;
        }
        doc.put("cdo_version", (Object)revision.getVersion());
        resourceID = revision.getResourceID();
        this.idHandler.write((DBObject)doc, "cdo_resource", resourceID);
        containerID = (CDOID)revision.getContainerID();
        this.idHandler.write((DBObject)doc, "cdo_container", containerID);
        featureID = revision.getContainingFeatureID();
        doc.put("cdo_feature", (Object)featureID);
        if (resource && changeKind != CDOChangeKind.DETACHED) {
            name = (String)revision.data().get(this.resourceNameFeature, 0);
            accessor = StoreThreadLocal.getAccessor();
            existingID = accessor.readResourceID(containerID, name, (CDOBranchPoint)revision);
            if (existingID != null && !existingID.equals(revision.getID()) && !this.isBeingDetached(context, existingID)) {
                throw new IllegalStateException("Duplicate resource: name=" + name + ", folderID=" + containerID);
            }
        }
        classInfo = revision.getClassInfo();
        var14_14 = classInfo.getAllPersistentFeatures();
        var13_15 = var14_14.length;
        var12_13 = 0;
        while (var12_13 < var13_15) {
            feature = var14_14[var12_13];
            value = revision.getValue(feature);
            type = CDOModelUtil.getType((EStructuralFeature)feature);
            valueHandler = this.store.getValueHandler(type);
            if (!feature.isUnsettable()) ** GOTO lbl46
            if (value == null) {
                doc.put(String.valueOf(feature.getName()) + "___set", (Object)false);
                doc.put(feature.getName(), valueHandler.getMongoDefaultValue(feature));
            } else {
                doc.put(String.valueOf(feature.getName()) + "___set", (Object)true);
lbl46:
                // 2 sources

                if (value == CDORevisionData.NIL) {
                    doc.put(feature.getName(), null);
                } else if (value == null) {
                    if (feature.isMany() || feature.getDefaultValue() == null) {
                        doc.put(feature.getName(), null);
                    } else {
                        doc.put(feature.getName(), valueHandler.getMongoDefaultValue(feature));
                    }
                } else {
                    if (feature.isMany()) {
                        cdoList = (List)value;
                        mongoList = new BasicDBList();
                        for (E element : cdoList) {
                            element /* !! */  = valueHandler.toMongo(element /* !! */ );
                            mongoList.add(element /* !! */ );
                        }
                        value = mongoList;
                    } else {
                        value = valueHandler.toMongo(value);
                    }
                    doc.put(feature.getName(), value);
                }
            }
            ++var12_13;
        }
        return doc;
    }

    private boolean isBeingDetached(InternalCommitContext context, CDOID id) {
        CDOID[] cDOIDArray = context.getDetachedObjects();
        int n = cDOIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID idBeingDetached = cDOIDArray[n2];
            if (id.equals(idBeingDetached)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void queryResources(final IStoreAccessor.QueryResourcesContext context) {
        Classes classes = this.getStore().getClasses();
        final int folderCID = classes.getResourceFolderClassID();
        final int resourceCID = classes.getResourceClassID();
        final CDOID folderID = context.getFolderID();
        final String name = context.getName();
        final boolean exactMatch = context.exactMatch();
        final long timeStamp = context.getTimeStamp();
        BasicDBObject query = new BasicDBObject();
        query.put("revisions.cdo_class", (Object)new BasicDBObject("$in", (Object)new int[]{folderCID, resourceCID}));
        this.addToQuery((DBObject)query, (CDOBranchPoint)context);
        query.put("revisions.cdo_container", this.idHandler.toValue(folderID));
        if (name == null || exactMatch) {
            query.put("revisions.name", (Object)name);
        } else {
            query.put("revisions.name", (Object)Pattern.compile("^" + name));
        }
        new QueryEmbeddedRevisions<Boolean>(this, (DBObject)query){

            @Override
            protected Boolean handleEmbedded(DBObject doc, DBObject embedded) {
                long revised;
                int classID = (Integer)embedded.get(Commits.REVISIONS_CLASS);
                if (classID != folderCID && classID != resourceCID) {
                    return null;
                }
                int version = (Integer)embedded.get(Commits.REVISIONS_VERSION);
                if (version <= 0) {
                    return null;
                }
                CDOID container = idHandler.read(embedded, Commits.REVISIONS_CONTAINER);
                if (!ObjectUtil.equals((Object)container, (Object)folderID)) {
                    return null;
                }
                String revisionName = (String)embedded.get("name");
                if (name == null || exactMatch ? !ObjectUtil.equals((Object)revisionName, (Object)name) : !revisionName.startsWith(name)) {
                    return null;
                }
                CDOID id = idHandler.read(embedded, Commits.REVISIONS_ID);
                long created = (Long)doc.get(Commits.COMMITS_ID);
                if (!CDOCommonUtil.isValidTimeStamp((long)timeStamp, (long)created, (long)(revised = this.getRevised(id, context.getBranch(), version, doc, embedded)))) {
                    return null;
                }
                if (!context.addResource(id)) {
                    return true;
                }
                return null;
            }
        }.execute();
    }

    private long getRevised(CDOID id, CDOBranch branch, int version, DBObject doc, DBObject revision) {
        Object value = revision.get(REVISIONS_REVISED);
        if (value instanceof Long) {
            return (Long)value;
        }
        BasicDBObject query = new BasicDBObject();
        this.idHandler.write((DBObject)query, "revisions.cdo_id", id);
        if (this.store.isBranching()) {
            query.put(COMMITS_BRANCH, (Object)branch.getID());
        }
        int nextVersion = version + 1;
        query.put("revisions.cdo_version", (Object)new BasicDBObject("$in", (Object)new int[]{nextVersion, -nextVersion}));
        Long result = (Long)new Coll.Query<Long>((Coll)this, (DBObject)query){

            @Override
            protected Long handleDoc(DBObject doc) {
                return (Long)doc.get(Commits.COMMITS_ID);
            }
        }.execute();
        if (result != null) {
            long revised = result - 1L;
            return revised;
        }
        return 0L;
    }

    public InternalCDORevision readRevision(final CDOID id, CDOBranchPoint branchPoint, int listChunk) {
        final CDOBranch branch = branchPoint.getBranch();
        final long timeStamp = branchPoint.getTimeStamp();
        BasicDBObject query = new BasicDBObject();
        this.idHandler.write((DBObject)query, "revisions.cdo_id", id);
        this.addToQuery((DBObject)query, branchPoint);
        return new QueryEmbeddedRevisions<InternalCDORevision>(this, (DBObject)query){

            @Override
            public InternalCDORevision execute() {
                return (InternalCDORevision)this.execute(collection.find(this.getRef()).sort((DBObject)new BasicDBObject(Commits.COMMITS_ID, (Object)-1)).limit(1));
            }

            @Override
            protected InternalCDORevision handleEmbedded(DBObject doc, DBObject embedded) {
                CDOBranchPoint revisionBranchPoint;
                InternalCDORevision revision;
                long revised;
                CDOID embeddedID = idHandler.read(embedded, Commits.REVISIONS_ID);
                if (!ObjectUtil.equals((Object)embeddedID, (Object)id)) {
                    return null;
                }
                long created = (Long)doc.get(Commits.COMMITS_ID);
                if (!CDOCommonUtil.isValidTimeStamp((long)timeStamp, (long)created, (long)(revised = (revision = this.unmarshallRevision(doc, embedded, id, revisionBranchPoint = branch.getPoint(created))).getRevised()))) {
                    return null;
                }
                return revision;
            }
        }.execute();
    }

    private void addToQuery(DBObject query, CDOBranchPoint branchPoint) {
        query.put("revisions.cdo_version", (Object)new BasicDBObject("$gte", (Object)1));
        long timeStamp = branchPoint.getTimeStamp();
        if (timeStamp != 0L) {
            query.put(COMMITS_ID, (Object)new BasicDBObject("$lte", (Object)timeStamp));
        }
        if (this.store.isBranching()) {
            int branch = branchPoint.getBranch().getID();
            query.put(COMMITS_BRANCH, (Object)branch);
        }
    }

    public InternalCDORevision readRevisionByVersion(final CDOID id, CDOBranchVersion branchVersion, int listChunk) {
        BasicDBObject query = new BasicDBObject();
        this.idHandler.write((DBObject)query, "revisions.cdo_id", id);
        int version = branchVersion.getVersion();
        query.put("revisions.cdo_version", (Object)new BasicDBObject("$in", (Object)new int[]{version, -version}));
        final CDOBranch branch = branchVersion.getBranch();
        if (this.store.isBranching()) {
            query.put(COMMITS_BRANCH, (Object)branch.getID());
        }
        return (InternalCDORevision)new QueryEmbeddedRevisions<InternalCDORevision>(this, (DBObject)query){

            @Override
            protected InternalCDORevision handleEmbedded(DBObject doc, DBObject embedded) {
                CDOID revisionID = idHandler.read(embedded, Commits.REVISIONS_ID);
                if (!ObjectUtil.equals((Object)revisionID, (Object)id)) {
                    return null;
                }
                long revisionTime = (Long)doc.get(Commits.COMMITS_ID);
                CDOBranchPoint branchPoint = branch.getPoint(revisionTime);
                return this.unmarshallRevision(doc, embedded, id, branchPoint);
            }
        }.execute();
    }

    private InternalCDORevision unmarshallRevision(DBObject doc, DBObject embedded, CDOID id, CDOBranchPoint branchPoint) {
        int classID = (Integer)embedded.get(REVISIONS_CLASS);
        EClass eClass = this.store.getClasses().getClass(classID);
        CDOBranch branch = branchPoint.getBranch();
        int version = (Integer)embedded.get(REVISIONS_VERSION);
        long revised = this.getRevised(id, branch, Math.abs(version), doc, embedded);
        if (version < 1) {
            long timeStamp = branchPoint.getTimeStamp();
            return new DetachedCDORevision(eClass, id, branch, -version, timeStamp, revised);
        }
        CDOID resourceID = this.idHandler.read(embedded, REVISIONS_RESOURCE);
        CDOID containerID = this.idHandler.read(embedded, REVISIONS_CONTAINER);
        int featureID = (Integer)embedded.get(REVISIONS_FEATURE);
        InternalCDORevision result = this.store.createRevision(eClass, id);
        result.setBranchPoint(branchPoint);
        result.setRevised(revised);
        result.setVersion(version);
        result.setResourceID(resourceID);
        result.setContainerID((Object)containerID);
        result.setContainingFeatureID(featureID);
        this.unmarshallRevision(embedded, result);
        return result;
    }

    private void unmarshallRevision(DBObject doc, InternalCDORevision revision) {
        InternalCDOClassInfo classInfo = revision.getClassInfo();
        EStructuralFeature[] eStructuralFeatureArray = classInfo.getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean set;
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            Object value = doc.get(feature.getName());
            if (!feature.isUnsettable() || (set = ((Boolean)doc.get(String.valueOf(feature.getName()) + SET_SUFFIX)).booleanValue())) {
                if (value == null && !feature.isMany() && feature.getDefaultValue() != null) {
                    value = CDORevisionData.NIL;
                }
                CDOType type = CDOModelUtil.getType((EStructuralFeature)feature);
                MongoDBStore.ValueHandler valueHandler = this.store.getValueHandler(type);
                if (feature.isMany()) {
                    if (value != null) {
                        List list = (List)value;
                        CDOList revisionList = revision.getOrCreateList(feature, list.size());
                        for (Object element : list) {
                            element = valueHandler.fromMongo(element);
                            revisionList.add(element);
                        }
                    }
                } else {
                    value = valueHandler.fromMongo(value);
                    revision.set(feature, -1, value);
                }
            }
            ++n2;
        }
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, final CDOCommitInfoHandler handler) {
        int size;
        if (endTime < 0L) {
            throw new IllegalArgumentException("Counting not supported");
        }
        BasicDBObject query = new BasicDBObject();
        if (branch != null && this.store.isBranching()) {
            query.put(COMMITS_BRANCH, (Object)branch.getID());
        }
        BasicDBList list = new BasicDBList();
        if (startTime != 0L) {
            list.add((Object)new BasicDBObject("$gte", (Object)startTime));
        }
        if (endTime != 0L) {
            list.add((Object)new BasicDBObject("$lte", (Object)endTime));
        }
        if ((size = list.size()) == 2) {
            query.put(COMMITS_ID, (Object)list);
        } else if (size == 1) {
            query.put(COMMITS_ID, list.get(0));
        }
        InternalRepository repository = this.store.getRepository();
        final InternalCDOBranchManager branchManager = repository.getBranchManager();
        final InternalCDOCommitInfoManager commitManager = repository.getCommitInfoManager();
        new Coll.Query<Object>((Coll)this, (DBObject)query){

            @Override
            public Object execute() {
                return this.execute(Commits.this.collection.find(this.getRef()).sort((DBObject)new BasicDBObject(Commits.COMMITS_ID, (Object)1)));
            }

            @Override
            protected Object handleDoc(DBObject doc) {
                InternalCDOBranch commitBranch;
                long previous;
                long time = (Long)doc.get(Commits.COMMITS_ID);
                Object value = doc.get(Commits.COMMITS_PREVIOUS);
                long l = previous = value == null ? 0L : (Long)value;
                if (Commits.this.store.isBranching()) {
                    int branchID = (Integer)doc.get(Commits.COMMITS_BRANCH);
                    commitBranch = branchManager.getBranch(branchID);
                } else {
                    commitBranch = branchManager.getMainBranch();
                }
                String user = (String)doc.get(Commits.COMMITS_USER);
                String comment = (String)doc.get(Commits.COMMITS_COMMENT);
                CDOCommitInfo commitInfo = commitManager.createCommitInfo((CDOBranch)commitBranch, time, previous, user, comment, null, null);
                handler.handleCommitInfo(commitInfo);
                return null;
            }
        }.execute();
    }

    public abstract class QueryEmbedded<RESULT>
    extends Coll.Query<RESULT> {
        private String field;

        public QueryEmbedded(DBObject ref, String field) {
            super(Commits.this, ref);
            this.field = field;
        }

        @Override
        protected RESULT handleDoc(DBObject doc) {
            BasicDBList list = (BasicDBList)doc.get(this.field);
            for (Object object : list) {
                DBObject embedded = (DBObject)object;
                RESULT result = this.handleEmbedded(doc, embedded);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        protected abstract RESULT handleEmbedded(DBObject var1, DBObject var2);
    }

    public abstract class QueryEmbeddedRevisions<RESULT>
    extends QueryEmbedded<RESULT> {
        public QueryEmbeddedRevisions(DBObject ref) {
            super(ref, Commits.REVISIONS);
        }
    }

    public abstract class QueryEmbeddedUnits<RESULT>
    extends QueryEmbedded<RESULT> {
        public QueryEmbeddedUnits(DBObject ref) {
            super(ref, Commits.UNITS);
        }
    }
}

