/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.AbstractRepositoryProperties;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Property;

public class SessionProperties
extends AbstractRepositoryProperties<CDOSession> {
    public static final IProperties<CDOSession> INSTANCE = new SessionProperties();
    private static final String CATEGORY_SESSION = "Session";

    private SessionProperties() {
        super(CDOSession.class);
    }

    protected CDOCommonRepository getRepository(CDOSession session) {
        return session.getRepositoryInfo();
    }

    protected void initProperties() {
        this.add((Property)new Property<CDOSession>("open", Messages.getString("SessionPropertyTester_34"), Messages.getString("SessionPropertyTester_35"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return !session.isClosed();
            }
        });
        this.add((Property)new Property<CDOSession>("sessionID", Messages.getString("SessionPropertyTester_0"), Messages.getString("SessionPropertyTester_3"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.getSessionID();
            }
        });
        this.add((Property)new Property<CDOSession>("userID", Messages.getString("SessionPropertyTester_4"), Messages.getString("SessionPropertyTester_5"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.getUserID();
            }
        });
        this.add((Property)new Property<CDOSession>("passiveUpdateEnabled", Messages.getString("SessionPropertyTester_6"), Messages.getString("SessionPropertyTester_7"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.options().isPassiveUpdateEnabled();
            }
        });
        this.add((Property)new Property<CDOSession>("lastUpdateTime", Messages.getString("SessionPropertyTester_36"), Messages.getString("SessionPropertyTester_37"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return CDOCommonUtil.formatTimeStamp((long)session.getLastUpdateTime());
            }
        });
        this.add((Property)new Property<CDOSession>("passiveUpdateMode", Messages.getString("SessionPropertyTester_8"), Messages.getString("SessionPropertyTester_9"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.options().getPassiveUpdateMode();
            }
        });
        super.initProperties();
        this.add((Property)new Property<CDOSession>("userAuthenticated"){

            protected Object eval(CDOSession session) {
                return !StringUtil.isEmpty((String)session.getUserID());
            }
        });
    }

    public static void main(String[] args) {
        new Tester().dumpContributionMarkup();
    }

    public static final class Tester
    extends DefaultPropertyTester<CDOSession> {
        public static final String NAMESPACE = "org.eclipse.emf.cdo.session";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

