/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.vm;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.LauncherService;
import org.eclipse.m2m.atl.core.ui.vm.Messages;
import org.eclipse.m2m.atl.core.ui.vm.asm.ASMModelWrapper;
import org.eclipse.m2m.atl.core.ui.vm.debug.NetworkDebugger;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMInterpreter;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMStackFrame;
import org.eclipse.m2m.atl.engine.vm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.vm.AtlSuperimposeModule;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.VMException;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegularVMLauncher
implements ILauncher {
    private static final String LAUNCHER_NAME = "Regular VM";
    private Map<String, IModel> models;
    private Map<String, ASM> libraries;
    private boolean checkSameModel;

    public String getName() {
        return LAUNCHER_NAME;
    }

    private void addModel(IModel model, String name, String referenceModelName) {
        if (this.models.containsKey(name)) {
            ATLLogger.warning((String)Messages.getString("RegularVMLauncher.MODEL_REGISTERED", new Object[]{name}));
        } else {
            this.models.put(name, model);
        }
        if (!this.models.containsKey(referenceModelName)) {
            this.models.put(referenceModelName, (IModel)model.getReferenceModel());
        }
    }

    public void addInModel(IModel model, String name, String referenceModelName) {
        this.setCheckSameModel(model);
        model.setIsTarget(false);
        this.addModel(model, name, referenceModelName);
    }

    public void addInOutModel(IModel model, String name, String referenceModelName) {
        this.setCheckSameModel(model);
        model.setIsTarget(true);
        this.addModel(model, name, referenceModelName);
    }

    public void addOutModel(IModel model, String name, String referenceModelName) {
        this.setCheckSameModel(model);
        model.setIsTarget(true);
        this.addModel(model, name, referenceModelName);
    }

    public void addLibrary(String name, Object library) {
        if (this.libraries.containsKey(name)) {
            ATLLogger.warning((String)Messages.getString("RegularVMLauncher.LIBRARY_REGISTERED", new Object[]{name}));
        } else {
            this.libraries.put(name, this.getASMFromObject(library));
        }
    }

    public void initialize(Map<String, Object> options) {
        this.models = new HashMap<String, IModel>();
        this.libraries = new HashMap<String, ASM>();
        this.checkSameModel = !LauncherService.getBooleanOption((Object)options.get("allowInterModelReferences"), (boolean)false);
    }

    public String getDefaultModelFactoryName() {
        return "ASM";
    }

    public Object launch(String mode, IProgressMonitor monitor, Map<String, Object> options, Object ... modules) {
        try {
            if (mode.equals("debug")) {
                return this.internalLaunch(new NetworkDebugger(this.getPort((ILaunch)options.get("launch")), true), options, modules);
            }
            return this.internalLaunch((Debugger)new SimpleDebugger(LauncherService.getBooleanOption((Object)options.get("step"), (boolean)false), Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, true, LauncherService.getBooleanOption((Object)options.get("showSummary"), (boolean)false), LauncherService.getBooleanOption((Object)options.get("profile"), (boolean)false), LauncherService.getBooleanOption((Object)options.get("continueAfterError"), (boolean)false)), options, modules);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new VMException(null, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new VMException(null, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            throw new VMException(null, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AtlSuperimposeModule.AtlSuperimposeModuleException e) {
            throw new VMException(null, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private int getPort(ILaunch launch) throws CoreException {
        String portOption = "";
        if (launch != null) {
            portOption = launch.getLaunchConfiguration().getAttribute("Port", Integer.valueOf(6060).toString());
        }
        if (portOption.equals("")) {
            portOption = Integer.valueOf(6060).toString();
        }
        return new Integer(portOption);
    }

    protected Object internalLaunch(Debugger debugger, Map<String, Object> options, Object[] modules) throws AtlSuperimposeModule.AtlSuperimposeModuleException {
        ASMOclAny ret = null;
        ASM asm = this.getASMFromObject(modules[0]);
        ASMModule asmModule = new ASMModule(asm);
        ASMExecEnv env = new ASMExecEnv(asmModule, debugger, !LauncherService.getBooleanOption((Object)options.get("disableAttributeHelperCache"), (boolean)false));
        env.addPermission("file.read");
        env.addPermission("file.write");
        for (String mname : this.models.keySet()) {
            env.addModel(mname, ((ASMModelWrapper)this.models.get(mname)).getAsmModel());
        }
        for (String lname : this.libraries.keySet()) {
            ASM lib = this.libraries.get(lname);
            env.registerOperations(lib);
            ASMOperation op = lib.getOperation("main");
            if (op == null) continue;
            op.exec((StackFrame)ASMStackFrame.rootFrame((ASMExecEnv)env, (ASMOperation)op, Arrays.asList(asmModule)));
        }
        env.registerOperations(asm);
        int i = 1;
        while (i < modules.length) {
            ASM module = this.getASMFromObject(modules[i]);
            AtlSuperimposeModule ami = new AtlSuperimposeModule(env, module);
            ami.adaptModuleOperations();
            env.registerOperations(module);
            ++i;
        }
        boolean printExecutionTime = LauncherService.getBooleanOption((Object)options.get("printExecutionTime"), (boolean)false);
        long startTime = System.currentTimeMillis();
        ASMInterpreter ai = new ASMInterpreter(asm, asmModule, env, options);
        long endTime = System.currentTimeMillis();
        if (printExecutionTime && !(debugger instanceof NetworkDebugger)) {
            ATLLogger.info((String)(String.valueOf(asm.getName()) + " executed in " + (double)(endTime - startTime) / 1000.0 + "s."));
        }
        ret = ai.getReturnValue();
        return ret;
    }

    public Object loadModule(InputStream inputStream) {
        return new ASMXMLReader().read(inputStream);
    }

    private ASM getASMFromObject(Object module) {
        if (module instanceof InputStream) {
            return (ASM)this.loadModule((InputStream)module);
        }
        if (module instanceof ASM) {
            return (ASM)module;
        }
        return null;
    }

    public IModel getModel(String modelName) {
        return this.models.get(modelName);
    }

    public Object getLibrary(String libraryName) {
        return this.libraries.get(libraryName);
    }

    private void setCheckSameModel(IModel model) {
        if (model instanceof ASMModelWrapper) {
            ASMModel asmModel = ((ASMModelWrapper)model).getAsmModel();
            ((ASMEMFModel)asmModel).setCheckSameModel(this.checkSameModel);
        }
    }

    public String[] getModes() {
        return new String[]{"run", "debug"};
    }
}

