/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtcore.tests;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcore;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;

public class QVTcLoadTests
extends LoadTestCase {
    protected @NonNull OCLInternal createOCL() {
        return QVTcore.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    protected void setUp() throws Exception {
        XtextCompilerUtil.doQVTcoreSetup();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testQVTcLoad_expressions_qvtc() throws Exception {
        this.doLoad_Concrete(this.getModelsURI("misc/expressions.qvtc"), NO_MESSAGES);
    }

    public void testQVTcLoad_mini_qvtc() throws Exception {
        this.doLoad_Concrete(this.getModelsURI("misc/mini.qvtc"), NO_MESSAGES);
    }

    public void testQVTcLoad_uml2rdbms_qvtc() throws Exception {
        this.doLoad_Concrete(this.getModelsURI("misc/uml2rdbms.qvtc"), NO_MESSAGES);
    }

    public void testQVTcLoad_uml2rdbms_qvti_qvtc() throws Exception {
        this.doLoad_Concrete(this.getModelsURI("misc/uml2rdbms.qvti.qvtc"), NO_MESSAGES);
    }

    public void testQVTcLoad_uml2rdbms_qvtu_qvtc() throws Exception {
        this.doLoad_Concrete(this.getModelsURI("misc/uml2rdbms.qvtu.qvtc"), NO_MESSAGES);
    }

    public void testQVTcLoad_HSV2HLS_qvtc() throws Exception {
        this.doLoad_Concrete(this.getModelsURI("misc/HSV2HLS.qvtc"), NO_MESSAGES, StatusCodes.Severity.ERROR);
    }

    public void testQVTcLoad_HSV2HLS2_qvtc() throws Exception {
        this.doLoad_Concrete(this.getModelsURI("hsv2hsl/HSV2HSL.qvtc"), NO_MESSAGES, StatusCodes.Severity.ERROR);
    }

    public void testQVTcLoad_Class2RDBMS_qvtc() throws Exception {
        this.doLoad_Concrete(this.getModelsURI("Class2RDBMS/Class2RDBMS.qvtc"), NO_MESSAGES);
    }

    public void testQVTcLoad_HSV2HSL_qvtias() throws Exception {
        XtextCompilerUtil.doQVTimperativeSetup();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.getTestProjectManager().initializeResourceSet((ResourceSet)resourceSet);
        URI uri = this.getModelsURI("hsv2hsl/HSV2HSL.qvtias");
        Resource resource = resourceSet.getResource(uri, true);
        assert (resource != null);
        QVTcLoadTests.assertNoResourceErrors((String)"Load", (Resource)resource);
        EcoreUtil.resolveAll((Resource)resource);
        QVTcLoadTests.assertNoUnresolvedProxies((String)"Resolve", (Resource)resource);
        QVTcLoadTests.assertNoValidationErrors((String)"Validate", (Resource)resource);
    }

    public void testQVTcLoad_HSV2HSL_qvtsas() throws Exception {
        XtextCompilerUtil.doQVTimperativeSetup();
        XtextCompilerUtil.doQVTscheduleSetup();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.getTestProjectManager().initializeResourceSet((ResourceSet)resourceSet);
        URI uri = this.getModelsURI("hsv2hsl/HSV2HSL.qvtsas");
        Resource resource = resourceSet.getResource(uri, true);
        assert (resource != null);
        QVTcLoadTests.assertNoResourceErrors((String)"Load", (Resource)resource);
        EcoreUtil.resolveAll((Resource)resource);
        QVTcLoadTests.assertNoUnresolvedProxies((String)"Resolve", (Resource)resource);
        QVTcLoadTests.assertNoValidationErrors((String)"Validate", (Resource)resource);
    }
}

