/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LetVariable;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.AbstractVariable2Variable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.Variables2Variables;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.RelationVariableAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcore.Area;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public class RelationVariable2Variable
extends AbstractVariable2Variable {
    private final @NonNull RelationVariableAnalysis variableAnalysis;
    private @Nullable VariableDeclaration cVariable;

    public RelationVariable2Variable(@NonNull Variables2Variables variablesAnalysis, @NonNull VariableDeclaration rVariable) {
        super(variablesAnalysis, QVTrelationUtil.getName((NamedElement)rVariable));
        this.variableAnalysis = new RelationVariableAnalysis(variablesAnalysis, rVariable);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void addNavigationAssignment(@NonNull Property targetProperty, @NonNull OCLExpression cExpression, @Nullable Boolean isPartial) throws CompilerChainException {
        boolean isKeyed;
        Key rKey = this.variableAnalysis.getrKey();
        boolean bl = isKeyed = this.variableAnalysis.getStrategy() == RelationVariableAnalysis.Strategy.KEYED;
        if (isKeyed && rKey != null) {
            if (rKey.getPart().contains((Object)targetProperty)) {
                return;
            }
            if (rKey.getOppositePart().contains((Object)targetProperty.getOpposite())) {
                return;
            }
        }
        VariableDeclaration cVariable2 = this.getCoreVariable();
        @NonNull List cMiddleBottomAssignments = QVTcoreUtil.Internal.getOwnedAssignmentsList((BottomPattern)this.variablesAnalysis.getMiddleBottomPattern());
        if (isPartial == null) {
            isPartial = targetProperty.isIsMany() && !(cExpression.getType() instanceof CollectionType);
        }
        VariableExp cSlotVariableExp = this.variablesAnalysis.createVariableExp(cVariable2);
        NavigationAssignment cAssignment = this.variablesAnalysis.createNavigationAssignment((OCLExpression)cSlotVariableExp, targetProperty, cExpression, isPartial);
        QVTr2QVTc.SYNTHESIS.println("  addPropertyAssignment " + cAssignment);
        this.variablesAnalysis.assertNewAssignment(cMiddleBottomAssignments, cAssignment);
        cMiddleBottomAssignments.add(cAssignment);
    }

    public @Nullable RealizedVariable basicGetCoreRealizedVariable() {
        return (RealizedVariable)this.cVariable;
    }

    public @Nullable VariableDeclaration basicGetCoreVariable() {
        return this.cVariable;
    }

    @Override
    public void check() {
        boolean isRealized;
        boolean bl = isRealized = this.variableAnalysis.getStrategy() == RelationVariableAnalysis.Strategy.REALIZED_BOTTOM;
        if (this.variablesAnalysis.isAbstract() && isRealized) {
            if (this.cVariable != null) {
                QVTruntimeUtil.errPrintln((String)("cVariable for abstract " + this));
            }
            return;
        }
        if (this.cVariable == null) {
            QVTruntimeUtil.errPrintln((String)("No cVariable for " + this));
            return;
        }
        CorePattern cPattern = this.getCorePattern();
        assert (this.cVariable != null && (this.cVariable.eContainer() == cPattern || this.cVariable instanceof IteratorVariable || this.cVariable instanceof LetVariable));
        assert (this.cVariable instanceof RealizedVariable == (isRealized && !(this.cVariable.getType() instanceof DataType)));
    }

    @Override
    public @NonNull CorePattern getCorePattern() {
        RelationVariableAnalysis.Strategy strategy = this.variableAnalysis.getStrategy();
        switch (strategy) {
            case ENFORCED_BOTTOM: {
                return QVTcoreUtil.getBottomPattern((Area)this.variablesAnalysis.cEnforcedDomain);
            }
            case ENFORCED_GUARD: {
                return QVTcoreUtil.getGuardPattern((Area)this.variablesAnalysis.cEnforcedDomain);
            }
            case KEYED: {
                return QVTcoreUtil.getBottomPattern((Area)this.variablesAnalysis.cEnforcedDomain);
            }
            case OTHER_BOTTOM: {
                return QVTcoreUtil.getBottomPattern((Area)this.variablesAnalysis.getCoreDomain(this.getOtherTypedModel()));
            }
            case OTHER_GUARD: {
                return QVTcoreUtil.getGuardPattern((Area)this.variablesAnalysis.getCoreDomain(this.getOtherTypedModel()));
            }
            case REALIZED_BOTTOM: {
                return QVTcoreUtil.getBottomPattern((Area)this.variablesAnalysis.cEnforcedDomain);
            }
            case SHARED_BOTTOM: {
                return this.variablesAnalysis.cMiddleBottomPattern;
            }
        }
        throw new IllegalStateException("A " + (Object)((Object)strategy) + " variable has no CoreDomain");
    }

    @Override
    public @NonNull VariableDeclaration getCoreVariable() {
        VariableDeclaration cVariable2 = this.cVariable;
        if (cVariable2 == null) {
            cVariable2 = this.synthesize();
        }
        return cVariable2;
    }

    private @NonNull TypedModel getOtherTypedModel() throws IllegalStateException {
        TypedModel rOtherBound = this.variableAnalysis.getrOtherBound();
        if (rOtherBound != null) {
            return rOtherBound;
        }
        TypedModel rOtherReferred = this.variableAnalysis.getrOtherReferred();
        if (rOtherReferred != null) {
            return rOtherReferred;
        }
        TypedModel rPredicate = this.variableAnalysis.getrPredicate();
        if (rPredicate != null) {
            return rPredicate;
        }
        TypedModel rWhenTypedModel = this.variableAnalysis.getrWhenTypedModel();
        if (rWhenTypedModel != null) {
            return rWhenTypedModel;
        }
        TypedModel rWhereTypedModel = this.variableAnalysis.getrWhereTypedModel();
        if (rWhereTypedModel != null) {
            return rWhereTypedModel;
        }
        throw new IllegalStateException("Failed to determine other pattern for " + this);
    }

    @Override
    public @Nullable VariableDeclaration getRelationVariable() {
        return this.variableAnalysis.getRelationVariable();
    }

    @Override
    public boolean hasWhenDomain() {
        return this.variableAnalysis.hasWhenDomain();
    }

    private void initializeKeyedVariable(@NonNull VariableDeclaration cKeyedVariable) {
        TypedModel rEnforcedTypedModel2 = (TypedModel)ClassUtil.nonNull((Object)this.variableAnalysis.getrEnforcedTypedModel());
        Key rKey2 = (Key)ClassUtil.nonNull((Object)this.variableAnalysis.getrKey());
        Function function = this.variablesAnalysis.getRelationAnalysis().getTransformationAnalysis().getKeyFunction(rEnforcedTypedModel2, rKey2);
        ArrayList<@NonNull VariableExp> asArguments = new ArrayList<VariableExp>();
        TemplateExp rTemplateExp = this.variableAnalysis.getrTemplateExp();
        if (rTemplateExp instanceof ObjectTemplateExp) {
            ObjectTemplateExp objectTemplateExp = (ObjectTemplateExp)rTemplateExp;
            for (Parameter keyParameter : ClassUtil.nullFree((List)function.getOwnedParameters())) {
                VariableDeclaration cVariable;
                VariableDeclaration rVariable;
                OCLExpression parameterExp = this.variablesAnalysis.getTemplateExp(objectTemplateExp, keyParameter);
                if (parameterExp instanceof TemplateExp) {
                    rVariable = (VariableDeclaration)ClassUtil.nonNullState((Object)((TemplateExp)parameterExp).getBindsTo());
                    cVariable = this.variablesAnalysis.getCoreVariable(rVariable);
                    asArguments.add(this.variablesAnalysis.createVariableExp(cVariable));
                    continue;
                }
                if (parameterExp instanceof VariableExp) {
                    rVariable = (VariableDeclaration)ClassUtil.nonNullState((Object)((VariableExp)parameterExp).getReferredVariable());
                    cVariable = this.variablesAnalysis.getCoreVariable(rVariable);
                    asArguments.add(this.variablesAnalysis.createVariableExp(cVariable));
                    continue;
                }
                throw new IllegalStateException(NLS.bind((String)"Missing ''{1}'' value for ''{0}'' key.", (Object)rKey2.getIdentifies().getName(), (Object)keyParameter.getName()));
            }
        }
        VariableDeclaration cThisVariable = this.variablesAnalysis.getCoreThisVariable();
        OperationCallExp asConstructor = this.variablesAnalysis.createOperationCallExp((OCLExpression)this.variablesAnalysis.createVariableExp(cThisVariable), (Operation)function, asArguments);
        @NonNull VariableAssignment cVariableAssignment = this.variablesAnalysis.createVariableAssignment(cKeyedVariable, (OCLExpression)asConstructor);
        this.variablesAnalysis.getMiddleBottomPattern().getAssignment().add((Object)cVariableAssignment);
    }

    @Override
    public boolean isRealized() {
        return this.variableAnalysis.isRealized();
    }

    @Override
    public void setIsEnforcedBound(@Nullable TemplateExp rTemplateExp, @NonNull TypedModel rEnforcedTypedModel, @Nullable Key rKey) {
        this.variableAnalysis.setIsEnforcedBound(rTemplateExp, rEnforcedTypedModel, rKey);
    }

    @Override
    public void setIsEnforcedReferred() {
        this.variableAnalysis.setIsEnforcedReferred();
    }

    @Override
    public void setIsRoot() {
        this.variableAnalysis.setIsRoot();
    }

    @Override
    public void setOtherBound(@NonNull TypedModel rOtherTypedModel) {
        this.variableAnalysis.setOtherBound(rOtherTypedModel);
    }

    @Override
    public void setOtherReferred(@NonNull TypedModel rOtherTypedModel) {
        this.variableAnalysis.setOtherReferred(rOtherTypedModel);
    }

    @Override
    public void setPredicate(@NonNull TypedModel rPredicateTypedModel) {
        this.variableAnalysis.setPredicate(rPredicateTypedModel);
    }

    @Override
    public void setWhen(@NonNull TypedModel rWhenTypedModel) {
        this.variableAnalysis.setWhen(rWhenTypedModel);
    }

    @Override
    public void setWhere(@NonNull TypedModel rWhereTypedModel) {
        this.variableAnalysis.setWhere(rWhereTypedModel);
    }

    protected @NonNull VariableDeclaration synthesize() {
        VariableDeclaration cVariable2 = this.cVariable;
        if (cVariable2 == null) {
            RelationVariableAnalysis.Strategy strategy = this.variableAnalysis.getStrategy();
            VariableDeclaration rVariable = this.variableAnalysis.getRelationVariable();
            Type type = QVTrelationUtil.getType((TypedElement)rVariable);
            switch (strategy) {
                case ENFORCED_BOTTOM: {
                    cVariable2 = this.variablesAnalysis.createBottomVariable(this.name, type, rVariable.isIsRequired(), null);
                    this.variablesAnalysis.cEnforcedDomain.getBottomPattern().getOwnedVariables().add((Object)cVariable2);
                    break;
                }
                case ENFORCED_GUARD: {
                    cVariable2 = this.variablesAnalysis.createGuardVariable(this.name, type, rVariable.isIsRequired(), null);
                    this.variablesAnalysis.cEnforcedDomain.getGuardPattern().getOwnedVariables().add((Object)cVariable2);
                    break;
                }
                case KEYED: {
                    cVariable2 = this.variablesAnalysis.createBottomVariable(this.name, type, true, null);
                    this.initializeKeyedVariable(cVariable2);
                    this.variablesAnalysis.cEnforcedDomain.getBottomPattern().getOwnedVariables().add((Object)cVariable2);
                    break;
                }
                case OTHER_BOTTOM: {
                    cVariable2 = this.variablesAnalysis.createBottomVariable(this.name, type, rVariable.isIsRequired(), null);
                    this.variablesAnalysis.getCoreDomain(this.getOtherTypedModel()).getBottomPattern().getOwnedVariables().add((Object)cVariable2);
                    break;
                }
                case OTHER_GUARD: {
                    cVariable2 = this.variablesAnalysis.createGuardVariable(this.name, type, rVariable.isIsRequired(), null);
                    this.variablesAnalysis.getCoreDomain(this.getOtherTypedModel()).getGuardPattern().getOwnedVariables().add((Object)cVariable2);
                    break;
                }
                case REALIZED_BOTTOM: {
                    if (this.variablesAnalysis.isAbstract()) {
                        throw new IllegalStateException();
                    }
                    if (type instanceof CollectionType) {
                        cVariable2 = this.variablesAnalysis.createBottomVariable(this.name, type, rVariable.isIsRequired(), null);
                        this.variablesAnalysis.cEnforcedDomain.getBottomPattern().getOwnedVariables().add((Object)cVariable2);
                        break;
                    }
                    RealizedVariable cRealizedVariable = this.variablesAnalysis.createRealizedVariable(this.name, type);
                    this.variablesAnalysis.cEnforcedDomain.getBottomPattern().getRealizedVariable().add((Object)cRealizedVariable);
                    cVariable2 = cRealizedVariable;
                    break;
                }
                case SHARED_BOTTOM: {
                    cVariable2 = this.variablesAnalysis.createBottomVariable(this.name, type, rVariable.isIsRequired(), null);
                    this.variablesAnalysis.cMiddleBottomPattern.getOwnedVariables().add((Object)cVariable2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Failed to identify strategy for variable " + this);
                }
            }
            this.cVariable = cVariable2;
            this.variablesAnalysis.addVariableAnalysis(this);
        }
        return cVariable2;
    }
}

