/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.ActualPartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.IteratedEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractPartialRegionAnalysis<@NonNull PRA extends PartialRegionsAnalysis<@NonNull PRA>>
implements PartialRegionAnalysis<PRA> {
    protected final @NonNull PartialRegionsAnalysis<@NonNull PRA> partialRegionsAnalysis;
    protected final @NonNull ScheduleManager scheduleManager;
    private @Nullable List<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> externallyConsumedClassAnalyses = null;
    private @Nullable List<@NonNull PartialRegionPropertyAnalysis<@NonNull PRA>> consumedPropertyAnalyses = null;
    private @Nullable List<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> externallyProducedClassAnalyses = null;
    private @Nullable List<@NonNull PartialRegionPropertyAnalysis<@NonNull PRA>> producedPropertyAnalyses = null;
    private @Nullable Set<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> superProducedClassAnalyses = null;
    private @Nullable Node dispatchNode = null;
    private @Nullable Node thisNode = null;
    private final @NonNull List<@NonNull Node> traceNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> constantInputNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> constantOutputNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> loadedInputNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull NavigableEdge> predicatedMiddleEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> predicatedMiddleNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull NavigableEdge> predicatedOutputEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> predicatedOutputNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull NavigableEdge> realizedMiddleEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> newMiddleNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull NavigableEdge> realizedOutputEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> newOutputNodes = new ArrayList<Node>();
    private final @NonNull Set<@NonNull NavigableEdge> oldPrimaryNavigableEdges = new HashSet<NavigableEdge>();
    private final @NonNull List<@NonNull Edge> predicatedEdges = new ArrayList<Edge>();
    private final @NonNull Set<@NonNull NavigableEdge> realizedEdges = new HashSet<NavigableEdge>();
    private final @NonNull Set<@NonNull SuccessEdge> successEdges = new HashSet<SuccessEdge>();

    protected AbstractPartialRegionAnalysis(@NonNull PartialRegionsAnalysis<@NonNull PRA> partialRegionsAnalysis) {
        this.partialRegionsAnalysis = partialRegionsAnalysis;
        this.scheduleManager = partialRegionsAnalysis.getScheduleManager();
    }

    private void addConstantNode(@NonNull Node node) {
        assert (this.isConstant(node));
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            assert (!edge.isCast());
            if (!edge.isComputation() && (!edge.isNavigation() || this.isRealized(edge))) continue;
            this.constantOutputNodes.add(node);
            return;
        }
        this.constantInputNodes.add(node);
    }

    private void addConsumptionOfEdge(@NonNull NavigableEdge edge) {
        if (edge.isNavigation()) {
            NavigationEdge navigationEdge = (NavigationEdge)edge;
            for (PropertyDatum propertyDatum : this.scheduleManager.getPropertyDatums(navigationEdge)) {
                this.addConsumptionOfPropertyDatum(propertyDatum);
            }
        }
    }

    private void addConsumptionOfInputNode(@NonNull Node node) {
        if (node.isClass() && !this.loadedInputNodes.contains(node)) {
            this.loadedInputNodes.add(node);
            if (!node.isDataType()) {
                this.addConsumptionOfNode(node);
            }
        }
    }

    private void addConsumptionOfMiddleEdge(@NonNull NavigableEdge edge) {
        if (!this.predicatedMiddleEdges.contains(edge)) {
            this.predicatedMiddleEdges.add(edge);
            this.addConsumptionOfEdge(edge);
        }
    }

    private void addConsumptionOfMiddleNode(@NonNull Node node) {
        if (!this.predicatedMiddleNodes.contains(node)) {
            this.predicatedMiddleNodes.add(node);
            if (!node.isDataType()) {
                this.addConsumptionOfNode(node);
            }
        }
    }

    private void addConsumptionOfNode(@NonNull Node node) {
        if ("mapBooleanExp_qvtr".equals(this.getName()) || "mapStringExp_qvtr".equals(this.getName())) {
            CompilerUtil.class.getName();
        }
        assert (!node.isDataType());
        PartialRegionClassAnalysis<@NonNull PRA> consumedTraceAnalysis = this.partialRegionsAnalysis.addConsumer(QVTscheduleUtil.getClassDatum((Node)node), this);
        List<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> externallyConsumedClassAnalyses2 = this.externallyConsumedClassAnalyses;
        if (externallyConsumedClassAnalyses2 == null) {
            externallyConsumedClassAnalyses2 = new ArrayList<PartialRegionClassAnalysis<PRA>>();
            this.externallyConsumedClassAnalyses = externallyConsumedClassAnalyses2;
        }
        if (!externallyConsumedClassAnalyses2.contains(consumedTraceAnalysis)) {
            externallyConsumedClassAnalyses2.add(consumedTraceAnalysis);
        }
    }

    private void addConsumptionOfOutputEdge(@NonNull NavigableEdge edge) {
        if (!this.predicatedOutputEdges.contains(edge)) {
            this.predicatedOutputEdges.add(edge);
            this.addConsumptionOfEdge(edge);
        }
    }

    private void addConsumptionOfOutputNode(@NonNull Node node) {
        if (!this.predicatedOutputNodes.contains(node)) {
            this.predicatedOutputNodes.add(node);
            if (!node.isDataType()) {
                this.addConsumptionOfNode(node);
            }
        }
    }

    private void addConsumptionOfPropertyDatum(@NonNull PropertyDatum propertyDatum) {
        ActualPartialRegionPropertyAnalysis<@NonNull PRA> consumedTraceAnalysis = this.partialRegionsAnalysis.addConsumer(propertyDatum, this);
        List<@NonNull PartialRegionPropertyAnalysis<@NonNull PRA>> consumedPropertyAnalyses2 = this.consumedPropertyAnalyses;
        if (consumedPropertyAnalyses2 == null) {
            consumedPropertyAnalyses2 = new ArrayList<PartialRegionPropertyAnalysis<PRA>>();
            this.consumedPropertyAnalyses = consumedPropertyAnalyses2;
        }
        if (!consumedPropertyAnalyses2.contains(consumedTraceAnalysis)) {
            consumedPropertyAnalyses2.add(consumedTraceAnalysis);
        }
    }

    private void addProductionOfEdge(@NonNull NavigableEdge edge) {
        assert (this.isNew((Edge)edge));
        if (edge.isNavigation()) {
            NavigationEdge navigationEdge = (NavigationEdge)edge;
            Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge);
            assert (property != this.scheduleManager.getStandardLibraryHelper().getOclContainerProperty());
            if (property.toString().contains("height") || property.toString().contains("ownsB")) {
                property.toString();
            }
            PropertyDatum propertyDatum = this.scheduleManager.getPropertyDatum(navigationEdge);
            ActualPartialRegionPropertyAnalysis<@NonNull PRA> producedTraceAnalysis = this.partialRegionsAnalysis.addProducer(propertyDatum, this);
            List<@NonNull PartialRegionPropertyAnalysis<@NonNull PRA>> producedPropertyAnalyses2 = this.producedPropertyAnalyses;
            if (producedPropertyAnalyses2 == null) {
                producedPropertyAnalyses2 = new ArrayList<PartialRegionPropertyAnalysis<PRA>>();
                this.producedPropertyAnalyses = producedPropertyAnalyses2;
            }
            if (!producedPropertyAnalyses2.contains(producedTraceAnalysis)) {
                producedPropertyAnalyses2.add(producedTraceAnalysis);
            }
        }
    }

    private void addProductionOfMiddleEdge(@NonNull NavigableEdge edge) {
        if (this.isRealized((Edge)edge) && !this.realizedMiddleEdges.contains(edge)) {
            this.realizedMiddleEdges.add(edge);
            this.addProductionOfEdge(edge);
        }
    }

    private void addProductionOfMiddleNode(@NonNull Node node) {
        if (this.isNew(node) && !this.newMiddleNodes.contains(node)) {
            this.newMiddleNodes.add(node);
            if (!node.isDataType()) {
                this.addProductionOfNode(node);
            }
        }
    }

    private void addProductionOfNode(@NonNull Node node) {
        assert (this.isNew(node));
        assert (!node.isDataType());
        PartialRegionClassAnalysis<@NonNull PRA> consumedTraceAnalysis = this.partialRegionsAnalysis.addProducer(QVTscheduleUtil.getClassDatum((Node)node), this);
        List<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> externallyProducedClassAnalyses2 = this.externallyProducedClassAnalyses;
        if (externallyProducedClassAnalyses2 == null) {
            externallyProducedClassAnalyses2 = new ArrayList<PartialRegionClassAnalysis<PRA>>();
            this.externallyProducedClassAnalyses = externallyProducedClassAnalyses2;
        }
        if (!externallyProducedClassAnalyses2.contains(consumedTraceAnalysis)) {
            externallyProducedClassAnalyses2.add(consumedTraceAnalysis);
        }
    }

    private void addProductionOfOutputEdge(@NonNull NavigableEdge edge) {
        if (this.isRealized((Edge)edge) && !this.realizedOutputEdges.contains(edge)) {
            this.realizedOutputEdges.add(edge);
            this.addProductionOfEdge(edge);
        }
    }

    private void addProductionOfOutputNode(@NonNull Node node) {
        if (this.isNew(node) && !this.newOutputNodes.contains(node)) {
            this.newOutputNodes.add(node);
            if (!node.isDataType()) {
                this.addProductionOfNode(node);
            }
        }
    }

    protected void analyzeEdges() {
        for (Edge edge : this.getPartialEdges()) {
            assert (!edge.isCast());
            if (edge.isSecondary()) continue;
            if (this.isPredicated(edge)) {
                this.predicatedEdges.add(edge);
            }
            if (edge.isNavigation()) {
                Node sourceNode;
                NavigationEdge navigationEdge = (NavigationEdge)edge;
                if (navigationEdge.isSuccess()) {
                    this.successEdges.add((SuccessEdge)navigationEdge);
                }
                if (this.isRealized((Edge)navigationEdge)) {
                    this.realizedEdges.add((NavigableEdge)navigationEdge);
                } else {
                    this.oldPrimaryNavigableEdges.add((NavigableEdge)navigationEdge);
                }
                if (!this.isRealized((Edge)navigationEdge) && !navigationEdge.isConditional()) {
                    assert (!navigationEdge.isExpression());
                    assert (!navigationEdge.isComputation());
                }
                if (this.scheduleManager.isMiddle(sourceNode = navigationEdge.getEdgeSource())) {
                    if (this.isChecked((Edge)navigationEdge)) {
                        this.addConsumptionOfMiddleEdge((NavigableEdge)navigationEdge);
                        continue;
                    }
                    if (this.isRealized((Edge)navigationEdge)) {
                        this.addProductionOfMiddleEdge((NavigableEdge)navigationEdge);
                        continue;
                    }
                    if (this.isLoaded((Edge)navigationEdge)) continue;
                    throw new IllegalStateException("middle edge must be predicated or realized : " + navigationEdge);
                }
                if (this.isLoaded((Edge)navigationEdge) || this.isConstant((Edge)navigationEdge)) continue;
                if (this.isChecked((Edge)navigationEdge)) {
                    this.addConsumptionOfOutputEdge((NavigableEdge)navigationEdge);
                    continue;
                }
                if (this.isRealized((Edge)navigationEdge)) {
                    this.addProductionOfOutputEdge((NavigableEdge)navigationEdge);
                    continue;
                }
                throw new IllegalStateException("other edge must be predicated or realized : " + navigationEdge);
            }
            if (edge.isExpression() || edge instanceof IteratedEdge || edge.isDependency()) continue;
            throw new IllegalStateException("unsupported analyzeEdge : " + edge);
        }
    }

    protected void analyzeNodes() {
        for (Node node : this.getPartialNodes()) {
            boolean isMiddle;
            if (node.isDependency()) {
                this.addConsumptionOfOutputNode(node);
                continue;
            }
            boolean isOperation = node.isOperation();
            boolean isPattern = node.isPattern();
            boolean isIterator = node.isIterator();
            if (!(isOperation || isPattern || isIterator)) {
                throw new IllegalStateException("unsupported analyzeNode : " + node);
            }
            if (node.isThis()) {
                assert (node.isLoaded());
                assert (this.thisNode == null);
                this.thisNode = node;
            }
            if ((isMiddle = this.scheduleManager.isMiddle(node)) && !isOperation) {
                if (node.isDispatch()) {
                    if (this.dispatchNode != null) {
                        throw new IllegalStateException();
                    }
                    this.dispatchNode = node;
                } else if (node.isTrace()) {
                    this.traceNodes.add(node);
                }
            }
            if (this.isConstant(node)) {
                if (!isOperation) continue;
                this.addConstantNode(node);
                continue;
            }
            if (this.isLoaded(node)) {
                this.addConsumptionOfInputNode(node);
                continue;
            }
            if (this.isPredicated(node)) {
                if (node.isDataType()) continue;
                if (isMiddle) {
                    this.addConsumptionOfMiddleNode(node);
                    continue;
                }
                this.addConsumptionOfOutputNode(node);
                continue;
            }
            if (this.isSpeculated(node) && isMiddle && !isOperation) {
                if (node.isHead()) continue;
                this.addConsumptionOfMiddleNode(node);
                continue;
            }
            if (this.isNew(node)) {
                if (isOperation) continue;
                if (isMiddle) {
                    this.addProductionOfMiddleNode(node);
                    continue;
                }
                this.addProductionOfOutputNode(node);
                continue;
            }
            throw new IllegalStateException(String.valueOf(isMiddle ? "middle" : "other") + " node must be predicated or realized : " + node);
        }
    }

    public @Nullable Node basicGetDispatchNode() {
        return this.dispatchNode;
    }

    public @NonNull Iterable<@NonNull Node> getConstantInputNodes() {
        return this.constantInputNodes;
    }

    public @NonNull Iterable<@NonNull Node> getConstantOutputNodes() {
        return this.constantOutputNodes;
    }

    @Override
    public @Nullable Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> getConsumedClassAnalyses() {
        return this.externallyConsumedClassAnalyses;
    }

    @Override
    public @Nullable Iterable<@NonNull PartialRegionPropertyAnalysis<@NonNull PRA>> getConsumedPropertyAnalyses() {
        return this.consumedPropertyAnalyses;
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getOldPrimaryNavigableEdges() {
        return this.oldPrimaryNavigableEdges;
    }

    protected @NonNull Iterable<@NonNull Edge> getPartialEdges() {
        throw new UnsupportedOperationException();
    }

    protected @NonNull Iterable<@NonNull Node> getPartialNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Partition getPartition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> getProducedClassAnalyses() {
        return this.externallyProducedClassAnalyses;
    }

    @Override
    public @Nullable Iterable<@NonNull PartialRegionPropertyAnalysis<@NonNull PRA>> getProducedPropertyAnalyses() {
        return this.producedPropertyAnalyses;
    }

    public @NonNull Iterable<@NonNull Edge> getPredicatedEdges() {
        return this.predicatedEdges;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedMiddleNodes() {
        return this.predicatedMiddleNodes;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedOutputNodes() {
        return this.predicatedOutputNodes;
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getRealizedEdges() {
        return this.realizedEdges;
    }

    public @NonNull Iterable<@NonNull Node> getRealizedMiddleNodes() {
        return this.newMiddleNodes;
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getRealizedOutputEdges() {
        return this.realizedOutputEdges;
    }

    public @NonNull Iterable<@NonNull Node> getRealizedOutputNodes() {
        return this.newOutputNodes;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull Iterable<@NonNull SuccessEdge> getSuccessEdges() {
        return this.successEdges;
    }

    @Override
    public @Nullable Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> getSuperProducedClassAnalyses() {
        List<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> producedClassAnalyses2 = this.externallyProducedClassAnalyses;
        if (producedClassAnalyses2 != null) {
            Set<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> superProducedClassAnalyses2 = this.superProducedClassAnalyses;
            if (superProducedClassAnalyses2 == null) {
                this.superProducedClassAnalyses = superProducedClassAnalyses2 = new HashSet<PartialRegionClassAnalysis<PRA>>();
            }
            for (PartialRegionClassAnalysis<PRA> producedClassAnalysis : producedClassAnalyses2) {
                Iterables.addAll(superProducedClassAnalyses2, producedClassAnalysis.getSuperClassAnalyses());
            }
        }
        return this.superProducedClassAnalyses;
    }

    public @Nullable Node getThisNode() {
        return this.thisNode;
    }

    public @NonNull List<@NonNull Node> getTraceNodes() {
        return this.traceNodes;
    }

    protected boolean isChecked(@NonNull Edge edge) {
        return this.isPredicated(edge) || this.isSpeculated(edge);
    }

    protected boolean isConstant(@NonNull Edge edge) {
        return edge.isConstant();
    }

    protected boolean isConstant(@NonNull Node node) {
        return node.isConstant();
    }

    protected boolean isLoaded(@NonNull Edge edge) {
        return edge.isLoaded();
    }

    protected boolean isLoaded(@NonNull Node node) {
        return node.isLoaded();
    }

    protected boolean isNew(@NonNull Edge edge) {
        return edge.isNew();
    }

    protected boolean isNew(@NonNull Node node) {
        return node.isNew();
    }

    protected boolean isPredicated(@NonNull Edge edge) {
        return edge.isPredicated();
    }

    protected boolean isPredicated(@NonNull Node node) {
        return node.isPredicated();
    }

    protected boolean isRealized(@NonNull Edge edge) {
        return edge.isRealized();
    }

    protected boolean isRealized(@NonNull Node node) {
        return node.isRealized();
    }

    protected boolean isSpeculated(@NonNull Edge edge) {
        return edge.isSpeculated();
    }

    protected boolean isSpeculated(@NonNull Node node) {
        return node.isSpeculated();
    }

    protected boolean isSpeculation(@NonNull Node node) {
        return node.isSpeculation();
    }
}

