/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Collection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.JdkVersion;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class ExtractionUtils {
    public static Integer toInteger(Object i) {
        if (i != null && i instanceof Number) {
            return ((Number)i).intValue();
        }
        return null;
    }

    public static int getNumberOfNotNullArrayElements(IObjectArray arrayObject) {
        block4: {
            ISnapshot snapshot = arrayObject.getSnapshot();
            try {
                int[] outs = snapshot.getOutboundReferentIds(arrayObject.getObjectId());
                if (outs.length == 1 || outs.length == arrayObject.getLength() + 1) {
                    return outs.length - 1;
                }
            }
            catch (SnapshotException outs) {
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof SnapshotException) break block4;
                throw e;
            }
        }
        return ExtractionUtils.getNumberOfNotNullArrayElements(arrayObject.getReferenceArray());
    }

    public static int getNumberOfNotNullArrayElements(long[] addresses) {
        int result = 0;
        int i = 0;
        while (i < addresses.length) {
            if (addresses[i] != 0L) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static int getNumberOfNotNullArrayElements(int[] ids) {
        int result = 0;
        int i = 0;
        while (i < ids.length) {
            if (ids[i] != 0) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static int[] referenceArrayToIds(ISnapshot snapshot, long[] referenceArray) throws SnapshotException {
        ArrayInt arr = new ArrayInt();
        int i = 0;
        while (i < referenceArray.length) {
            if (referenceArray[i] != 0L) {
                arr.add(snapshot.mapAddressToId(referenceArray[i]));
            }
            ++i;
        }
        return arr.toArray();
    }

    public static IInstance followOnlyNonArrayOutgoingReference(IObject obj) throws SnapshotException {
        ISnapshot snapshot = obj.getSnapshot();
        IInstance ret = null;
        int[] nArray = snapshot.getOutboundReferentIds(obj.getObjectId());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IObject o;
            int i = nArray[n2];
            if (!snapshot.isArray(i) && !snapshot.isClass(i) && (o = snapshot.getObject(i)) instanceof IInstance) {
                if (ret != null) {
                    ret = null;
                    break;
                }
                ret = (IInstance)o;
            }
            ++n2;
        }
        return ret;
    }

    public static IObject followOnlyOutgoingReferencesExceptLast(String field, IObject obj) throws SnapshotException {
        Object ret;
        int j = field.lastIndexOf(46);
        if (j >= 0 && (ret = obj.resolveValue(field.substring(0, j))) instanceof IObject) {
            return (IObject)ret;
        }
        IObject next = obj;
        int i = field.indexOf(46);
        while (i >= 0 && next != null) {
            next = ExtractionUtils.followOnlyNonArrayOutgoingReference(next);
            i = field.indexOf(46, i + 1);
        }
        return next;
    }

    public static IObjectArray getOnlyArrayField(IObject obj) throws SnapshotException {
        IObjectArray ret = null;
        ISnapshot snapshot = obj.getSnapshot();
        int[] nArray = snapshot.getOutboundReferentIds(obj.getObjectId());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IObject o;
            int i = nArray[n2];
            if (snapshot.isArray(i) && (o = snapshot.getObject(i)) instanceof IObjectArray) {
                if (ret != null) {
                    return null;
                }
                ret = (IObjectArray)o;
            }
            ++n2;
        }
        return ret;
    }

    public static JdkVersion resolveVersion(ISnapshot snapshot) throws SnapshotException {
        String sver;
        Collection<IClass> classes;
        String jreVersion;
        int jreIndex;
        String jvmInfo = snapshot.getSnapshotInfo().getJvmInfo();
        if (jvmInfo != null && (jvmInfo.contains("IBM") || jvmInfo.contains("build ")) && (jreIndex = jvmInfo.indexOf("JRE ")) != -1 && (jreVersion = jvmInfo.substring(jreIndex + 4)).length() >= 3) {
            if ((jreVersion = jreVersion.split(" ", 2)[0]).equals("9") || jreVersion.startsWith("9.")) {
                return JdkVersion.IBM19;
            }
            if (jreVersion.equals("10") || jreVersion.startsWith("10.")) {
                return JdkVersion.IBM19;
            }
            if (jreVersion.equals("11") || jreVersion.startsWith("11.")) {
                return JdkVersion.JAVA_11;
            }
            if (jreVersion.startsWith("1.8")) {
                return JdkVersion.IBM18;
            }
            if (jreVersion.startsWith("1.7")) {
                if (jvmInfo.matches(".*70sr.*\\(SR[1-3][^0-9].*") || jvmInfo.matches(".*\\(GA") && !jvmInfo.matches(".*70_27.*")) {
                    return JdkVersion.IBM16;
                }
                return JdkVersion.IBM17;
            }
            if (jreVersion.startsWith("1.6")) {
                return JdkVersion.IBM16;
            }
            if (jreVersion.startsWith("1.5")) {
                return JdkVersion.IBM15;
            }
            if (jreVersion.startsWith("1.4")) {
                return JdkVersion.IBM14;
            }
            if (jreVersion.matches("\\d+") || Integer.parseInt(jreVersion, 10) > 14) {
                return JdkVersion.JAVA_11;
            }
        }
        if ((classes = snapshot.getClassesByName("com.ibm.misc.JavaRuntimeVersion", false)) != null && !classes.isEmpty()) {
            return JdkVersion.IBM15;
        }
        classes = snapshot.getClassesByName("com.ibm.oti.vm.BootstrapClassLoader", false);
        if (classes != null && !classes.isEmpty()) {
            classes = snapshot.getClassesByName("com.ibm.oti.util.Msg", false);
            if (classes != null && !classes.isEmpty()) {
                return JdkVersion.IBM19;
            }
            classes = snapshot.getClassesByName("com/ibm/oti/util/WeakReferenceNode", false);
            if (classes != null && !classes.isEmpty()) {
                return JdkVersion.IBM18;
            }
            classes = snapshot.getClassesByName("com.ibm.oti.vm.VMLangAccess", false);
            if (classes != null && !classes.isEmpty()) {
                return JdkVersion.IBM17;
            }
            return JdkVersion.IBM16;
        }
        classes = snapshot.getClassesByName("com.ibm.jvm.Trace", false);
        if (classes != null && !classes.isEmpty()) {
            return JdkVersion.IBM14;
        }
        classes = snapshot.getClassesByName("sun.misc.Version", false);
        if (classes != null && classes.size() > 0) {
            try {
                Object ver = classes.iterator().next().resolveValue("java_version");
                if (ver instanceof IObject && (sver = ((IObject)ver).getClassSpecificName()) != null) {
                    if (sver.startsWith("1.8.")) {
                        return JdkVersion.JAVA18;
                    }
                    if (sver.startsWith("9.")) {
                        return JdkVersion.JAVA18;
                    }
                }
            }
            catch (SnapshotException ver) {
                // empty catch block
            }
        }
        if ((classes = snapshot.getClassesByName("java.lang.VersionProps", false)) != null && classes.size() > 0) {
            try {
                Object ver = classes.iterator().next().resolveValue("java_version");
                if (ver instanceof IObject && (sver = ((IObject)ver).getClassSpecificName()) != null) {
                    if (sver.startsWith("9.")) {
                        return JdkVersion.JAVA19;
                    }
                    if (sver.startsWith("9-")) {
                        return JdkVersion.JAVA19;
                    }
                    if (sver.startsWith("10.")) {
                        return JdkVersion.JAVA19;
                    }
                    if (sver.startsWith("10-")) {
                        return JdkVersion.JAVA19;
                    }
                    if (sver.startsWith("11.")) {
                        return JdkVersion.JAVA_11;
                    }
                    if (sver.startsWith("11-")) {
                        return JdkVersion.JAVA_11;
                    }
                    if (sver.startsWith("12.")) {
                        return JdkVersion.JAVA_11;
                    }
                    if (sver.startsWith("12-")) {
                        return JdkVersion.JAVA_11;
                    }
                    if (sver.startsWith("13.")) {
                        return JdkVersion.JAVA_11;
                    }
                    if (sver.startsWith("13-")) {
                        return JdkVersion.JAVA_11;
                    }
                }
                return JdkVersion.JAVA_11;
            }
            catch (SnapshotException snapshotException) {
                // empty catch block
            }
        }
        if ((classes = snapshot.getClassesByName("java.lang.Module", false)) != null && !classes.isEmpty()) {
            return JdkVersion.JAVA19;
        }
        classes = snapshot.getClassesByName("java.util.Spliterators", false);
        if (classes != null && !classes.isEmpty()) {
            return JdkVersion.JAVA18;
        }
        return JdkVersion.SUN;
    }
}

