/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.properties.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.ui.views.properties.IPropertySource;

public class SetModelPropertyValueCommand
extends AbstractTransactionalCommand {
    private boolean valueResetOnUndo = false;
    private final IPropertySource propertySource;
    private final Object propertyId;
    private Object undoValue;
    private final Object propertyValue;

    public SetModelPropertyValueCommand(TransactionalEditingDomain editingDomain, String label, Object affectedObjects, IPropertySource propertySource, Object propertyId, Object propertyValue) {
        super(editingDomain, label, affectedObjects instanceof EObject ? SetModelPropertyValueCommand.getWorkspaceFiles((EObject)((EObject)affectedObjects)) : null);
        this.propertySource = propertySource;
        this.propertyId = propertyId;
        this.propertyValue = propertyValue;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.setValueResetOnUndo(!this.getPropertySource().isPropertySet(this.getPropertyId()));
        if (!this.isValueResetOnUndo()) {
            this.setUndoValue(this.getPropertySource().getPropertyValue(this.getPropertyId()));
        } else {
            this.undoValue = null;
        }
        this.getPropertySource().setPropertyValue(this.getPropertyId(), this.getPropertyValue());
        return CommandResult.newOKCommandResult((Object)this.getPropertyValue());
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult((IProgressMonitor)new NullProgressMonitor(), info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.isValueResetOnUndo()) {
            this.getPropertySource().resetPropertyValue(this.getPropertyId());
        } else {
            this.getPropertySource().setPropertyValue(this.getPropertyId(), this.getUndoValue());
        }
        return CommandResult.newOKCommandResult((Object)this.getPropertySource().getPropertyValue(this.getPropertyId()));
    }

    protected boolean isValueResetOnUndo() {
        return this.valueResetOnUndo;
    }

    protected void setValueResetOnUndo(boolean b) {
        this.valueResetOnUndo = b;
    }

    protected IPropertySource getPropertySource() {
        return this.propertySource;
    }

    protected Object getPropertyId() {
        return this.propertyId;
    }

    protected Object getUndoValue() {
        return this.undoValue;
    }

    protected void setUndoValue(Object object) {
        this.undoValue = object;
    }

    protected Object getPropertyValue() {
        return this.propertyValue;
    }
}

