/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.interpreter;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;

public final class VariableType {
    public static final VariableType ANY_EOBJECT = VariableType.fromString(TypeName.EOBJECT_TYPENAME.getCompleteName());
    private List<TypeName> types = Lists.newArrayListWithExpectedSize((int)2);

    private VariableType() {
    }

    public static VariableType fromString(String typeName) {
        VariableType result = new VariableType();
        result.types.add(TypeName.fromString(typeName));
        return result;
    }

    public static VariableType fromStrings(Collection<String> typeNames) {
        VariableType result = new VariableType();
        for (String domainClass : typeNames) {
            result.types.add(TypeName.fromString(domainClass));
        }
        return result;
    }

    public static VariableType fromEClassifiers(Collection<EClassifier> types) {
        VariableType result = new VariableType();
        for (EClassifier domainClass : types) {
            result.types.add(TypeName.fromEClassifier(domainClass));
        }
        return result;
    }

    public static VariableType fromEClassifiersAndClasses(Collection<EClassifier> types, Collection<Class<?>> classes) {
        VariableType result = new VariableType();
        for (EClassifier eClassifier : types) {
            result.types.add(TypeName.fromEClassifier(eClassifier));
        }
        for (Class clazz : classes) {
            result.types.add(TypeName.fromJavaClass(clazz));
        }
        return result;
    }

    public static VariableType fromJavaClass(Class<?> type) {
        VariableType result = new VariableType();
        result.types.add(TypeName.fromJavaClass(type));
        return result;
    }

    public TypeName getCommonType(Collection<EPackage> availableEPackages) {
        TypeName result = TypeName.ANY_TYPENAME;
        if (this.types.size() == 1) {
            result = this.types.get(0);
        }
        if (this.types.size() > 1) {
            Iterator<TypeName> typeNameIt = this.types.iterator();
            Set<Object> commonSuperTypes = Sets.newLinkedHashSet();
            if (typeNameIt.hasNext()) {
                TypeName first = typeNameIt.next();
                commonSuperTypes = this.getAllSuperTypes(first, availableEPackages);
            }
            while (typeNameIt.hasNext() && commonSuperTypes.size() > 0) {
                TypeName type = typeNameIt.next();
                Set<EClass> nextTypeSuperTypes = this.getAllSuperTypes(type, availableEPackages);
                commonSuperTypes = Sets.intersection((Set)commonSuperTypes, nextTypeSuperTypes);
            }
            if (commonSuperTypes.size() > 0) {
                EClass firstCommonSuperType = (EClass)commonSuperTypes.iterator().next();
                result = TypeName.fromEClassifier((EClassifier)firstCommonSuperType);
            } else {
                result = TypeName.EOBJECT_TYPENAME;
            }
        }
        return result;
    }

    private Set<EClass> getAllSuperTypes(TypeName type, Collection<EPackage> collection) {
        LinkedHashSet allSuperTypes = Sets.newLinkedHashSet();
        UnmodifiableIterator it = Iterators.filter(type.search(collection).iterator(), EClass.class);
        while (it.hasNext()) {
            EClass curEClass = (EClass)it.next();
            allSuperTypes.add(curEClass);
            allSuperTypes.addAll(curEClass.getEAllSuperTypes());
        }
        return allSuperTypes;
    }

    public boolean hasDefinition() {
        return this.types.size() > 0;
    }

    public Collection<TypeName> getPossibleTypes() {
        return this.types;
    }

    public String toString() {
        return "[" + Joiner.on((char)',').join(this.types) + "]";
    }
}

