/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.text;

import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TextUtilitiesEx
extends TextUtilities {
    private IMapMode mapmode;
    private static GC gc;

    public TextUtilitiesEx(IMapMode mapmode) {
        this.mapmode = mapmode;
    }

    public int getAscent(Font font) {
        return this.mapmode.DPtoLP(super.getAscent(font));
    }

    public int getDescent(Font font) {
        return this.mapmode.DPtoLP(super.getDescent(font));
    }

    public Dimension getStringExtents(String s, Font f) {
        Dimension extents = new Dimension(TextUtilitiesEx.getStringDimension(s, f, true));
        TextUtilitiesEx.applyItalicBugHack(s, f, extents);
        this.applyMapModeConversion(extents);
        return extents;
    }

    public Dimension getTextExtents(String s, Font f) {
        Dimension extents = new Dimension(TextUtilitiesEx.getTextDimension(s, f, true));
        TextUtilitiesEx.applyItalicBugHack(s, f, extents);
        this.applyMapModeConversion(extents);
        return extents;
    }

    private static Point getTextDimension(String s, Font f, boolean advancedGraphics) {
        return TextUtilitiesEx.getGC(f, advancedGraphics).textExtent(s);
    }

    private static Point getStringDimension(String s, Font f, boolean advancedGraphics) {
        return TextUtilitiesEx.getGC(f, advancedGraphics).stringExtent(s);
    }

    private void applyMapModeConversion(Dimension extents) {
        extents.width = this.mapmode.DPtoLP(extents.width);
        extents.height = this.mapmode.DPtoLP(extents.height);
    }

    private static void applyItalicBugHack(String s, Font f, Dimension extents) {
        if ((f.getFontData()[0].getStyle() & 2) != 0 && s.length() > 0) {
            extents.width += extents.width / s.length() / 2;
        }
    }

    private static GC getGC(Font f, boolean advancedGraphics) {
        if (gc == null) {
            gc = new GC((Drawable)new Shell());
        }
        gc.setFont(f);
        gc.setAdvanced(advancedGraphics);
        return gc;
    }
}

