/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.memory.provisional.MemoryViewPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.provisional.AsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentDescriptor;
import org.eclipse.debug.ui.memory.IMemoryRendering;

public class MemoryBlockContentAdapter
extends AsynchronousContentAdapter {
    @Override
    protected Object[] getChildren(Object parent, IPresentationContext context) throws CoreException {
        if (!(parent instanceof IMemoryBlock)) {
            return new Object[0];
        }
        if (!(context instanceof MemoryViewPresentationContext)) {
            return new Object[0];
        }
        MemoryViewPresentationContext memoryViewContext = (MemoryViewPresentationContext)context;
        IMemoryRendering rendering = memoryViewContext.getRendering();
        if (!(rendering instanceof AbstractAsyncTableRendering)) {
            return new Object[0];
        }
        return this.getMemoryFromMemoryBlock(memoryViewContext);
    }

    @Override
    protected boolean hasChildren(Object element, IPresentationContext context) throws CoreException {
        return context instanceof MemoryViewPresentationContext && ((MemoryViewPresentationContext)context).getRendering() != null;
    }

    @Override
    protected boolean supportsPartId(String id) {
        return true;
    }

    private Object[] getMemoryFromMemoryBlock(MemoryViewPresentationContext context) throws DebugException {
        IMemoryBlock memoryBlock = context.getRendering().getMemoryBlock();
        if (memoryBlock instanceof IMemoryBlockExtension) {
            return this.loadContentForExtendedMemoryBlock(context);
        }
        return this.loadContentForSimpleMemoryBlock(context);
    }

    public Object[] loadContentForSimpleMemoryBlock(MemoryViewPresentationContext context) throws DebugException {
        AbstractAsyncTableRendering rendering = this.getTableRendering(context);
        if (rendering != null) {
            IMemoryBlock memoryBlock = rendering.getMemoryBlock();
            long startAddress = memoryBlock.getStartAddress();
            BigInteger address = BigInteger.valueOf(startAddress);
            long length = memoryBlock.getLength();
            long numLines = length / (long)rendering.getBytesPerLine();
            return this.getMemoryToFitTable(address, numLines, context);
        }
        return EMPTY;
    }

    public Object[] loadContentForExtendedMemoryBlock(MemoryViewPresentationContext context) throws DebugException {
        AbstractAsyncTableRendering rendering = this.getTableRendering(context);
        if (rendering != null) {
            TableRenderingContentDescriptor descriptor = rendering.getAdapter(TableRenderingContentDescriptor.class);
            if (descriptor == null) {
                return new Object[0];
            }
            if (descriptor.getNumLines() <= 0) {
                return new Object[0];
            }
            BigInteger loadAddress = descriptor.getLoadAddress();
            if (loadAddress == null) {
                loadAddress = new BigInteger("0");
            }
            BigInteger mbStart = descriptor.getStartAddress();
            BigInteger mbEnd = descriptor.getEndAddress();
            if (loadAddress.compareTo(mbStart) < 0 || loadAddress.compareTo(mbEnd) > 0) {
                loadAddress = ((IMemoryBlockExtension)descriptor.getMemoryBlock()).getBigBaseAddress();
                descriptor.setLoadAddress(loadAddress);
            }
            if (loadAddress.compareTo(mbStart) < 0 || loadAddress.compareTo(mbEnd) > 0) {
                throw new DebugException(DebugUIPlugin.newErrorStatus(String.valueOf(DebugUIMessages.TableRenderingContentProvider_0) + loadAddress.toString(16), null));
            }
            int addressableUnitsPerLine = rendering.getAddressableUnitPerLine();
            BigInteger bufferStart = loadAddress.subtract(BigInteger.valueOf(descriptor.getPreBuffer() * addressableUnitsPerLine));
            BigInteger bufferEnd = loadAddress.add(BigInteger.valueOf(descriptor.getPostBuffer() * addressableUnitsPerLine));
            bufferEnd = bufferEnd.add(BigInteger.valueOf(descriptor.getNumLines() * addressableUnitsPerLine));
            if (descriptor.isDynamicLoad()) {
                int numLines;
                if (bufferStart.compareTo(mbStart) < 0) {
                    bufferStart = mbStart;
                }
                if (bufferEnd.compareTo(mbEnd) > 0 && (numLines = (bufferEnd = mbEnd).subtract(bufferStart).divide(BigInteger.valueOf(addressableUnitsPerLine)).intValue()) < descriptor.getNumLines()) {
                    bufferStart = bufferEnd.subtract(BigInteger.valueOf(descriptor.getNumLines() * addressableUnitsPerLine));
                    if ((bufferStart = bufferStart.subtract(BigInteger.valueOf(descriptor.getPreBuffer() * addressableUnitsPerLine))).compareTo(mbStart) < 0) {
                        bufferStart = mbStart;
                    }
                }
                if (bufferEnd.compareTo(bufferStart) <= 0) {
                    throw new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.TableRenderingContentProvider_1, null));
                }
                numLines = bufferEnd.subtract(bufferStart).divide(BigInteger.valueOf(addressableUnitsPerLine)).intValue() + 1;
                return this.getMemoryToFitTable(bufferStart, numLines, context);
            }
            if (bufferStart.compareTo(mbStart) < 0) {
                bufferStart = mbStart;
            }
            if (bufferEnd.compareTo(mbEnd) > 0) {
                bufferStart = mbEnd.subtract(BigInteger.valueOf((descriptor.getNumLines() - 1) * addressableUnitsPerLine));
                bufferEnd = mbEnd;
                if (bufferStart.compareTo(mbStart) < 0) {
                    bufferStart = mbStart;
                }
            }
            if (bufferEnd.compareTo(bufferStart) <= 0) {
                throw new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.TableRenderingContentProvider_2, null));
            }
            int numLines = descriptor.getNumLines();
            int bufferNumLines = bufferEnd.subtract(bufferStart).divide(BigInteger.valueOf(addressableUnitsPerLine)).intValue() + 1;
            if (bufferNumLines < numLines) {
                numLines = bufferNumLines;
            }
            return this.getMemoryToFitTable(bufferStart, numLines, context);
        }
        return EMPTY;
    }

    public Object[] getMemoryToFitTable(BigInteger startAddress, long numberOfLines, MemoryViewPresentationContext context) throws DebugException {
        AbstractAsyncTableRendering tableRendering = this.getTableRendering(context);
        if (tableRendering == null) {
            DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.MemoryViewContentProvider_Unable_to_retrieve_content, null));
            throw e;
        }
        TableRenderingContentDescriptor descriptor = tableRendering.getAdapter(TableRenderingContentDescriptor.class);
        if (descriptor == null) {
            return new Object[0];
        }
        IDebugTarget target = descriptor.getMemoryBlock().getDebugTarget();
        if (target != null && (target.isDisconnected() || target.isTerminated())) {
            return new Object[0];
        }
        DebugException dbgEvt = null;
        String adjustedAddress = startAddress.toString(16);
        if (descriptor.isAlignAddressToBoundary() && descriptor.getMemoryBlock() instanceof IMemoryBlockExtension) {
            startAddress = MemoryViewUtil.alignToBoundary(startAddress, tableRendering.getAddressableUnitPerLine());
        }
        IMemoryBlockExtension extMemoryBlock = null;
        MemoryByte[] memoryBuffer = null;
        long reqNumBytes = 0L;
        try {
            if (descriptor.getMemoryBlock() instanceof IMemoryBlockExtension) {
                long reqNumberOfUnits;
                reqNumBytes = (long)tableRendering.getBytesPerLine() * numberOfLines;
                extMemoryBlock = (IMemoryBlockExtension)descriptor.getMemoryBlock();
                memoryBuffer = extMemoryBlock.getBytesFromAddress(startAddress, reqNumberOfUnits = (long)tableRendering.getAddressableUnitPerLine() * numberOfLines);
                if (memoryBuffer == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.MemoryViewContentProvider_Unable_to_retrieve_content, null));
                    throw e;
                }
            } else {
                byte[] memory = descriptor.getMemoryBlock().getBytes();
                if (memory == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.MemoryViewContentProvider_Unable_to_retrieve_content, null));
                    throw e;
                }
                int prefillNumBytes = 0;
                if (!startAddress.toString(16).endsWith("0")) {
                    adjustedAddress = startAddress.toString(16).substring(0, adjustedAddress.length() - 1);
                    adjustedAddress = String.valueOf(adjustedAddress) + "0";
                    BigInteger adjustedStart = new BigInteger(adjustedAddress, 16);
                    prefillNumBytes = startAddress.subtract(adjustedStart).intValue();
                    startAddress = adjustedStart;
                }
                reqNumBytes = descriptor.getMemoryBlock().getLength() + (long)prefillNumBytes;
                while (reqNumBytes % (long)tableRendering.getBytesPerLine() != 0L) {
                    ++reqNumBytes;
                }
                numberOfLines = reqNumBytes / (long)tableRendering.getBytesPerLine();
                memoryBuffer = new MemoryByte[(int)reqNumBytes];
                int i = 0;
                while (i < prefillNumBytes) {
                    MemoryByte tmp = new MemoryByte();
                    tmp.setValue((byte)0);
                    tmp.setWritable(false);
                    tmp.setReadable(false);
                    tmp.setEndianessKnown(false);
                    memoryBuffer[i] = tmp;
                    ++i;
                }
                int j = prefillNumBytes;
                byte[] byArray = memory;
                int n = memory.length;
                int n2 = 0;
                while (n2 < n) {
                    byte element = byArray[n2];
                    MemoryByte tmp = new MemoryByte();
                    tmp.setValue(element);
                    tmp.setReadable(true);
                    tmp.setWritable(true);
                    tmp.setEndianessKnown(false);
                    memoryBuffer[j] = tmp;
                    ++j;
                    ++n2;
                }
                int i2 = j;
                while (i2 < memoryBuffer.length) {
                    MemoryByte tmp = new MemoryByte();
                    tmp.setValue((byte)0);
                    tmp.setWritable(false);
                    tmp.setReadable(false);
                    tmp.setEndianessKnown(false);
                    memoryBuffer[i2] = tmp;
                    ++i2;
                }
            }
        }
        catch (DebugException e) {
            memoryBuffer = this.makeDummyContent(numberOfLines, tableRendering.getBytesPerLine());
            dbgEvt = e;
        }
        catch (Throwable e) {
            memoryBuffer = this.makeDummyContent(numberOfLines, tableRendering.getBytesPerLine());
            dbgEvt = new DebugException(DebugUIPlugin.newErrorStatus(e.getMessage(), e));
        }
        if ((long)memoryBuffer.length < reqNumBytes) {
            ArrayList<MemoryByte> newBuffer = new ArrayList<MemoryByte>();
            Collections.addAll(newBuffer, memoryBuffer);
            int i = memoryBuffer.length;
            while ((long)i < reqNumBytes) {
                MemoryByte mb = new MemoryByte();
                mb.setReadable(false);
                mb.setWritable(false);
                mb.setEndianessKnown(false);
                newBuffer.add(mb);
                ++i;
            }
            memoryBuffer = newBuffer.toArray(new MemoryByte[newBuffer.size()]);
        }
        boolean manageDelta = true;
        if (descriptor.getMemoryBlock() instanceof IMemoryBlockExtension) {
            boolean bl = manageDelta = !((IMemoryBlockExtension)descriptor.getMemoryBlock()).supportsChangeManagement();
        }
        if (dbgEvt != null) {
            throw dbgEvt;
        }
        return this.organizeLines(numberOfLines, memoryBuffer, startAddress, manageDelta, context);
    }

    private Object[] organizeLines(long numberOfLines, MemoryByte[] memoryBuffer, BigInteger address, boolean manageDelta, MemoryViewPresentationContext context) {
        ArrayList<MemorySegment> lineCache = new ArrayList<MemorySegment>();
        IMemoryRendering rendering = context.getRendering();
        if (!(rendering instanceof AbstractAsyncTableRendering)) {
            return lineCache.toArray();
        }
        AbstractAsyncTableRendering tableRendering = (AbstractAsyncTableRendering)rendering;
        int addressableUnit = tableRendering.getBytesPerLine() / tableRendering.getAddressableSize();
        int i = 0;
        while ((long)i < numberOfLines) {
            int bytesPerLine = tableRendering.getBytesPerLine();
            MemoryByte[] memory = new MemoryByte[bytesPerLine];
            int k = 0;
            int j = i * bytesPerLine;
            while (j < i * bytesPerLine + bytesPerLine) {
                MemoryByte newByteObj;
                byte changeFlag = memoryBuffer[j].getFlags();
                if (manageDelta) {
                    changeFlag = (byte)(changeFlag | 8);
                    changeFlag = (byte)(changeFlag ^ 8);
                    changeFlag = (byte)(changeFlag | 4);
                    changeFlag = (byte)(changeFlag ^ 4);
                }
                memory[k] = newByteObj = new MemoryByte(memoryBuffer[j].getValue(), changeFlag);
                ++k;
                ++j;
            }
            MemorySegment newLine = new MemorySegment(address, memory, addressableUnit);
            lineCache.add(newLine);
            address = address.add(BigInteger.valueOf(addressableUnit));
            ++i;
        }
        return lineCache.toArray();
    }

    private MemoryByte[] makeDummyContent(long numberOfLines, int bytesPerLine) {
        int numBytes = (int)((long)bytesPerLine * numberOfLines);
        MemoryByte[] memoryBuffer = new MemoryByte[numBytes];
        int i = 0;
        while (i < memoryBuffer.length) {
            memoryBuffer[i] = new MemoryByte();
            memoryBuffer[i].setValue((byte)0);
            memoryBuffer[i].setWritable(false);
            memoryBuffer[i].setReadable(false);
            memoryBuffer[i].setEndianessKnown(false);
            ++i;
        }
        return memoryBuffer;
    }

    protected AbstractAsyncTableRendering getTableRendering(MemoryViewPresentationContext context) {
        IMemoryRendering memRendering = context.getRendering();
        if (memRendering != null && memRendering instanceof AbstractAsyncTableRendering) {
            return (AbstractAsyncTableRendering)memRendering;
        }
        return null;
    }
}

