/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.parser.CombineIterator;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.impl.completion.EOperationServiceCompletionProposal;
import org.eclipse.acceleo.query.validation.type.AbstractType;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IJavaType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;

public class EOperationService
extends AbstractService {
    public static final int PRIORITY = 100;
    protected static final String COULDN_T_INVOKE_EOPERATION = "Couldn't invoke the %s EOperation (%s)";
    private final EOperation eOperation;
    private final Method method;

    public EOperationService(EOperation eOperation) {
        this.eOperation = eOperation;
        this.method = this.lookupMethod(this.eOperation);
    }

    private Method lookupMethod(EOperation operation) {
        Method result;
        Class containerClass = operation.getEContainingClass().getInstanceClass();
        if (containerClass != null) {
            Class[] argumentClasses = new Class[operation.getEParameters().size()];
            int i = 0;
            while (i < argumentClasses.length) {
                EParameter param = (EParameter)operation.getEParameters().get(i);
                argumentClasses[i] = param.isMany() ? EList.class : param.getEType().getInstanceClass();
                ++i;
            }
            try {
                result = containerClass.getMethod(operation.getName(), argumentClasses);
            }
            catch (SecurityException e) {
                result = null;
            }
            catch (NoSuchMethodException e) {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public String getName() {
        return this.eOperation.getName();
    }

    @Override
    public List<IType> getParameterTypes(IReadOnlyQueryEnvironment queryEnvironment) {
        ArrayList<IType> result = new ArrayList<IType>();
        result.add(new EClassifierType(queryEnvironment, (EClassifier)this.getEOperation().getEContainingClass()));
        for (EParameter parameter : this.getEOperation().getEParameters()) {
            EClassifierType rawType = new EClassifierType(queryEnvironment, parameter.getEType());
            if (parameter.isMany()) {
                result.add(new SequenceType(queryEnvironment, rawType));
                continue;
            }
            result.add(rawType);
        }
        return result;
    }

    @Override
    public int getNumberOfParameters() {
        return this.eOperation.getEParameters().size() + 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object internalInvoke(Object[] arguments) throws Exception {
        EObject receiver = (EObject)arguments[0];
        Object[] localArguments = new Object[arguments.length];
        int i = 1;
        while (i < arguments.length) {
            localArguments[i] = ((EParameter)this.eOperation.getEParameters().get(i - 1)).isMany() ? new BasicEList((Collection)arguments[i]) : arguments[i];
            ++i;
        }
        if (!this.eOperation.getEContainingClass().isSuperTypeOf(receiver.eClass())) {
            if (this.method == null) throw new IllegalStateException(String.format("EOperation %s not in %s type hierarchy of %s and no %s method in %s", this.getName(), this.getEOperation().getEContainingClass().getName(), receiver.eClass().getName(), this.getName(), receiver.getClass().getName()));
            Object[] parameters = Arrays.copyOfRange(localArguments, 1, localArguments.length);
            return this.eOperationJavaInvoke(this.method, receiver, parameters);
        }
        if (this.hasEInvoke(receiver)) {
            BasicEList eArguments = new BasicEList(localArguments.length);
            int i2 = 1;
            while (i2 < localArguments.length) {
                eArguments.add(localArguments[i2]);
                ++i2;
            }
            return receiver.eInvoke(this.eOperation, (EList)eArguments);
        }
        if (this.method == null) throw new IllegalStateException(String.format("No eInvoke nor %s methods in %s", this.getName(), receiver.getClass().getName()));
        Object[] parameters = Arrays.copyOfRange(localArguments, 1, localArguments.length);
        return this.eOperationJavaInvoke(this.method, receiver, parameters);
    }

    private boolean hasEInvoke(Object object) {
        Method eInvokeMethod = null;
        try {
            eInvokeMethod = object.getClass().getDeclaredMethod("eInvoke", Integer.TYPE, EList.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return eInvokeMethod != null;
    }

    private Object eOperationJavaInvoke(Method eInvokeMethod, Object receiver, Object[] arguments) throws Exception {
        if (eInvokeMethod != null && receiver != null) {
            return eInvokeMethod.invoke(receiver, arguments);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        EClassifierType eClassifierType = new EClassifierType(queryEnvironment, this.eOperation.getEType());
        if (this.eOperation.isMany()) {
            result.add(new SequenceType(queryEnvironment, eClassifierType));
        } else {
            result.add(eClassifierType);
        }
        return result;
    }

    @Override
    public boolean matches(IReadOnlyQueryEnvironment queryEnvironment, IType[] argumentTypes) {
        ArrayList eClassifierTypes = new ArrayList(argumentTypes.length);
        boolean canMatch = true;
        int i = 0;
        while (i < argumentTypes.length) {
            Set<Object> eClassifiers;
            IType iType = argumentTypes[i];
            if (iType instanceof EClassifierLiteralType) {
                eClassifiers = new LinkedHashSet<Object>();
                eClassifiers.add(EcorePackage.eINSTANCE.getEClass());
            } else if (iType instanceof EClassifierType) {
                eClassifiers = new LinkedHashSet();
                eClassifiers.add(((EClassifierType)iType).getType());
            } else if (iType instanceof SequenceType) {
                eClassifiers = new LinkedHashSet();
                eClassifiers.add(EcorePackage.eINSTANCE.getEEList());
            } else if (iType instanceof IJavaType) {
                if (iType.getType() == null) {
                    eClassifiers = new LinkedHashSet();
                    eClassifiers.add(null);
                } else if (List.class.isAssignableFrom(((IJavaType)iType).getType())) {
                    eClassifiers = new LinkedHashSet();
                    eClassifiers.add(EcorePackage.eINSTANCE.getEEList());
                } else {
                    eClassifiers = queryEnvironment.getEPackageProvider().getEClassifiers(((IJavaType)iType).getType());
                    if (eClassifiers == null) {
                        canMatch = false;
                        break;
                    }
                }
            } else {
                throw new AcceleoQueryValidationException(iType.getClass().getCanonicalName());
            }
            LinkedHashSet<AbstractType> types = new LinkedHashSet<AbstractType>();
            for (EClassifier eClassifier : eClassifiers) {
                if (eClassifier != null) {
                    types.add(new EClassifierType(queryEnvironment, eClassifier));
                    continue;
                }
                types.add(new ClassType(queryEnvironment, null));
            }
            eClassifierTypes.add(types);
            ++i;
        }
        if (canMatch) {
            CombineIterator it = new CombineIterator(eClassifierTypes);
            boolean matched = false;
            while (it.hasNext()) {
                Object parameterTypes = it.next();
                if (!super.matches(queryEnvironment, parameterTypes.toArray(new IType[parameterTypes.size()]))) continue;
                matched = true;
                break;
            }
            canMatch = matched;
        }
        return canMatch;
    }

    public EOperation getEOperation() {
        return this.eOperation;
    }

    @Override
    public String getShortSignature() {
        List<IType> parameterTypes = this.getParameterTypes(null);
        Object[] argumentTypes = parameterTypes.toArray(new IType[parameterTypes.size()]);
        return this.serviceShortSignature(argumentTypes);
    }

    @Override
    public String getLongSignature() {
        String ePkgNsURI;
        String eCLassName;
        EClass eContainingClass = this.getEOperation().getEContainingClass();
        if (eContainingClass != null) {
            eCLassName = eContainingClass.getName();
            EPackage ePackage = eContainingClass.getEPackage();
            ePkgNsURI = ePackage != null ? ePackage.getNsURI() : null;
        } else {
            ePkgNsURI = null;
            eCLassName = null;
        }
        return String.valueOf(ePkgNsURI) + " " + eCLassName + " " + this.getShortSignature();
    }

    public boolean equals(Object obj) {
        return obj instanceof EOperationService && ((EOperationService)obj).getEOperation().equals(this.getEOperation());
    }

    public int hashCode() {
        return this.getEOperation().hashCode();
    }

    @Override
    public List<ICompletionProposal> getProposals(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> receiverTypes) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.add(new EOperationServiceCompletionProposal(this.getEOperation()));
        return result;
    }
}

