/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.servlet;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.core.JakartaForJavaAssert;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.junit.Ignore;
import org.junit.Test;

public class JakartaServletTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    @Ignore
    public void ExtendWebServlet() throws Exception {
        IJavaProject javaProject = JakartaServletTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/servlet/DontExtendHttpServlet.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d = JakartaForJavaAssert.d(5, 13, 34, "Annotated classes with @WebServlet must extend the HttpServlet class.", DiagnosticSeverity.Warning, "jakarta-servlet", "WebServletAnnotatedClassUnknownSuperTypeDoesNotExtendHttpServlet");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d);
        TextEdit te = JakartaForJavaAssert.te(5, 34, 5, 34, " extends HttpServlet");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Let 'DontExtendHttpServlet' extend 'HttpServlet'", d, te);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca);
    }

    @Test
    @Ignore
    public void CompleteWebServletAnnotation() throws Exception {
        IJavaProject javaProject = JakartaServletTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/servlet/InvalidWebServlet.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d = JakartaForJavaAssert.d(9, 0, 13, "The @WebServlet annotation must define the attribute 'urlPatterns' or 'value'.", DiagnosticSeverity.Error, "jakarta-servlet", "WebServletAnnotationMissingAttributes");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d);
        TextEdit te1 = JakartaForJavaAssert.te(9, 0, 10, 0, "@WebServlet(value = \"\")\n");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Add the `value` attribute to @WebServlet", d, te1);
        TextEdit te2 = JakartaForJavaAssert.te(9, 0, 10, 0, "@WebServlet(urlPatterns = \"\")\n");
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Add the `urlPatterns` attribute to @WebServlet", d, te2);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca1, ca2);
    }
}

