/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class XMLSelectionRanges {
    private static final Logger LOGGER = Logger.getLogger(XMLSelectionRanges.class.getName());

    public List<SelectionRange> getSelectionRanges(DOMDocument xmlDocument, List<Position> positions, CancelChecker cancelChecker) {
        ArrayList<SelectionRange> selectionRanges = new ArrayList<SelectionRange>();
        for (Position position : positions) {
            selectionRanges.add(this.getSelectionRangeFromCursorPosition(xmlDocument, position));
            cancelChecker.checkCanceled();
        }
        return selectionRanges;
    }

    private SelectionRange getSelectionRangeFromCursorPosition(DOMDocument xmlDocument, Position position) {
        try {
            int offset = xmlDocument.offsetAt(position);
            DOMNode node = this.getNodeAtOffset(xmlDocument, offset);
            return this.getSelectionRangeFromNode(node, offset);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Unable to calculate selection range for position " + position, e);
            return null;
        }
    }

    private DOMNode getNodeAtOffset(DOMDocument xmlDocument, int offset) {
        DOMNode node;
        block3: {
            DOMDocumentType doctype;
            DTDDeclParameter subset;
            block2: {
                node = DOMDocument.findNodeOrAttrAt(xmlDocument, offset);
                if (!node.isAttribute()) break block2;
                DOMAttr attr = (DOMAttr)node;
                for (DOMNode attrChild : attr.getChildren()) {
                    if (attrChild.getStart() > offset || offset > attrChild.getEnd()) continue;
                    return attrChild;
                }
                break block3;
            }
            if (!node.isDoctype() || (subset = (doctype = (DOMDocumentType)node).getInternalSubsetNode()) == null || subset.getStart() >= offset || offset >= subset.getEnd()) break block3;
            for (DOMNode child : doctype.getChildren()) {
                if (child.getStart() == -1 || child.getStart() > offset || offset >= child.getEnd()) continue;
                return child;
            }
        }
        return node;
    }

    private SelectionRange getSelectionRangeFromNode(DOMNode node, int offset) {
        DOMNode prolog;
        SelectionRange leafSelectionRange = new SelectionRange();
        leafSelectionRange.setRange(new Range());
        SelectionRange selectionRange = leafSelectionRange;
        do {
            selectionRange = this.handleNodeSelectionRange(selectionRange, node, offset);
            if (!node.isAttribute() || ((DOMAttr)node).getOwnerElement() == null) continue;
            node = ((DOMAttr)node).getOwnerElement();
        } while ((node = (prolog = node.getOwnerDocument().getProlog()) != null && node != node.getOwnerDocument() && node != prolog && prolog.getStart() <= offset && offset <= prolog.getEnd() ? node.getOwnerDocument().getProlog() : node.getParentNode()) != null);
        return leafSelectionRange.getParent();
    }

    private SelectionRange handleNodeSelectionRange(SelectionRange selectionRange, DOMNode node, int offset) {
        switch (node.getNodeType()) {
            case 1: {
                return this.handleElementSelectionRange(selectionRange, (DOMElement)node, offset);
            }
            case 2: {
                return this.handleAttributeSelectionRange(selectionRange, (DOMAttr)node, offset);
            }
            case 10: {
                return this.handleDoctypeSelectionRange(selectionRange, (DOMDocumentType)node, offset);
            }
        }
        return this.handleGenericNodeSelectionRange(selectionRange, node, offset);
    }

    private SelectionRange handleAttributeSelectionRange(SelectionRange selectionRange, DOMAttr attr, int offset) {
        selectionRange = this.handleGenericNodeSelectionRange(selectionRange, attr, offset);
        DOMElement ownerElement = attr.getOwnerElement();
        if (ownerElement != null) {
            selectionRange = this.handleGenericNodeSelectionRange(selectionRange, ownerElement, offset);
        }
        return selectionRange;
    }

    private SelectionRange handleElementSelectionRange(SelectionRange selectionRange, DOMElement element, int offset) {
        int contentStart = element.getStartTagCloseOffset() + 1;
        int contentEnd = element.getEndTagOpenOffset();
        SelectionRange parentSelectionRange = new SelectionRange();
        if (contentStart != -1 && contentEnd != -1 && offset >= contentStart && offset <= contentEnd) {
            Range range = XMLPositionUtility.createRange(contentStart, contentEnd, element.getOwnerDocument());
            if (range != null && !range.equals((Object)selectionRange.getRange())) {
                parentSelectionRange.setRange(range);
                selectionRange.setParent(parentSelectionRange);
                selectionRange = parentSelectionRange;
            }
        } else if (contentStart != -1 && offset < contentStart) {
            parentSelectionRange.setRange(XMLPositionUtility.selectStartTagName(element));
            selectionRange.setParent(parentSelectionRange);
            selectionRange = parentSelectionRange;
        } else if (offset <= element.getEndTagCloseOffset()) {
            parentSelectionRange.setRange(XMLPositionUtility.selectEndTagName(element));
            selectionRange.setParent(parentSelectionRange);
            selectionRange = parentSelectionRange;
        }
        return this.handleGenericNodeSelectionRange(selectionRange, element, offset);
    }

    private SelectionRange handleDoctypeSelectionRange(SelectionRange selectionRange, DOMDocumentType doctype, int offset) {
        DTDDeclParameter internalSubset = doctype.getInternalSubsetNode();
        if (internalSubset != null) {
            int subsetStart = internalSubset.getStart();
            int subsetEnd = internalSubset.getEnd();
            if (subsetStart != -1 && subsetStart < offset && offset < subsetEnd) {
                try {
                    Position startPos = doctype.getOwnerDocument().positionAt(subsetStart + 1);
                    Position endPos = doctype.getOwnerDocument().positionAt(subsetEnd - 1);
                    Range range = new Range(startPos, endPos);
                    SelectionRange parentSelectionRange = new SelectionRange();
                    parentSelectionRange.setRange(range);
                    selectionRange.setParent(parentSelectionRange);
                    selectionRange = parentSelectionRange;
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, "Failed to select DOCTYPE subset", e);
                }
            }
        }
        return this.handleGenericNodeSelectionRange(selectionRange, doctype, offset);
    }

    private SelectionRange handleGenericNodeSelectionRange(SelectionRange selectionRange, DOMNode node, int offset) {
        Range range = XMLPositionUtility.createRange(node);
        if (!range.equals((Object)selectionRange.getRange())) {
            SelectionRange parentSelectionRange = new SelectionRange();
            parentSelectionRange.setRange(range);
            selectionRange.setParent(parentSelectionRange);
            selectionRange = parentSelectionRange;
        }
        return selectionRange;
    }
}

