/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.filepath.participants;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.NoNamespaceSchemaLocation;
import org.eclipse.lemminx.dom.SchemaLocation;
import org.eclipse.lemminx.extensions.filepath.FilePathPlugin;
import org.eclipse.lemminx.extensions.filepath.IFilePathExpression;
import org.eclipse.lemminx.extensions.filepath.SimpleFilePathExpression;
import org.eclipse.lemminx.extensions.filepath.participants.FilePathCompletionResult;
import org.eclipse.lemminx.services.extensions.completion.CompletionParticipantAdapter;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.completion.ICompletionResponse;
import org.eclipse.lemminx.utils.CompletionSortTextHelper;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lemminx.utils.platform.Platform;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class FilePathCompletionParticipant
extends CompletionParticipantAdapter {
    private static final Logger LOGGER = Logger.getLogger(FilePathCompletionParticipant.class.getName());
    private static final IFilePathExpression DOCTYPE_FILE_PATH_EXPRESSION = new SimpleFilePathExpression(){

        @Override
        protected boolean acceptFile(Path path) {
            return DOMUtils.isDTD(FilesUtils.getFileName(path));
        }
    };
    private static final IFilePathExpression NO_NAMESPACE_SCHEMALOCATION_FILE_PATH_EXPRESSION = new SimpleFilePathExpression(){

        @Override
        protected boolean acceptFile(Path path) {
            return DOMUtils.isXSD(FilesUtils.getFileName(path));
        }
    };
    private static final IFilePathExpression SCHEMALOCATION_FILE_PATH_EXPRESSION = new SimpleFilePathExpression(){

        @Override
        protected boolean acceptFile(Path path) {
            return DOMUtils.isXSD(FilesUtils.getFileName(path));
        }

        @Override
        public Character getSeparator() {
            return Character.valueOf(' ');
        }
    };
    private final FilePathPlugin filePathPlugin;

    public FilePathCompletionParticipant(FilePathPlugin filePathPlugin) {
        this.filePathPlugin = filePathPlugin;
    }

    @Override
    public void onAttributeValue(String value, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        DOMDocument document = request.getXMLDocument();
        int completionOffset = request.getOffset();
        DOMNode node = request.getNode();
        DOMAttr attr = node.findAttrAt(request.getOffset());
        NoNamespaceSchemaLocation noNamespaceSchemaLocation = document.getNoNamespaceSchemaLocation();
        if (noNamespaceSchemaLocation != null && attr == noNamespaceSchemaLocation.getAttr()) {
            this.addFileCompletionItems(attr, document, completionOffset, NO_NAMESPACE_SCHEMALOCATION_FILE_PATH_EXPRESSION, response, cancelChecker);
            return;
        }
        SchemaLocation schemaLocation = document.getSchemaLocation();
        if (schemaLocation != null && attr == schemaLocation.getAttr()) {
            this.addFileCompletionItems(attr, document, completionOffset, SCHEMALOCATION_FILE_PATH_EXPRESSION, response, cancelChecker);
            return;
        }
        List<IFilePathExpression> expressions = this.filePathPlugin.findFilePathExpressions(document);
        if (expressions.isEmpty()) {
            return;
        }
        for (IFilePathExpression expression : expressions) {
            if (!expression.match(attr)) continue;
            cancelChecker.checkCanceled();
            this.addFileCompletionItems(attr, document, completionOffset, expression, response, cancelChecker);
        }
    }

    private void addFileCompletionItems(DOMAttr attr, DOMDocument xmlDocument, int completionOffset, IFilePathExpression expression, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        DOMRange attrValueRange = attr.getNodeAttrValue();
        FilePathCompletionParticipant.addFileCompletionItems(xmlDocument, attrValueRange.getStart() + 1, attrValueRange.getEnd() - 1, completionOffset, expression, response, cancelChecker);
    }

    @Override
    public void onXMLContent(ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        List<IFilePathExpression> expressions = this.filePathPlugin.findFilePathExpressions(request.getXMLDocument());
        if (expressions.isEmpty()) {
            return;
        }
        DOMText textNode = FilePathCompletionParticipant.findTextNode(request.getNode(), request.getOffset());
        if (textNode == null) {
            return;
        }
        DOMDocument xmlDocument = request.getXMLDocument();
        for (IFilePathExpression expression : expressions) {
            if (!expression.match(textNode)) continue;
            DOMText textRange = textNode;
            FilePathCompletionParticipant.addFileCompletionItems(xmlDocument, textRange.getStart(), textRange.getEnd(), request.getOffset(), expression, response, cancelChecker);
        }
    }

    private static DOMText findTextNode(DOMNode node, int offset) {
        DOMText text;
        if (node == null || node.isText()) {
            return (DOMText)node;
        }
        if (node.isElement() && (text = ((DOMElement)node).findTextAt(offset)) != null) {
            return text;
        }
        return null;
    }

    @Override
    public void onDTDSystemId(String value, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        DOMDocument xmlDocument = request.getXMLDocument();
        DTDDeclParameter systemId = xmlDocument.getDoctype().getSystemIdNode();
        FilePathCompletionParticipant.addFileCompletionItems(xmlDocument, systemId.getStart() + 1, systemId.getEnd() - 1, request.getOffset(), DOCTYPE_FILE_PATH_EXPRESSION, response, cancelChecker);
    }

    private static void addFileCompletionItems(DOMDocument xmlDocument, int startOffset, int endOffset, int completionOffset, IFilePathExpression expression, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        Character separator = expression != null ? expression.getSeparator() : null;
        FilePathCompletionResult result = FilePathCompletionResult.create(xmlDocument.getText(), xmlDocument.getDocumentURI(), startOffset, endOffset, completionOffset, separator);
        Path baseDir = result.getBaseDir();
        if (baseDir == null) {
            return;
        }
        Range replaceRange = XMLPositionUtility.createRange(result.getStartOffset(), result.getEndOffset(), xmlDocument);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(baseDir);){
            for (Path entry : stream) {
                cancelChecker.checkCanceled();
                if (expression != null && !expression.acceptPath(entry)) continue;
                FilePathCompletionParticipant.createFilePathCompletionItem(entry.toFile(), replaceRange, response);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while getting files/directories", e);
        }
    }

    private static void createFilePathCompletionItem(File file, Range replaceRange, ICompletionResponse response) {
        CompletionItem item = new CompletionItem();
        String fileName = FilesUtils.encodePath(file.getName());
        if (Platform.isWindows && fileName.isEmpty()) {
            fileName = file.getPath();
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        String insertText = fileName;
        item.setLabel(insertText);
        CompletionItemKind kind = file.isDirectory() ? CompletionItemKind.Folder : CompletionItemKind.File;
        item.setKind(kind);
        item.setSortText(CompletionSortTextHelper.getSortText(kind));
        item.setFilterText(insertText);
        item.setTextEdit(Either.forLeft((Object)new TextEdit(replaceRange, insertText)));
        response.addCompletionItem(item);
    }
}

