/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.completion;

import java.util.Collection;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.extensions.completion.AbstractAttributeCompletionResolver;
import org.eclipse.lemminx.services.extensions.completion.ICompletionItemResolverRequest;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class AttributeValueCompletionResolver
extends AbstractAttributeCompletionResolver {
    public static final String PARTICIPANT_ID = AttributeValueCompletionResolver.class.getName();

    @Override
    protected void resolveCompletionItem(DOMElement element, CompletionItem toResolve, ICompletionItemResolverRequest request, CancelChecker cancelChecker) {
        int offset = request.getCompletionOffset();
        DOMAttr attr = element.findAttrAt(offset);
        if (attr == null) {
            return;
        }
        String attributeValue = toResolve.getLabel();
        try {
            ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
            Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(element);
            for (CMDocument cmDocument : cmDocuments) {
                MarkupContent documentation;
                CMElementDeclaration cmElement = cmDocument.findCMElement(element, element.getNamespaceURI());
                if (cmElement == null || (documentation = AttributeValueCompletionResolver.getDocumentationForAttributeValue(cmElement, attr, attributeValue, request)) == null) continue;
                toResolve.setDocumentation(documentation);
                return;
            }
        }
        catch (CacheResourceDownloadingException cacheResourceDownloadingException) {
            // empty catch block
        }
    }

    private static MarkupContent getDocumentationForAttributeValue(CMElementDeclaration cmElement, DOMAttr attr, String attributeValue, ICompletionItemResolverRequest request) {
        CMAttributeDeclaration cmAttribute = cmElement.findCMAttribute(attr);
        if (cmAttribute != null) {
            return XMLGenerator.createMarkupContent(cmAttribute, attributeValue, cmElement, request);
        }
        return null;
    }
}

