/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lemminx.commons.SnippetsBuilder;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.IXMLDocumentProvider;
import org.eclipse.lemminx.services.extensions.commands.AbstractDOMDocumentCommandHandler;
import org.eclipse.lemminx.services.extensions.commands.ArgumentsUtils;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class SurroundWithCommand
extends AbstractDOMDocumentCommandHandler {
    public static final String COMMAND_ID = "xml.refactor.surround.with";
    private final ContentModelManager contentModelManager;

    public SurroundWithCommand(IXMLDocumentProvider documentProvider, ContentModelManager contentModelManager) {
        super(documentProvider);
        this.contentModelManager = contentModelManager;
    }

    @Override
    protected Object executeCommand(DOMDocument document, ExecuteCommandParams params, SharedSettings sharedSettings, CancelChecker cancelChecker) throws Exception {
        DOMElement element;
        Range selection = ArgumentsUtils.getArgAt(params, 1, Range.class);
        SurroundWithKind kind = SurroundWithKind.get(ArgumentsUtils.getArgAt(params, 2, String.class));
        boolean snippetsSupported = ArgumentsUtils.getArgAt(params, 3, Boolean.class);
        boolean emptySelection = selection.getStart().equals((Object)selection.getEnd());
        StringBuilder startText = null;
        StringBuilder endText = null;
        Position startPos = selection.getStart();
        Position endPos = selection.getEnd();
        String prefix = null;
        int offset = document.offsetAt(selection.getStart());
        DOMNode node = document.findNodeAt(offset);
        boolean adjusted = false;
        if (emptySelection && node.isElement() && ((element = (DOMElement)node).isInStartTag(offset) || element.isInEndTag(offset))) {
            startPos = document.positionAt(element.getStart());
            endPos = document.positionAt(element.isEndTagClosed() ? element.getEndTagCloseOffset() + 1 : element.getEnd());
            adjusted = true;
        }
        switch (kind) {
            case cdata: {
                startText = new StringBuilder("<![CDATA[");
                if (snippetsSupported && emptySelection) {
                    SnippetsBuilder.tabstops(1, startText);
                }
                endText = new StringBuilder("]]>");
                if (!snippetsSupported) break;
                SnippetsBuilder.tabstops(0, endText);
                break;
            }
            case comments: {
                startText = new StringBuilder("<!--");
                if (snippetsSupported && emptySelection) {
                    SnippetsBuilder.tabstops(1, startText);
                }
                endText = new StringBuilder("-->");
                if (!snippetsSupported) break;
                SnippetsBuilder.tabstops(0, endText);
                break;
            }
            default: {
                List<String> tags = this.getTags(node, prefix, offset, adjusted);
                String tag = tags.isEmpty() ? "" : tags.get(0);
                startText = new StringBuilder("<");
                if (snippetsSupported) {
                    if (!tags.isEmpty()) {
                        SnippetsBuilder.choice(1, tags, startText);
                    } else {
                        SnippetsBuilder.placeholders(1, tag, startText);
                    }
                } else {
                    startText.append(tag);
                }
                startText.append(">");
                if (!adjusted && emptySelection && snippetsSupported) {
                    SnippetsBuilder.tabstops(2, startText);
                }
                endText = new StringBuilder("</");
                if (snippetsSupported) {
                    SnippetsBuilder.placeholders(1, tag, endText);
                } else {
                    endText.append(tag);
                }
                endText.append(">");
                if (!snippetsSupported) break;
                SnippetsBuilder.tabstops(0, endText);
            }
        }
        TextEdit start = new TextEdit(new Range(startPos, startPos), startText.toString());
        TextEdit end = new TextEdit(new Range(endPos, endPos), endText.toString());
        return new SurroundWithResponse(start, end);
    }

    private List<String> getTags(DOMNode node, String prefix, int offset, boolean adjusted) {
        Collection<CMDocument> cmDocuments;
        DOMElement parentElement = node.isElement() && !adjusted ? (DOMElement)node : node.getParentElement();
        Collection<CMDocument> collection = cmDocuments = parentElement != null ? this.contentModelManager.findCMDocument(parentElement) : this.contentModelManager.findCMDocument(node.getOwnerDocument(), null);
        if (parentElement == null) {
            return cmDocuments.stream().flatMap(cmDocument -> cmDocument.getElements().stream()).map(decl -> decl.getName(prefix)).distinct().sorted().collect(Collectors.toList());
        }
        for (CMDocument cmDocument2 : cmDocuments) {
            CMElementDeclaration elementDeclaration = cmDocument2.findCMElement(parentElement);
            if (elementDeclaration == null) continue;
            return elementDeclaration.getPossibleElements(parentElement, offset).stream().map(decl -> decl.getName(prefix)).sorted().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static enum SurroundWithKind {
        tags,
        comments,
        cdata;


        public static SurroundWithKind get(String kind) {
            return SurroundWithKind.valueOf(kind);
        }
    }

    public static class SurroundWithResponse {
        private TextEdit start;
        private TextEdit end;

        public SurroundWithResponse() {
        }

        public SurroundWithResponse(TextEdit start, TextEdit end) {
            this.start = start;
            this.end = end;
        }

        public TextEdit getStart() {
            return this.start;
        }

        public TextEdit getEnd() {
            return this.end;
        }
    }
}

