/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.route;

import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.route.RouteConfig;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class RouteConfigIP<T extends IPAddress>
implements RouteConfig {
    private T destination;
    private T gateway;
    private T netmask;
    private String interfaceName;
    private int metric;

    public RouteConfigIP(T destination, T gateway, T netmask, String interfaceName, int metric) {
        this.destination = destination;
        this.gateway = gateway;
        this.netmask = netmask;
        this.interfaceName = interfaceName;
        this.metric = metric;
    }

    @Override
    public String getDescription() {
        StringBuffer desc = new StringBuffer();
        String gw = this.gateway == null ? "default" : ((IPAddress)this.gateway).getHostAddress();
        desc.append("Destination: " + ((IPAddress)this.destination).getHostAddress() + ", " + "Gateway: " + gw + ", " + "Netmask: " + ((IPAddress)this.netmask).getHostAddress() + ", " + "Interface: " + this.interfaceName + ", " + "Metric: " + this.metric);
        return desc.toString();
    }

    public T getDestination() {
        return this.destination;
    }

    public void setDestination(T destination) {
        this.destination = destination;
    }

    public T getGateway() {
        return this.gateway;
    }

    public void setGateway(T gateway) {
        this.gateway = gateway;
    }

    public T getNetmask() {
        return this.netmask;
    }

    public void setNetmask(T netmask) {
        this.netmask = netmask;
    }

    @Override
    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    @Override
    public int getMetric() {
        return this.metric;
    }

    public void setMetric(int metric) {
        this.metric = metric;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.destination == null ? 0 : ((IPAddress)this.destination).hashCode());
        result = 31 * result + (this.gateway == null ? 0 : ((IPAddress)this.gateway).hashCode());
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + this.metric;
        result = 31 * result + (this.netmask == null ? 0 : ((IPAddress)this.netmask).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RouteConfigIP other = (RouteConfigIP)obj;
        if (this.destination == null ? other.destination != null : !((IPAddress)this.destination).equals(other.destination)) {
            return false;
        }
        if (this.gateway == null ? other.gateway != null : !((IPAddress)this.gateway).equals(other.gateway)) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        if (this.metric != other.metric) {
            return false;
        }
        return !(this.netmask == null ? other.netmask != null : !((IPAddress)this.netmask).equals(other.netmask));
    }

    @Override
    public boolean isValid() {
        return this.destination != null && this.gateway != null && this.netmask != null && this.interfaceName != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RouteConfigIP [m_destination=");
        builder.append(this.destination);
        builder.append(", m_gateway=");
        builder.append(this.gateway);
        builder.append(", m_netmask=");
        builder.append(this.netmask);
        builder.append(", m_interfaceName=");
        builder.append(this.interfaceName);
        builder.append(", m_metric=");
        builder.append(this.metric);
        builder.append("]");
        return builder.toString();
    }
}

