/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.UnaryOperator;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.container.orchestration.ContainerConfiguration;
import org.eclipse.kura.container.orchestration.ContainerInstanceDescriptor;
import org.eclipse.kura.container.orchestration.ContainerOrchestrationService;
import org.eclipse.kura.container.orchestration.RegistryCredentials;
import org.eclipse.kura.container.orchestration.listener.ContainerOrchestrationServiceListener;
import org.eclipse.kura.container.provider.ContainerInstanceOptions;
import org.eclipse.kura.container.signature.ContainerSignatureValidationService;
import org.eclipse.kura.container.signature.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerInstance
implements ConfigurableComponent,
ContainerOrchestrationServiceListener {
    private static final Logger logger = LoggerFactory.getLogger(ContainerInstance.class);
    private static final ValidationResult FAILED_VALIDATION = new ValidationResult();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private ContainerOrchestrationService containerOrchestrationService;
    private Set<ContainerSignatureValidationService> availableContainerSignatureValidationService = new HashSet<ContainerSignatureValidationService>();
    private ConfigurationService configurationService;
    private State state = new Disabled(new ContainerInstanceOptions(Collections.emptyMap()));
    private ContainerInstanceOptions currentOptions = null;

    public void setContainerOrchestrationService(ContainerOrchestrationService containerOrchestrationService) {
        this.containerOrchestrationService = containerOrchestrationService;
    }

    public synchronized void setContainerSignatureValidationService(ContainerSignatureValidationService containerSignatureValidationService) {
        logger.info("Container signature validation service {} added.", containerSignatureValidationService.getClass());
        this.availableContainerSignatureValidationService.add(containerSignatureValidationService);
    }

    public synchronized void unsetContainerSignatureValidationService(ContainerSignatureValidationService containerSignatureValidationService) {
        logger.info("Container signature validation service {} removed.", containerSignatureValidationService.getClass());
        this.availableContainerSignatureValidationService.remove(containerSignatureValidationService);
    }

    public synchronized void setConfigurationService(ConfigurationService confService) {
        this.configurationService = confService;
    }

    public synchronized void unsetConfigurationService() {
        this.configurationService = null;
    }

    public void activate(Map<String, Object> properties) {
        logger.info("activating...");
        this.updated(properties);
        logger.info("activating...done");
    }

    public void updated(Map<String, Object> properties) {
        if (Objects.isNull(properties)) {
            throw new IllegalArgumentException("Properties cannot be null!");
        }
        try {
            ContainerInstanceOptions newOptions = new ContainerInstanceOptions(properties);
            if (this.currentOptions != null && this.currentOptions.equals(newOptions)) {
                return;
            }
            this.currentOptions = newOptions;
            if (!this.currentOptions.getEnforcementDigest().isPresent()) {
                logger.info("Container configuration doesn't include enforcement digest. Validating with Container Signature Validation service");
                if (this.currentOptions.getSignatureTrustAnchor().isPresent()) {
                    ValidationResult containerSignatureValidated = this.validateContainerImageSignature(this.currentOptions);
                    logger.info("Container signature validation result for {}@{}({}) - {}", new Object[]{this.currentOptions.getContainerImage(), containerSignatureValidated.imageDigest().orElse("?"), this.currentOptions.getContainerImageTag(), containerSignatureValidated.isSignatureValid() ? "OK" : "FAIL"});
                    containerSignatureValidated.imageDigest().ifPresent(digest -> {
                        Map<String, Object> updatedProperties = this.updatePropertiesWithSignatureDigest(properties, (String)digest);
                        this.currentOptions = new ContainerInstanceOptions(updatedProperties);
                        this.updateSnapshotWithSignatureDigest(updatedProperties);
                    });
                } else {
                    logger.info("No trust anchor available. Signature validation skipped.");
                }
            }
            if (this.currentOptions.isEnabled()) {
                this.containerOrchestrationService.registerListener((ContainerOrchestrationServiceListener)this);
            } else {
                this.containerOrchestrationService.unregisterListener((ContainerOrchestrationServiceListener)this);
            }
            this.updateState(s -> s.onConfigurationUpdated(this.currentOptions));
        }
        catch (Exception e) {
            logger.error("Failed to create container instance. Please check configuration of container: {}. Caused by:", properties.get("kura.service.pid"), (Object)e);
            this.updateState(State::onDisabled);
        }
    }

    public void deactivate() {
        logger.info("deactivate...");
        this.updateState(State::onDisabled);
        this.executor.shutdown();
        this.containerOrchestrationService.unregisterListener((ContainerOrchestrationServiceListener)this);
        logger.info("deactivate...done");
    }

    public synchronized String getState() {
        return this.state.getClass().getSimpleName();
    }

    public void onConnect() {
        this.updateState(State::onConnect);
    }

    public void onDisconnect() {
    }

    public void onDisabled() {
        this.updateState(State::onDisabled);
    }

    private ValidationResult validateContainerImageSignature(ContainerInstanceOptions configuration) {
        if (Objects.isNull(this.availableContainerSignatureValidationService) || this.availableContainerSignatureValidationService.isEmpty()) {
            logger.warn("No container signature validation service available. Signature validation failed.");
            return FAILED_VALIDATION;
        }
        Optional<String> optTrustAnchor = configuration.getSignatureTrustAnchor();
        if (!optTrustAnchor.isPresent() || optTrustAnchor.get().isEmpty()) {
            logger.warn("No trust anchor available. Signature validation failed.");
            return FAILED_VALIDATION;
        }
        String trustAnchor = optTrustAnchor.get();
        boolean verifyInTransparencyLog = configuration.getSignatureVerifyTransparencyLog();
        Optional<RegistryCredentials> registryCredentials = configuration.getRegistryCredentials();
        for (ContainerSignatureValidationService validationService : this.availableContainerSignatureValidationService) {
            ValidationResult results = FAILED_VALIDATION;
            try {
                results = registryCredentials.isPresent() ? validationService.verify(configuration.getContainerImage(), configuration.getContainerImageTag(), trustAnchor, verifyInTransparencyLog, registryCredentials.get()) : validationService.verify(configuration.getContainerImage(), configuration.getContainerImageTag(), trustAnchor, verifyInTransparencyLog);
            }
            catch (KuraException e) {
                logger.warn("Error validating container signature with {}. Setting validation results as FAILED. Caused by: ", validationService.getClass(), (Object)e);
            }
            if (!results.isSignatureValid()) continue;
            return results;
        }
        return FAILED_VALIDATION;
    }

    private synchronized void updateState(UnaryOperator<State> update) {
        State previous = this.state;
        State newState = (State)update.apply(previous);
        logger.info("State update: {} -> {}", (Object)previous.getClass().getSimpleName(), (Object)newState.getClass().getSimpleName());
        this.state = newState;
    }

    private Optional<ContainerInstanceDescriptor> getExistingContainerByName(String containerName) {
        return this.containerOrchestrationService.listContainerDescriptors().stream().filter(c -> c.getContainerName().equals(containerName)).findAny();
    }

    private Map<String, Object> updatePropertiesWithSignatureDigest(Map<String, Object> oldProperties, String enforcementDigest) {
        HashMap<String, Object> updatedProperties = new HashMap<String, Object>(oldProperties);
        updatedProperties.put("container.signature.enforcement.digest", enforcementDigest);
        return updatedProperties;
    }

    private void updateSnapshotWithSignatureDigest(Map<String, Object> properties) {
        try {
            this.configurationService.updateConfiguration((String)properties.get("kura.service.pid"), properties, true);
        }
        catch (KuraException ex) {
            logger.error("Impossible to update snapshot for pid {} due to {}", properties.get("kura.service.pid"), (Object)ex.getMessage());
        }
    }

    private class Created
    implements State {
        private final ContainerInstanceOptions options;
        private final String containerId;

        public Created(ContainerInstanceOptions options, String containerId) {
            this.options = options;
            this.containerId = containerId;
        }

        private void deleteContainer() {
            try {
                ContainerInstance.this.containerOrchestrationService.stopContainer(this.containerId);
            }
            catch (Exception e) {
                logger.error("Error stopping microservice {}", (Object)this.options.getContainerName(), (Object)e);
            }
            try {
                ContainerInstance.this.containerOrchestrationService.deleteContainer(this.containerId);
            }
            catch (Exception e) {
                logger.error("Error deleting microservice {}", (Object)this.options.getContainerName(), (Object)e);
            }
        }

        @Override
        public State onConfigurationUpdated(ContainerInstanceOptions options) {
            if (options.equals(this.options)) {
                return this;
            }
            this.deleteContainer();
            if (options.isEnabled()) {
                return new Starting(options);
            }
            return new Disabled(this.options);
        }

        @Override
        public State onDisabled() {
            this.deleteContainer();
            return new Disabled(this.options);
        }
    }

    private class Disabled
    implements State {
        private final ContainerInstanceOptions options;

        public Disabled(ContainerInstanceOptions options) {
            this.options = options;
        }

        @Override
        public State onConfigurationUpdated(ContainerInstanceOptions options) {
            return this.updateStateInternal(options);
        }

        @Override
        public State onConnect() {
            return this.updateStateInternal(this.options);
        }

        private State updateStateInternal(ContainerInstanceOptions newOptions) {
            Optional existingContainer;
            boolean isInstanceEnabled = newOptions.isEnabled();
            try {
                existingContainer = ContainerInstance.this.getExistingContainerByName(newOptions.getContainerConfiguration().getContainerName());
            }
            catch (Exception e) {
                logger.warn("failed to get existing container state", (Throwable)e);
                return new Disabled(newOptions);
            }
            if (existingContainer.isPresent()) {
                logger.info("found existing container with name {}", (Object)newOptions.getContainerConfiguration().getContainerName());
                if (isInstanceEnabled) {
                    return new Starting(newOptions);
                }
                return new Created(newOptions, ((ContainerInstanceDescriptor)existingContainer.get()).getContainerId()).onDisabled();
            }
            if (isInstanceEnabled) {
                return new Starting(newOptions);
            }
            return new Disabled(newOptions);
        }
    }

    private class Starting
    implements State {
        private final ContainerInstanceOptions options;
        private final Future<?> startupFuture;

        public Starting(ContainerInstanceOptions options) {
            this.options = options;
            this.startupFuture = ContainerInstance.this.executor.submit(() -> this.startMicroservice(options));
        }

        @Override
        public State onConfigurationUpdated(ContainerInstanceOptions newOptions) {
            if (newOptions.equals(this.options)) {
                return this;
            }
            this.startupFuture.cancel(true);
            if (newOptions.isEnabled()) {
                return new Starting(newOptions);
            }
            return new Disabled(newOptions);
        }

        @Override
        public State onContainerReady(String containerId) {
            return new Created(this.options, containerId);
        }

        @Override
        public State onStartupFailure() {
            return new Disabled(this.options);
        }

        @Override
        public State onDisabled() {
            this.startupFuture.cancel(true);
            try {
                Optional existingInstance = ContainerInstance.this.getExistingContainerByName(this.options.getContainerName());
                if (existingInstance.isPresent()) {
                    return new Created(this.options, ((ContainerInstanceDescriptor)existingInstance.get()).getContainerId()).onDisabled();
                }
            }
            catch (Exception e) {
                logger.warn("failed to check container state", (Throwable)e);
            }
            return new Disabled(this.options);
        }

        private void startMicroservice(ContainerInstanceOptions options) {
            boolean unlimitedRetries = options.isUnlimitedRetries();
            int maxRetries = options.getMaxDownloadRetries();
            int retryInterval = options.getRetryInterval();
            ContainerConfiguration containerConfiguration = options.getContainerConfiguration();
            int retries = 0;
            while ((unlimitedRetries || retries < maxRetries) && !Thread.currentThread().isInterrupted()) {
                try {
                    logger.info("Tentative number: {}", (Object)retries);
                    if (retries > 0) {
                        Thread.sleep(retryInterval);
                    }
                    String containerId = ContainerInstance.this.containerOrchestrationService.startContainer(containerConfiguration);
                    ContainerInstance.this.updateState(s -> s.onContainerReady(containerId));
                    return;
                }
                catch (InterruptedException interruptedException) {
                    logger.info("interrupted exiting");
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (KuraException e) {
                    logger.error("Error managing microservice state", (Throwable)e);
                    if (unlimitedRetries) continue;
                    ++retries;
                }
            }
            ContainerInstance.this.updateState(State::onStartupFailure);
            logger.warn("Unable to start microservice...giving up");
        }
    }

    private static interface State {
        default public State onConnect() {
            return this;
        }

        default public State onConfigurationUpdated(ContainerInstanceOptions options) {
            return this;
        }

        default public State onContainerReady(String containerId) {
            return this;
        }

        default public State onStartupFailure() {
            return this;
        }

        default public State onDisabled() {
            return this;
        }
    }
}

