/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.settings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.Tab;
import org.eclipse.kura.web.client.ui.settings.ApplicationCertsTabUi;
import org.eclipse.kura.web.client.ui.settings.DeviceCertsTabUi;
import org.eclipse.kura.web.client.ui.settings.SecurityTabUi;
import org.eclipse.kura.web.client.ui.settings.ServerCertsTabUi;
import org.eclipse.kura.web.client.ui.settings.SnapshotsTabUi;
import org.eclipse.kura.web.client.ui.settings.SslTabUi;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.service.GwtSecurityService;
import org.eclipse.kura.web.shared.service.GwtSecurityServiceAsync;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.html.Paragraph;

public class SettingsPanelUi
extends Composite {
    private static SettingsPanelUiUiBinder uiBinder = (SettingsPanelUiUiBinder)GWT.create(SettingsPanelUiUiBinder.class);
    private static final Logger logger = Logger.getLogger(SettingsPanelUi.class.getSimpleName());
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final GwtSecurityServiceAsync gwtSecurityService = (GwtSecurityServiceAsync)GWT.create(GwtSecurityService.class);
    GwtSession session;
    @UiField
    SnapshotsTabUi snapshotsPanel;
    @UiField
    ApplicationCertsTabUi appCertPanel;
    @UiField
    SslTabUi sslConfigPanel;
    @UiField
    ServerCertsTabUi serverCertPanel;
    @UiField
    DeviceCertsTabUi deviceCertPanel;
    @UiField
    SecurityTabUi securityPanel;
    @UiField
    TabListItem snapshots;
    @UiField
    TabListItem appCert;
    @UiField
    TabListItem sslConfig;
    @UiField
    TabListItem serverCert;
    @UiField
    TabListItem deviceCert;
    @UiField
    TabListItem security;
    @UiField
    HTMLPanel settingsIntro;

    public SettingsPanelUi() {
        logger.log(Level.FINER, "Initiating SettingsPanelUI...");
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        Paragraph description = new Paragraph();
        description.setText(MSGS.settingsIntro());
        this.settingsIntro.add((Widget)description);
        this.snapshots.setVisible(true);
        AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Boolean result) {
                if (result.booleanValue()) {
                    SettingsPanelUi.this.appCert.setVisible(true);
                    SettingsPanelUi.this.security.setVisible(true);
                }
            }
        };
        this.gwtSecurityService.isSecurityServiceAvailable(callback);
        this.snapshots.addClickHandler((ClickHandler)new Tab.RefreshHandler(this.snapshotsPanel));
        this.sslConfig.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SettingsPanelUi.this.sslConfigPanel.load();
            }
        });
        this.serverCert.addClickHandler((ClickHandler)new Tab.RefreshHandler(this.serverCertPanel));
        this.deviceCert.addClickHandler((ClickHandler)new Tab.RefreshHandler(this.deviceCertPanel));
        this.security.addClickHandler((ClickHandler)new Tab.RefreshHandler(this.securityPanel));
    }

    public void load() {
        if (!this.snapshotsPanel.isDirty()) {
            this.snapshotsPanel.refresh();
        }
    }

    public void setSession(GwtSession currentSession) {
        this.session = currentSession;
    }

    public boolean isDirty() {
        boolean snapshotsDirty = this.snapshotsPanel.isDirty();
        boolean appCertDirty = this.appCertPanel.isDirty();
        boolean sslConfigDirty = this.sslConfigPanel.isDirty();
        boolean serverCertDirty = this.serverCertPanel.isDirty();
        boolean deviceCertDirty = this.deviceCertPanel.isDirty();
        boolean securityDirty = this.securityPanel.isDirty();
        return snapshotsDirty || appCertDirty || sslConfigDirty || serverCertDirty || deviceCertDirty || securityDirty;
    }

    public void setDirty(boolean b) {
        this.snapshotsPanel.setDirty(b);
        this.appCertPanel.setDirty(b);
        this.sslConfigPanel.setDirty(b);
        this.serverCertPanel.setDirty(b);
        this.deviceCertPanel.setDirty(b);
        this.securityPanel.setDirty(b);
    }

    static interface SettingsPanelUiUiBinder
    extends UiBinder<Widget, SettingsPanelUi> {
    }
}

