/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.transport.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.tigris.mtoolkit.iagent.transport.TransportConnection;

public class SocketTransportConnection
implements TransportConnection {
    private String host;
    private int port;
    private Socket socket;
    private volatile boolean closed;
    private static boolean preJava14EE = false;

    public SocketTransportConnection(String host, int port, int timeout) throws IOException {
        this.host = host;
        this.port = port;
        this.socket = new Socket(host, port);
        try {
            this.setKeepAlive(this.socket, true);
        }
        catch (SocketException socketException) {}
        if (timeout > 0) {
            this.socket.setSoTimeout(timeout);
        }
    }

    private void setKeepAlive(Socket socket, boolean keepAlive) throws SocketException {
        if (preJava14EE) {
            return;
        }
        try {
            socket.setKeepAlive(keepAlive);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            preJava14EE = false;
        }
    }

    public void close() {
        this.closed = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public boolean isClosed() {
        if (this.closed) {
            return true;
        }
        return SocketTransportConnection.isSocketClosed(this.socket);
    }

    private static boolean isSocketClosed(Socket socket) {
        if (preJava14EE) {
            return false;
        }
        try {
            return socket.isClosed();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            preJava14EE = true;
            return false;
        }
    }

    public String toString() {
        return "SocketTransportConnection: " + this.host + ":" + this.port;
    }
}

