/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.cheatsheet.comp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.IWorkspaceModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ua.core.cheatsheet.comp.CompCSModel;

public class CompCSWorkspaceModel
extends CompCSModel
implements IWorkspaceModel {
    private final IFile fFile;
    private boolean fDirty;
    private final boolean fEditable;
    private static final long serialVersionUID = 1L;

    public CompCSWorkspaceModel(IFile file, boolean editable) {
        this.fFile = file;
        this.fEditable = editable;
    }

    public void save() {
        String contents = this.getContents();
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));){
                if (this.fFile.exists()) {
                    this.fFile.setContents((InputStream)stream, false, false, null);
                } else {
                    this.fFile.create((InputStream)stream, false, null);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            PDECore.logException((Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.setLoaded(true);
        this.save(writer);
        return swriter.toString();
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            this.getCompCS().write("", writer);
        }
        this.setDirty(false);
    }

    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public void fireModelChanged(IModelChangedEvent event) {
        this.setDirty(true);
        super.fireModelChanged(event);
    }

    @Override
    public boolean isEditable() {
        return this.fEditable;
    }

    public String getInstallLocation() {
        return this.fFile.getLocation().toOSString();
    }

    public IResource getUnderlyingResource() {
        return this.fFile;
    }

    @Override
    public boolean isInSync() {
        return this.isResourceInSync();
    }

    @Override
    public void load() throws CoreException {
        if (this.fFile.exists()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedInputStream stream = new BufferedInputStream(this.fFile.getContents(true));){
                    if (((InputStream)stream).available() > 0) {
                        this.load(stream, false);
                    } else {
                        this.setLoaded(true);
                        ((InputStream)stream).close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException throwable) {
                // empty catch block
            }
        }
    }

    public void reload() {
        if (this.fFile.exists()) {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(this.fFile.getContents(true));
                this.reload(stream, false);
                this.setDirty(false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

