/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public final class JoinVariableFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public JoinVariableFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] operations) {
        super(name, compilationUnit, operations);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JoinVariableFixCore createJoinVariableFix(CompilationUnit compilationUnit, ASTNode node) {
        ASTNode parent = node.getParent();
        VariableDeclarationFragment fragment = null;
        boolean onFirstAccess = false;
        if (node instanceof SimpleName && node.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
            onFirstAccess = true;
            SimpleName name = (SimpleName)node;
            IBinding binding = name.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return null;
            }
            ASTNode declaring = compilationUnit.findDeclaringNode(binding);
            if (!(declaring instanceof VariableDeclarationFragment)) return null;
            fragment = (VariableDeclarationFragment)declaring;
        } else {
            if (!(parent instanceof VariableDeclarationFragment)) return null;
            fragment = (VariableDeclarationFragment)parent;
        }
        IVariableBinding binding = fragment.resolveBinding();
        Expression initializer = fragment.getInitializer();
        if (initializer != null && initializer.getNodeType() != 33 || binding == null || binding.isField()) {
            return null;
        }
        if (!(fragment.getParent() instanceof VariableDeclarationStatement)) {
            return null;
        }
        VariableDeclarationStatement statement = (VariableDeclarationStatement)fragment.getParent();
        SimpleName[] names = LinkedNodeFinder.findByBinding(statement.getParent(), (IBinding)binding);
        if (names.length <= 1 || names[0] != fragment.getName()) {
            return null;
        }
        SimpleName firstAccess = names[1];
        if (onFirstAccess ? firstAccess != node : firstAccess.getLocationInParent() != Assignment.LEFT_HAND_SIDE_PROPERTY) {
            return null;
        }
        Assignment assignment = (Assignment)firstAccess.getParent();
        if (assignment.getLocationInParent() != ExpressionStatement.EXPRESSION_PROPERTY) {
            return null;
        }
        ExpressionStatement assignParent = (ExpressionStatement)assignment.getParent();
        IfStatement ifStatement = null;
        Expression thenExpression = null;
        Expression elseExpression = null;
        ASTNode assignParentParent = assignParent.getParent();
        if (assignParentParent instanceof IfStatement || assignParentParent.getLocationInParent() == IfStatement.THEN_STATEMENT_PROPERTY && !assignParentParent.subtreeMatch(new ASTMatcher(), (Object)statement.getParent())) {
            if (assignParentParent.getLocationInParent() == IfStatement.THEN_STATEMENT_PROPERTY) {
                assignParentParent = assignParentParent.getParent();
            }
            ifStatement = (IfStatement)assignParentParent;
            Statement thenStatement = JoinVariableFixCore.getSingleStatement(ifStatement.getThenStatement());
            Statement elseStatement = JoinVariableFixCore.getSingleStatement(ifStatement.getElseStatement());
            if (thenStatement == null || elseStatement == null) {
                return null;
            }
            if (thenStatement instanceof ExpressionStatement && elseStatement instanceof ExpressionStatement) {
                Expression inner1 = ((ExpressionStatement)thenStatement).getExpression();
                Expression inner2 = ((ExpressionStatement)elseStatement).getExpression();
                if (inner1 instanceof Assignment && inner2 instanceof Assignment) {
                    IBinding bind2;
                    IBinding bind1;
                    Assignment assign1 = (Assignment)inner1;
                    Assignment assign2 = (Assignment)inner2;
                    Expression left1 = assign1.getLeftHandSide();
                    Expression left2 = assign2.getLeftHandSide();
                    if (left1 instanceof Name && left2 instanceof Name && assign1.getOperator() == assign2.getOperator() && (bind1 = ((Name)left1).resolveBinding()) == (bind2 = ((Name)left2).resolveBinding()) && bind1 instanceof IVariableBinding) {
                        thenExpression = assign1.getRightHandSide();
                        elseExpression = assign2.getRightHandSide();
                    }
                }
            }
            if (thenExpression != null && elseExpression != null) return new JoinVariableFixCore(CorrectionMessages.QuickAssistProcessor_joindeclaration_description, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{new JoinVariableProposalOperation(statement, ifStatement, assignParent, thenExpression, elseExpression, fragment, onFirstAccess, assignment)});
            return null;
        }
        ASTNode statementParent = statement.getParent();
        ASTMatcher matcher = new ASTMatcher();
        for (ASTNode n = assignParent.getParent(); n != null; n = n.getParent()) {
            if (n.getNodeType() == statementParent.getNodeType() && n.subtreeMatch(matcher, (Object)statementParent)) return new JoinVariableFixCore(CorrectionMessages.QuickAssistProcessor_joindeclaration_description, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{new JoinVariableProposalOperation(statement, ifStatement, assignParent, thenExpression, elseExpression, fragment, onFirstAccess, assignment)});
            if (!(n instanceof Block)) return null;
        }
        return new JoinVariableFixCore(CorrectionMessages.QuickAssistProcessor_joindeclaration_description, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{new JoinVariableProposalOperation(statement, ifStatement, assignParent, thenExpression, elseExpression, fragment, onFirstAccess, assignment)});
    }

    private static Statement getSingleStatement(Statement statement) {
        if (statement instanceof Block) {
            List blockStatements = ((Block)statement).statements();
            if (blockStatements.size() != 1) {
                return null;
            }
            return (Statement)blockStatements.get(0);
        }
        return statement;
    }

    private static class JoinVariableProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private VariableDeclarationStatement statement;
        private IfStatement ifStatement;
        private ExpressionStatement assignParent;
        private Expression thenExpression;
        private Expression elseExpression;
        private VariableDeclarationFragment fragment;
        private boolean onFirstAccess;
        private Assignment assignment;

        public JoinVariableProposalOperation(VariableDeclarationStatement statement, IfStatement ifStatement, ExpressionStatement assignParent, Expression thenExpression, Expression elseExpression, VariableDeclarationFragment fragment, boolean onFirstAccess, Assignment assignment) {
            this.statement = statement;
            this.ifStatement = ifStatement;
            this.assignParent = assignParent;
            this.thenExpression = thenExpression;
            this.elseExpression = elseExpression;
            this.fragment = fragment;
            this.onFirstAccess = onFirstAccess;
            this.assignment = assignment;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getAST();
            TightSourceRangeComputer sourceRangeComputer = new TightSourceRangeComputer();
            sourceRangeComputer.addTightSourceNode((ASTNode)(this.ifStatement != null ? this.ifStatement : this.assignParent));
            rewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)sourceRangeComputer);
            if (this.ifStatement != null) {
                ConditionalExpression conditionalExpression = ast.newConditionalExpression();
                Expression conditionCopy = (Expression)rewrite.createCopyTarget((ASTNode)this.ifStatement.getExpression());
                conditionalExpression.setExpression(conditionCopy);
                Expression thenCopy = (Expression)rewrite.createCopyTarget((ASTNode)this.thenExpression);
                Expression elseCopy = (Expression)rewrite.createCopyTarget((ASTNode)this.elseExpression);
                JoinVariableProposalOperation.addExplicitTypeArgumentsIfNecessary(rewrite, cuRewrite, this.thenExpression);
                JoinVariableProposalOperation.addExplicitTypeArgumentsIfNecessary(rewrite, cuRewrite, this.elseExpression);
                conditionalExpression.setThenExpression(thenCopy);
                conditionalExpression.setElseExpression(elseCopy);
                rewrite.set((ASTNode)this.fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY, (Object)conditionalExpression, null);
                rewrite.remove((ASTNode)this.ifStatement, null);
            } else {
                Expression placeholder = (Expression)rewrite.createMoveTarget((ASTNode)this.assignment.getRightHandSide());
                rewrite.set((ASTNode)this.fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY, (Object)placeholder, null);
                if (this.onFirstAccess) {
                    rewrite.replace((ASTNode)this.assignParent, rewrite.createMoveTarget((ASTNode)this.statement), null);
                } else if (ASTNodes.isControlStatementBody(this.assignParent.getLocationInParent())) {
                    Block block = ast.newBlock();
                    rewrite.replace((ASTNode)this.assignParent, (ASTNode)block, null);
                } else {
                    rewrite.remove((ASTNode)this.assignParent, null);
                }
            }
        }

        private static void addExplicitTypeArgumentsIfNecessary(ASTRewrite rewrite, CompilationUnitRewrite proposal, Expression invocation) {
            if (Invocations.isResolvedTypeInferredFromExpectedType(invocation)) {
                MethodInvocation methodInvocation;
                Object expression;
                ITypeBinding[] typeArguments = Invocations.getInferredTypeArguments(invocation);
                if (typeArguments == null) {
                    return;
                }
                ImportRewrite importRewrite = proposal.getImportRewrite();
                ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)invocation, importRewrite);
                AST ast = invocation.getAST();
                ListRewrite typeArgsRewrite = Invocations.getInferredTypeArgumentsRewrite(rewrite, invocation);
                ITypeBinding[] iTypeBindingArray = typeArguments;
                int n = typeArguments.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding typeArgument = iTypeBindingArray[n2];
                    Type typeArgumentNode = importRewrite.addImport(typeArgument, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.TYPE_ARGUMENT);
                    typeArgsRewrite.insertLast((ASTNode)typeArgumentNode, null);
                    ++n2;
                }
                if (invocation instanceof MethodInvocation && (expression = (methodInvocation = (MethodInvocation)invocation).getExpression()) == null) {
                    IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                    expression = methodBinding != null && Modifier.isStatic((int)methodBinding.getModifiers()) ? ast.newName(importRewrite.addImport(methodBinding.getDeclaringClass().getTypeDeclaration(), (ImportRewrite.ImportRewriteContext)importRewriteContext)) : ast.newThisExpression();
                    rewrite.set((ASTNode)invocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, expression, null);
                }
            }
        }
    }
}

