/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.ejbembed;

import com.sun.ts.tests.common.vehicle.ejbliteshare.EJBLiteClientIF;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBs;
import jakarta.ejb.embeddable.EJBContainer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;

public class InjectionResolver {
    private static final Logger logger = Logger.getLogger("com.sun.ts.tests.common.vehicle.ejbembed");
    private EJBContainer container;
    private EJBLiteClientIF client;
    private List<Method> postConstructMethods = new ArrayList<Method>();

    public InjectionResolver(EJBLiteClientIF client, EJBContainer container) {
        this.client = client;
        this.container = container;
    }

    public void resolve() {
        this.resolve0(this.client.getClass());
        this.invokePostConstructMethods();
    }

    public void resolve0(Class<? extends EJBLiteClientIF> cls) {
        Class<? extends EJBLiteClientIF> sup = cls.getSuperclass();
        if (sup != null && EJBLiteClientIF.class.isAssignableFrom(sup)) {
            this.resolve0(sup);
        }
        this.resolveTypeLevelInjections(cls);
        this.resolveFieldInjections(cls);
        this.resolveSetterInjections(cls);
        this.resolvePostConstruct(cls);
        logger.info("Resolved " + String.valueOf(cls));
    }

    private void resolvePostConstruct(Class<? extends EJBLiteClientIF> cls) {
        Method[] methods;
        for (Method m : methods = cls.getDeclaredMethods()) {
            PostConstruct pc = m.getAnnotation(PostConstruct.class);
            if (pc == null) continue;
            this.postConstructMethods.add(m);
        }
    }

    private void invokePostConstructMethods() {
        for (Method m : this.postConstructMethods) {
            m.setAccessible(true);
            try {
                m.invoke((Object)this.client, new Object[0]);
                logger.info("Invoked PostConstruct method: " + String.valueOf(m));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void resolveSetterInjections(Class<? extends EJBLiteClientIF> cls) {
        Method[] methods;
        for (Method m : methods = cls.getDeclaredMethods()) {
            EJB b = m.getAnnotation(EJB.class);
            if (b == null) continue;
            logger.info("Resolving setter @EJB injection: " + String.valueOf(b));
            String lookup = b.lookup();
            if (lookup.length() > 0 && lookup.startsWith("java:global")) {
                logger.info("Got @EJB.lookup " + lookup);
            } else {
                Class<?> beanInterface = b.beanInterface();
                String beanName = b.beanName();
                if (beanInterface.equals(Object.class)) {
                    Class<?>[] paramTypes = m.getParameterTypes();
                    beanInterface = paramTypes[0];
                }
                if (beanName.length() == 0) {
                    beanName = this.getBeanNameFromDescription(b.description());
                }
                if (beanName.length() == 0) {
                    throw new RuntimeException("beanName is not specified in @EJB injection on method " + m.toString());
                }
                lookup = this.createGlobalJNDIName(beanInterface, beanName);
            }
            Object beanFromLookup = this.lookup(lookup);
            m.setAccessible(true);
            try {
                m.invoke((Object)this.client, beanFromLookup);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void resolveFieldInjections(Class<? extends EJBLiteClientIF> cls) {
        Field[] fields;
        for (Field f : fields = cls.getDeclaredFields()) {
            EJB b = f.getAnnotation(EJB.class);
            if (b == null) continue;
            logger.info("Resolving field @EJB injection: " + String.valueOf(b));
            String lookup = b.lookup();
            if (lookup.length() > 0 && lookup.startsWith("java:global")) {
                logger.info("Got @EJB.lookup " + lookup);
            } else {
                Class<?> beanInterface = b.beanInterface();
                String beanName = b.beanName();
                if (beanInterface.equals(Object.class)) {
                    beanInterface = f.getType();
                }
                if (beanName.length() == 0) {
                    beanName = this.getBeanNameFromDescription(b.description());
                }
                if (beanName.length() == 0) {
                    throw new RuntimeException("beanName is not specified in @EJB injection on field " + f.toString());
                }
                lookup = this.createGlobalJNDIName(beanInterface, beanName);
            }
            Object beanFromLookup = this.lookup(lookup);
            f.setAccessible(true);
            try {
                f.set(this.client, beanFromLookup);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getBeanNameFromDescription(String description) {
        String[] tokens = description.split("=");
        String beanName = "";
        if (tokens.length == 2) {
            beanName = tokens[1];
            logger.info("Got beanName indirectly from description: " + beanName);
        }
        return beanName;
    }

    private void resolveTypeLevelInjections(Class<? extends EJBLiteClientIF> cls) {
        EJBs ejbs = cls.getAnnotation(EJBs.class);
        EJB ejb = cls.getAnnotation(EJB.class);
        if (ejbs != null) {
            for (EJB b : ejbs.value()) {
                this.resolveTypeLevelEJB(b);
            }
        }
        if (ejb != null) {
            this.resolveTypeLevelEJB(ejb);
        }
    }

    private void resolveTypeLevelEJB(EJB b) {
        logger.info("Resolving type-level @EJB injection: " + String.valueOf(b));
        Class beanInterface = b.beanInterface();
        String beanName = b.beanName();
        String name = b.name();
        String lookup = b.lookup();
        if (lookup.length() > 0 && lookup.startsWith("java:global")) {
            logger.info("Got @EJB.lookup " + lookup);
        } else {
            lookup = this.createGlobalJNDIName(beanInterface, beanName);
        }
        this.client.getJndiMapping().put(this.createJavaEELookupName(name), lookup);
    }

    private String createJavaEELookupName(String name) {
        return "java:comp/env/" + name;
    }

    private String createGlobalJNDIName(Class<?> beanInterface, String beanName) {
        Object result = "java:global/";
        result = (String)result + this.client.getModuleName() + "/" + beanName + "!" + beanInterface.getName();
        logger.info("Constructed portable global jndi name: " + (String)result);
        return result;
    }

    private Object lookup(String lookupName) {
        Object result = null;
        Context context = this.container.getContext();
        try {
            result = context.lookup(lookupName);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

